#!/usr/bin/env python
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2013
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# service_restart.py
#
# code effectif de la relance d'un service par Zéphir
# à lancer par service_restart.zephir <nom_service>
###########################################################################

import os, sys, json
from zephir.lib_zephir import *
from creole import config
from pyeole.process import system_code
from pyeole.service import manage_service, unmanaged_service, UnknownServiceError, ServiceError

def do_restart(service, ignore_missing=False):
    """redémarre le service demandé. Si nécessaire redémarre les instances
    du service lancés dans les conteneurs
    """
    if not is_locked(['reconfigure','maj','configure','sauvegarde']):
        lock(['reconfigure'])
        cont_ok = []
        cont_err = []
        mode_container = False
        try:
            try:
                if creole_vars.get_creole('mode_conteneur_actif', u'non').lower() == u'oui':
                    mode_container = True
                containers = creole_vars.get_groups()
                try:
                    # on essaye d'abord une relance gérée par Creole
                    manage_service(u'restart', service)
                    cont_ok = containers
                except UnknownServiceError, err:
                    # service non géré par creole, on utilise unmanaged_service
                    fails = []
                    for container in containers:
                        try:
                            unmanaged_service(u'restart', service, u'upstart', container)
                            cont_ok.append(container)
                        except UnknownServiceError, err:
                            # non reconnu en méthode upstart, essai avec 'service'
                            unmanaged_service(u'restart', service, u'service', container)
                        except ServiceError, err:
                            cont_err.append(container)
                            fails.append(err)
                    if fails:
                        raise ServiceError(u'\n'.join([u'{0}'.format(err) for err in fails]))
            except ServiceError, err:
                # la gestion des erreurs dans chaque conteneur est gérée par manage_service
                if ignore_missing and str(err).strip().endswith('not found.'):
                    # pas de configuration pour ce service, pas de message
                    # à Zéphir si ignore_missing est à True
                    print "Service non redémarré: {0} (absent)".format(service)
                    unlock(['reconfigure'])
                    exit(0)
                else:
                    log('SERVICE_RESTART', 1, u"Erreur lors du redémarrage du service {0} {1}".format(service, err))
                    unlock(['reconfigure'])
                    exit(1)
        except Exception, e:
            log('SERVICE_RESTART', 1, 'Erreur interne lors du redémarrage du service %s : %s' % (service, str(e)))
            unlock(['reconfigure'])
            exit(1)
        unlock(['reconfigure'])
        if mode_container:
            msg_container = " dans le(s) conteneur(s): %s" % ",".join(cont_ok)
        else:
            msg_container = ""
        log('SERVICE_RESTART', 0, 'service %s relancé%s' % (service, msg_container))
        # génération du message de retour suivant le résultat dans chaque conteneur
        if cont_err:
            if mode_container:
                msg_err_container = " dans le(s) conteneur(s): %s" % ",".join(cont_err)
            else:
                msg_err_container = ""
            log('SERVICE_RESTART', 1, 'Erreur lors du redémarrage du service %s%s' % (service, msg_err_container))
    else:
        # une tache lancée par zephir n'est pas (ou mal) terminée
        # on n'autorise pas reconfigure dans cet état
        log('SERVICE_RESTART',1,"""une tache concurrente est en exécution: verrou dans /var/lock/""")

def cancel_restart(service):
    """
    déprogramme les relances de service déjà programmées
    """
    cmd = """for i in `grep -l "service_restart.py %s" /var/spool/cron/atjobs/* 2>/dev/null`; do rm -f $i ;  done;""" % service
    os.system(cmd)
    return True

def prog_restart_differe(delay, service):
    """
    Programmation d'une relance de service différé de quelques heures
    Il est lancé via la commande at pour l'utilisateur root
    """
    # suppression des éventuelles autres maj différées
    cancel_restart(service)
    stdin = "python /usr/share/zephir/scripts/service_restart.py %s\n" % (service)
    # lancement avec at
    ret = system_code(['/usr/bin/at', 'now', '+', delay], stdin=stdin, env={'PATH': '/usr/share/eole:/usr/share/eole/sbin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin'})
    if ret != 0:
        return False
    return True

if __name__ == '__main__':
    try:
        service = sys.argv[1]
    except:
        print "Erreur, arguments manquants"
    do_restart(service)
