# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Singleton contenant les données globales de configuration.

Usage :
  from zephir.monitor.agentmanager import config as cfg
  cfg.whatever_you_need
"""

try: _ # localized string fetch function
except NameError: _ = str

import os
from datetime import datetime
try:
    from zephir.zephir_conf.zephir_conf import id_serveur
except:
    id_serveur = 0
from ConfigParser import ConfigParser

CONFIG_FILE = '/var/lib/eole/config/zstats.cfg'

if not os.path.isfile(CONFIG_FILE):
    print("Fichier de configuration non existant")
    exit(0)

cfg = ConfigParser(allow_no_value=True)
cfg.read(CONFIG_FILE)


# VERSION DE DISTRIBUTION EOLE
distrib_version = 7

DEFAULT_CONFIG = {
    'host_ref': str(id_serveur), #zephircfg.id_serveur

    'webserver_port': 8090,
    'static_web_dir': os.path.join(os.path.curdir, 'static'),
    'static_base_url': '/static',

    'tmp_data_dir': os.path.join(os.path.curdir, 'data'),
    'config_dir': os.path.join(os.path.curdir, 'configs'),
    'state_dir': os.path.join(os.path.curdir, 'stats'),
    'uucp_dir': os.path.join(os.path.curdir, 'uucp'),
    'action_dir':  os.path.join(os.path.curdir, 'actions'),

    'upload_period': 600,
    }

# dans le cas de zephir, on garde toujours le répertoire 0 au lieu de
# l'identifiant zephir pour éviter un conflit avec les serveurs clients enregistrés
if os.path.isdir('/var/lib/zephir'):
    DEFAULT_CONFIG['host_ref'] = "0"


def client_data_dir(config, client_name):
    return os.path.join(config['state_dir'],
                        client_name)


def agent_data_dir(config, client_name, agent_name):
    return os.path.join(client_data_dir(config, client_name),
                        agent_name)


def agent_metadata_file(config, client_name, agent_name):
    return os.path.join(agent_data_dir(config, client_name, agent_name),
                        "agent.xml")


# internal constants
RRD_TIME_ORIGIN = datetime(1970,1,1)
NOM_MACHINE = cfg.get('eole', 'nom_machine')
NOM_MACHINE_ETH = cfg.get('eole', 'nom_machine_eth').split()
ACTIVER_EAD_WEB = cfg.getboolean('service', 'activer_ead_web')
EOLE_MODULE = cfg.get('eole', 'eole_module')
EOLE_VERSION = cfg.get('eole', 'eole_version')
EOLE_RELEASE = cfg.get('eole', 'eole_release')
MODE_CONTENEUR_ACTIF = cfg.get('eole', 'mode_conteneur_actif')
HAS_TYPE_AMON = cfg.getboolean('eole', 'has_type_amon')
ADRESSE_IP_ANNUAIRE = cfg.get('eole', 'adresse_ip_annuaire')
ADRESSE_IP_MAIL = cfg.get('eole', 'adresse_ip_mail')
ADRESSE_IMAP = cfg.get('eole', 'adresse_imap')
GROUPS = cfg.get('eole', 'groups').split()
ADRESSE_IP_SERVICE_WEB = cfg.get('eole', 'adresse_ip_service_web')
HAS_ADRESSE_IP_GW = cfg.getboolean('eole', 'has_adresse_ip_gw')
NOMBRE_INTERFACES = cfg.getint('eole', 'nombre_interfaces')
NOM_ZONE_ETH0 = cfg.get('eole', 'nom_zone_eth0')
NOM_ZONE_ETH1 = cfg.get('eole', 'nom_zone_eth1')
NOM_ZONE_ETH2 = cfg.get('eole', 'nom_zone_eth2')
NOM_ZONE_ETH3 = cfg.get('eole', 'nom_zone_eth3')
NOM_ZONE_ETH4 = cfg.get('eole', 'nom_zone_eth4')
ACTIVER_CUPS = cfg.getboolean('service', 'activer_cups')
ACTIVER_DHCP = cfg.getboolean('service', 'activer_dhcp')
ACTIVER_FIREWALL = cfg.getboolean('service', 'activer_firewall')
ACTIVER_BAREOS_DIR = cfg.getboolean('service', 'activer_bareos_dir')
ACTIVER_BAREOS_SD = cfg.getboolean('service', 'activer_bareos_sd')
INSTALL_RVP = cfg.getboolean('service', 'install_rvp')
ACTIVER_NUT = cfg.getboolean('service', 'activer_nut')
ACTIVER_SSO_LOCAL = cfg.getboolean('service', 'activer_sso_local')
ACTIVER_CLIENT_LDAP_LOCAL = cfg.getboolean('service', 'activer_client_ldap_local')
ACTIVER_FILTRAGE_PROXY = cfg.getboolean('service', 'activer_filtrage_proxy')
ACTIVER_SPAMASSASSIN = cfg.getboolean('service', 'activer_spamassassin')
ACTIVER_COURIER_POP = cfg.getboolean('service', 'activer_courier_pop')
ACTIVER_COURIER_IMAP = cfg.getboolean('service', 'activer_courier_imap')
ACTIVER_APACHE = cfg.getboolean('service', 'activer_apache')
ACTIVER_SQUID2 = cfg.getboolean('service', 'activer_squid2')
ACTIVER_CLAM = cfg.getboolean('service', 'activer_clam')
ACTIVER_HAUTE_DISPO = cfg.get('service', 'activer_haute_dispo')
ACTIVER_SQUID_AUTH = cfg.getboolean('service', 'activer_squid_auth')
ACTIVER_RADIUS = cfg.getboolean('service', 'activer_radius')
SMB_VSCAN = cfg.getboolean('service', 'smb_vscan')
if ACTIVER_BAREOS_DIR or ACTIVER_BAREOS_SD:
    BAREOS_MON_PASSWORD = cfg.get('bareos', 'bareos_mon_password')
else:
    BAREOS_MON_PASSWORD = None
if ACTIVER_NUT:
    NUT_UPS_NAME = cfg.get('nut', 'nut_ups_name').split()
    NUT_UPS_HOST = cfg.get('nut', 'nut_ups_host').split()
else:
    NUT_UPS_NAME = []
    NUT_UPS_HOST = []
if ACTIVER_SSO_LOCAL:
    EOLESSO_PORT = cfg.get('sso', 'eolesso_port')
else:
    EOLESSO_PORT = None
ADRESSE_IP_SERVICE_PROXY = cfg.get('proxy', 'adresse_ip_service_proxy')
if ADRESSE_IP_SERVICE_PROXY is not None:
    ADRESSE_IP_SERVICE_PROXY = ADRESSE_IP_SERVICE_PROXY.split()
NOM_MACHINE_PROXY = cfg.get('proxy', 'nom_machine_proxy')
CONTAINER_IP_PROXY = cfg.get('proxy', 'container_ip_proxy')
PROXY2_PORT = cfg.get('proxy', 'proxy2_port')
DANSGUARDIAN_PORT3 = cfg.get('proxy', 'dansguardian_port3')
INTERFACE_PROXY = cfg.get('proxy', 'interface_proxy')
MAXCHILDREN1 = cfg.get('proxy', 'maxchildren1')
if MAXCHILDREN1 is not None:
    MAXCHILDREN1 = int(MAXCHILDREN1)
MAXCHILDREN2 = cfg.get('proxy', 'maxchildren2')
if MAXCHILDREN2 is not None:
    MAXCHILDREN2 = int(MAXCHILDREN2)
DANSGUARDIAN_ETH = cfg.get('proxy', 'dansguardian_eth')
if DANSGUARDIAN_ETH is not None:
    DANSGUARDIAN_ETH = DANSGUARDIAN_ETH.split()
SW_THREADS = cfg.getint('rvp', 'sw_threads')
NOM_MACHINE_MAITRE = cfg.get('haute_dispo', 'nom_machine_maitre')
NOM_MACHINE_ESCLAVE = cfg.get('haute_dispo', 'nom_machine_esclave')
ADRESSE_IP_DNS = cfg.get('eole', 'adresse_ip_dns').split()
TEST_DISTANT_DOMAINE = cfg.get('eole', 'test_distant_domaine').split()
ACTIVER_PROXY_CLIENT = cfg.getboolean('eole', 'activer_proxy_client')
PROXY_CLIENT_ADRESSE = cfg.get('eole', 'proxy_client_adresse')
PROXY_CLIENT_PORT = cfg.get('eole', 'proxy_client_port')
ACTIVER_MYSQL = cfg.getboolean('service', 'activer_mysql')
ADRESSE_IP_MYSQL = cfg.get('eole', 'adresse_ip_mysql')
CONTAINER_IP_DNS = cfg.get('eole', 'container_ip_dns')
ACTIVER_PROFTPD = cfg.getboolean('service', 'activer_proftpd')
ADRESSE_IP_FICHIER = cfg.get('eole', 'adresse_ip_fichier')
ACTIVER_SYMPA = cfg.getboolean('service', 'activer_sympa')
ACTIVER_POSTGRESQL = cfg.getboolean('service', 'activer_postgresql')
HORUS_FRONTEND = cfg.getboolean('service', 'horus_frontend')


IP_SUNSTONE = cfg.get('hapy', 'ip_sunstone')
VNC_PROXY_PORT_SUNSTONE = cfg.get('hapy', 'vnc_proxy_port_sunstone')
PORT_SUNSTONE = cfg.get('hapy', 'port_sunstone')
ACTIVER_ONEFLOW = cfg.getboolean('hapy', 'activer_oneflow')
IP_ONEFLOW = cfg.get('hapy', 'ip_oneflow')
PORT_ONEFLOW = cfg.get('hapy', 'port_oneflow')
