# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir listant le contenu de l'annaire LDAP
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import log
import ldap,time

class LdapHorus(Agent):

    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        """
        Gestion du status :
            par défaut : OK
            Erreur si pas de connexion
            Warning si erreur lors d'une ou plusieurs requêtes
        """
        self.status = status.OK()
        self.measure_data = {}

        #title1 = HTMLData("<h3>Nombre d'utilisateurs<h3>")
        self.table1 = TableData([
           ('name', '', {'align':'left'}, None),
           ('nb', '' , {'align':'center'}, None)
        ])

        self.data = [self.table1]

    def measure(self):
        try :
            conn=ldap.open('localhost')
        except :
            self.status = status.Error()
            return {'statistics1' : []}

        self.status = status.OK()
        self.fail = 0

        statistics1 = []
        nb_users = self._requete(conn, "(objectclass=inetOrgPerson)")
        statistics1.append (
            { 'name' : 'Nombre d\'utilisateurs',
              'nb'   : nb_users
            })
        self.measure_data['utilisateurs'] = nb_users
        nb_groups = self._requete(conn, "(objectClass=posixGroup)")
        statistics1.append (
            { 'name' : 'Nombre de groupes',
              'nb'   : nb_groups
            })
        nb_partages = self._requete(conn,"(objectClass=sambaFileShare)")
        statistics1.append (
            { 'name' : 'Nombre de partages',
              'nb'   : nb_partages
            })
        nb_computers = self._requete(conn,"(&(objectclass=posixAccount)(description=Computer))")
        statistics1.append (
            { 'name' : 'Nombre de postes',
              'nb'   : nb_computers
            })

        self.measure_data = {'utilisateurs':nb_users,
                             'groupes':nb_groups,
                             'partages':nb_partages,
                             'postes':nb_computers}
        if self.fail >= 2 :
            self.status = status.Warn()

        return {'statistics1' : statistics1}


    def _requete(self, conn, filtre):
        time.sleep(0.2)
        try:
            return len(conn.search_s("o=gouv,c=fr", ldap.SCOPE_SUBTREE, filtre, ['']))
        except:
            try:
                # 2ème tentative
                time.sleep(2)
                return len(conn.search_s("o=gouv,c=fr", ldap.SCOPE_SUBTREE, filtre, ['']))
            except Exception, e:
                log.msg('erreur ldap : %s' % str(e))
                self.fail += 1
                return '???'

    def _color(self, string):
        return "<font color=\"red\">%s</font>" % string

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table1.table_data = self.last_measure.value['statistics1']

    def check_status(self):
        return self.status

