# -*- mode: python; coding: utf-8 -*-

import re

from twisted.internet.utils import getProcessOutput

from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager.util import log
from creole.client import CreoleClient


SUPPORTED_REGEXP = r'is supported'
INSTALL_REGEXP = r'sudo apt-get'
KERNEL_REGEXP = r'(linux-image-generic\S+)'


class SambaDeprecatedVersion(Agent):
    """Check if samba is deprecated
    """

    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.name = name
        self.status = status.Unknown()
        self.message = 'Aucune mesure'

        titre = HTMLData("<h2>Version de Samba</h2>")
        self.table = TableData([
            ('status', 'État', {'align':'center'}, status_to_img),
            ('msg', 'Message', {'align':'left'}, None),
        ])

        self.data = [titre, self.table]

    def measure(self):
        creole_client = CreoleClient()
        eole_module = creole_client.get_creole('eole_module')
        if eole_module in ["scribe", "seth", "horus"]:
            self.status = status.Error()
            self.message = """La version EOLE 2.7.1 utilise une version de Samba qui a été dépréciée par la communauté Debian.<br/>
    Le Pôle ne peut plus garantir les mises à jour de sécurité pendant la période LTS d'Ubuntu.<br/>
    Nous vous conseillons vivement de basculer sur la version 2.7.2.<br/>
    Cette version a été spécifiquement créée pour installer une version maintenue du paquet Samba.<br/>
    Pour cela, exécuter les commandes :<br/>
    - Maj-Auto<br/>
    - reconfigure<br/>
    - Maj-Release"""
        else:
            self.status = status.OK()
            self.message = "Version de samba Valide"
        return  [{'status': self.status, 'msg': self.message}]


    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value


    def check_status(self):
        return self.status
