# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2014
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent Dansguardian
"""

from zephir.monitor.agentmanager.agent import RRDAgent
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.config import MAXCHILDREN1, MAXCHILDREN2, ADRESSE_IP_SERVICE_PROXY, DANSGUARDIAN_ETH
from pyeole.process import system_out


def test_instance_dansguardian(ip, max_instance):
    prct_instance = None
    if ip is not None:
        cmd = ['lsof', '-tnPi', '@{0}:3128'.format(ip)]
        stat, instance, err = system_out(cmd, container='proxy')
        if stat == 0:
            prct_name = 'e2guardian'
            prct_instance = min(len(instance.split()) * 100 / max_instance, 100)
    return prct_instance


class Dansguardian(RRDAgent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        RRDAgent.__init__(self, name, **params)
        self.instance_1_activate = None
        self.instance_2_activate = None
        for idx, dansguardian_eth in enumerate(DANSGUARDIAN_ETH):
            if dansguardian_eth == '1':
                self.instance_1_activate = ADRESSE_IP_SERVICE_PROXY[idx]
            if dansguardian_eth == '2':
                self.instance_2_activate = ADRESSE_IP_SERVICE_PROXY[idx]


    def measure(self):
        resultat = {"1": 0, "2": 0}
        ret = test_instance_dansguardian(self.instance_1_activate, MAXCHILDREN1)
        stat = status.Unknown()
        if ret is not None:
            resultat['1'] = ret
            if stat == status.Unknown():
                stat = status.OK()
            if ret == 100:
                stat = status.Error()
            elif ret > 90:
                stat = status.Warn()
        ret = test_instance_dansguardian(self.instance_2_activate, MAXCHILDREN2)
        if ret is not None:
            if stat == status.Unknown():
                stat = status.OK()
            resultat['2'] = ret
            if ret > 90:
                stat = status.Error()
        self.status = stat
        return resultat

    def check_status(self):
        try:
            return self.status
        except:
            return status.Unknown()
