# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour la surveillance ds démons bareos via check_bareos
"""

from twisted.internet.utils import getProcessOutput
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager.util import status_to_img, boolean_to_onoff, log

class BareosService(Agent):

    def __init__(self, name, password, machine, **params):
        Agent.__init__(self, name, **params)
        self.name = name
        self.short_name = self.name.split('-')[1]
        self.password = password
        self.machine = machine
        self.table = TableData([
            ('status', "Etat", {'align':'center'}, status_to_img),
            ('description', "Description", {'align':'left'}, None),
            ('host', "Hôte", {'align':'left'}, None),
            ('port', "Port", {'align':'left'}, None) ])
        self.data = [self.table]

    def measure(self):
        CHECK_BAREOS = '/usr/share/eole/bareos/test_director'
        result = getProcessOutput(CHECK_BAREOS,
                                  args=('bareos-{0}-mon'.format(self.machine), self.password),
                                  env={'LC_ALL': 'C'})
        result.addCallbacks(self.measure_activity, self.measure_error)
        return result

    def measure_activity(self, data):
        status = boolean_to_onoff(1)
        mesures = [{'description': self.name,
                    'host': 'localhost',
                    'port': '',
                    'status': status }]
        return {'services': mesures}

    def measure_error(self, failure):
        log.msg(u'Erreur remontée par /usr/share/eole/bareos/test_director :')
        log.msg(failure.getErrorMessage())

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['services']

    def check_status(self):
        """remonte une erreur si un des services est tombé"""
        if self.last_measure is not None and self.last_measure.value is not None:
            for service in self.last_measure.value['services']:
                if service['status'] != 'On':
                    return status.Error()
        else:
            # pas de mesure connue
            return status.Unknown()
        return status.OK()
