# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent Samba 3
"""

from zephir.monitor.agentmanager.agent import RRDAgent
from zephir.monitor.agentmanager.data import TableData, HTMLData
from twisted.internet.utils import getProcessOutput
from zephir.monitor.agentmanager import status


class SmbUsers(RRDAgent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        RRDAgent.__init__(self, name, **params)
        self.status = 1
        self.table = TableData([
            ('connected', 'Connectés', {'align':'center'}, None) ])

    def init_data(self, archive_dir):
        title1 = HTMLData("<h3>Nombre de connectés actuels<h3>")
        title2 = HTMLData("<h3>Graphes des connexions<h3>")
        self.data.extend([title1, self.table, title2])
        RRDAgent.init_data(self, archive_dir)

    def measure(self):
        res = getProcessOutput("/usr/share/eole/sbin/connexions.sh",
                               env = {'LC_ALL': 'C'})
        res.addCallback(self.measure_process)
        return res

    def measure_process(self, result):
        result = result.decode()
        try:
            self.measure_data['connected'] = int(result)
            return {'connected' : int(result),
                    't_con' : [{'connected':int(result)}]
                   }
        except:
            # Erreur
            self.status = 0
            return {'connected' : 0,
                    't_con' : [{'connected': 0}]
                   }

    def write_data(self):
        RRDAgent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['t_con']

    def check_status(self):
        if self.status == 1 :
            return status.OK()
        return status.Error()

