#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# init_ldap.py
#
# script d'insertion des données par défaut dans la base LDAP
#
###########################################################################

# insertion des types d'établissement
import getpass, os, sys
from zephir.utils.ldap_user import add_user
from creole.client import CreoleClient
from pyeole.ansiprint import print_orange
try:
    from conf_ldap import pass_ldap
except:
    pass_ldap=""

# récupération du login admin
dictionnaire = CreoleClient()
admin_zephir = dictionnaire.get_creole('admin_zephir')

# création d'utilisateurs LDAP
print "Initialisation de la base d'authentification locale ..."
# on crée un utilisateur admin_zephir par défaut
try:
    passwd = sys.argv[1]
except:
    print "Création de l'administrateur zephir par défaut (%s)" % admin_zephir
    pass_ok = 0
    while pass_ok != 1:
        passwd = getpass.getpass("Donnez un mot de passe à attribuer à %s : " % admin_zephir)
        passwd2 = getpass.getpass("Saisissez à nouveau le mot de passe : ")
        if passwd==passwd2 and passwd != "":
            pass_ok = 1
        else:
            print ("\n Les mots de passe ne correspondent pas, recommencez\n")

try:
    add_user(admin_zephir, passwd)
except:
    print_orange("Erreur de création de l'utilisateur (déjà existant ou problème LDAP)")

new_login = "toto"
print "## Création des utilisateurs dans l'annuaire ##"
print "\nVous pouvez maintenant créer des utilisateurs si vous le souhaitez"
print "Attribuez leur des droits sur l'application via l'interface web"
while new_login != "":
    new_login = raw_input("\nnom d'utilisateur a créer (rien pour terminer) : ")
    if new_login != "":
        pass_ok = 0
        while pass_ok != 1:
            passwd = getpass.getpass("Mot de passe du nouvel utilisateur  : ")
            passwd2 = getpass.getpass("Saisissez à nouveau le mot de passe : ")
            if passwd==passwd2 and passwd != "":
                pass_ok = 1
            else:
                print ("\n Les mots de passe ne correspondent pas, recommencez\n")
        try:
            add_user(new_login,passwd)
        except:
            print_orange("Erreur de création de l'utilisateur (déjà existant ou problème LDAP)")

print """\n** Base d'authentification LDAP initialisée **\n"""
