#!/usr/bin/python
# -*- coding: UTF-8 -*-

"""
update_dics_rc.py

script de mise à jour des dictionnaires zephir en version proposed

- faire un clone de https://dev-eole.ac-dijon.fr/zephir-parc/
- modifier le chemin ZEPHIR_DIR pour pointer sur le répertoire du projet
- lancer le script pour récupérer les dictionnaires
- vérifier et commiter les modifications dans data/dictionnaires du projet zephir-parc

- recompiler le paquet zephir-parc

"""

import os, sys, shutil
from glob import glob
from subprocess import Popen, PIPE
from eolepack.eolerc import list_packages

distribs = {'2.2':'2.2', '2.3':'dist/ubuntu/lucid/master'}
distribs = {'2.3':'dist/ubuntu/lucid/master'}

# A CONFIGURER SI BESOIN : CHEMIN VERS LE REPERTOIRE DES DICTIONNAIRES
# par défaut: script lancé depuis 'outils' dans un checkout de zephir-parc
ZEPHIR_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__name__)))

dico_paqs = []

for EOLE_VERS, BRANCHE_DIST in distribs.items():
    SERVEUR_GIT = 'http://dev-eole.ac-dijon.fr'
    DEST_DIR = os.path.abspath('/tmp/dicos_git')
    if os.path.isdir(DEST_DIR):
        sys.exit("!!! répertoire temporaire non supprimé (%s) !!!" % DEST_DIR)
    # ditribution actuelle : master par défaut
    REPOS_DIST = '%s/git' % (SERVEUR_GIT)
    # REPOS_OUTILS = '%s/Outils' % (SERVEUR_GIT) -> arbo git à plat
    ZEPHIR_DICT_DIR = os.path.join(ZEPHIR_DIR, 'data', 'dictionnaires')
    # liste des modules connus
    ALL_MODS = ['amon', 'amonecole', 'eclair', 'eolebase', 'horus', 'preludemanager', 'scribe', 'sentinelle', 'seshat', 'sphynx', 'zephir', 'zephirlogs']

    if EOLE_VERS == "2.3":
        TYPE_PAQ = 'updates'
        ALL_MODS.remove('zephirlogs')
        ALL_MODS.append('zephirlog')
        ALL_MODS.insert(2, 'amonhorus')
        ALL_MODS.insert(4, 'amonecole+')
    else:
        TYPE_PAQ = 'security'

    if '-p' in sys.argv:
        print "\nRécupération des dictionnaires dans les derniers paquets proposed (%s)" % EOLE_VERS
        TYPE_PAQ = 'proposed'
    else:
        print "\nRécupération des dictionnaires dans les derniers paquets stables (%s)" % EOLE_VERS

    def run_cmd(args, show_output = False):
        running_cmd = Popen(args, stdout=PIPE, stderr=PIPE)
        if running_cmd.wait() != 0:
            data = running_cmd.communicate()
            print data[0]
            print u"! Erreur lors de l'exécution de la commande suivante: %s\n" % " ".join(args)
            print data[1]
            sys.exit(1)
        if show_output:
            print running_cmd.communicate()[0]

    # dictionnaire 'nom de paquet' : (, chemin svn, {destination de copie:[fichiers_xml]}, nom_projet_git)
    CONF_PACKS = {'conf-amon':['', {}, ''],
                  'conf-amonecole':['', {}, ''],
                  'conf-eclair':['', {}, ''],
                  'conf-eolebase':['', {}, ''],
                  'conf-eolevz':['eole/dicos', {'amonecole-%s' % EOLE_VERS: []}, ''],
                  'conf-horus':['', {}, ''],
                  'conf-preludemanager':['', {}, ''],
                  'conf-scribe':['', {}, ''],
                  'conf-sentinelle':['', {}, ''],
                  'conf-seshat':['', {}, ''],
                  'conf-sphynx':['', {}, ''],
                  'conf-zephir':['', {}, ''],
                  'conf-zephirlogs':['', {}, 'conf-zephirlog'],
                  'eole-bacula':['', {'scribe-%s' % EOLE_VERS: [],
                                      'horus-%s' % EOLE_VERS: [],
                                      'eclair-%s' % EOLE_VERS: []}, ''],
                  'eole-mysql':['', {'scribe-%s' % EOLE_VERS: ['scribe_mysql.xml'],
                                     'horus-%s' % EOLE_VERS: ['2_mysql.xml']}, ''],
                  'client-common':['', {'eclair-%s' % EOLE_VERS: []}, ''],
                  'eole-posh':['eole/dicos', {'scribe-%s' % EOLE_VERS: []}, ''],
                  'eole-jappix':['', {'scribe-%s' % EOLE_VERS: []}, ''],
                  'ajax-portail':['eole', {'scribe-%s' % EOLE_VERS: []}, ''],
                  'envole-cdt':['', {'scribe-%s' % EOLE_VERS: []}, 'cdt'],
                  'envole-grr':['', {'scribe-%s' % EOLE_VERS: []}, 'grr'],
                  'envole-calendar':['', {'scribe-%s' % EOLE_VERS: []}, 'webcalendar'],
                  'envole-wordpress':['eole/dicos', {'scribe-%s' % EOLE_VERS: []}, 'wordpress'],
                  'eole-taskfreak':['eole/dicos', {'scribe-%s' % EOLE_VERS: []}, 'taskfreak'],
                  'eole-sso':['', {}, ''],
                  'eole-common':['', {}, ''],
                 }

    # récupération de la liste des paquets RC
    print u"\nMise à jour de la liste des paquets ..."
    paq_search_path = "http://test-eoleng.ac-dijon.fr/eoleng/eole-%s-%s/source/" % (EOLE_VERS, TYPE_PAQ)

    liste_paqs = []
    if EOLE_VERS == "2.3":
        # FIXME : HACK pour gérer les différences 2.2 / 2.3 sur eole-posh
        CONF_PACKS['eole-ead-common'] = ['', {'ALL': []}, 'ead']
        CONF_PACKS['eole-common'] = ['', {'ALL': []}, '']
        CONF_PACKS['eole-vpn'] = ['', {'amon-%s' % EOLE_VERS: [], 'sphynx-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-dns'] = ['', {'amon-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-cntlm'] = ['', {'amon-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-dhcrelay'] = ['dhcrelay/dicos', {'amon-%s' % EOLE_VERS: []}, 'conf-amon']
        CONF_PACKS['eole-proxy'] = ['', {'amon-%s' % EOLE_VERS: []}, '']
        # CONF_PACKS['eole-nuauth'] = ['', {'amon-%s' % EOLE_VERS: []}, 'eole-nuauth']
        CONF_PACKS['eole-reverseproxy'] = ['', {'amon-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-pacemaker'] = ['', {'sphynx-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-radius'] = ['', {'amon-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-ltsp-fichier'] = ['', {'eclair-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-ltsp-lb'] = ['', {'eclair-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-ltsp-server'] = ['', {'eclair-%s' % EOLE_VERS: []}, '']
        # dictionnaires 50_amonecole.xml / 50_amonecole+.xml dans les modules respecifs
        CONF_PACKS['conf-amonecole+'] = ['', {'amonecole+-%s' % EOLE_VERS: ['50_amonecole+.xml']}, 'conf-amonecole']
        CONF_PACKS['conf-amonecole'] = ['', {'amonecole-%s' % EOLE_VERS: ['50_amonecole.xml']}, '']
        CONF_PACKS['eole-client-annuaire'] = ['client-annuaire/dicos', {'horus-%s' % EOLE_VERS: [],
                                                                        'scribe-%s' % EOLE_VERS: [],
                                                                        'seshat-%s' % EOLE_VERS: [],
                                                                        'zephir-%s' % EOLE_VERS: [],
                                                                        'eclair-%s' % EOLE_VERS: [],
                                                                        }, 'conf-scribe']
        CONF_PACKS['eole-interbase'] = ['interbase/dicos', {'horus-%s' % EOLE_VERS: []}, 'conf-horus']
        CONF_PACKS['eole-annuaire'] = ['annuaire/dicos', {'scribe-%s' % EOLE_VERS: [],
                                                          'horus-%s' % EOLE_VERS: [],
                                                          'seshat-%s' % EOLE_VERS: [],
                                                          'zephir-%s' % EOLE_VERS: []}, 'conf-scribe']
        CONF_PACKS['eole-antivirus'] = ['antivirus/dicos', {'amon-%s' % EOLE_VERS: [],
                                                            'scribe-%s' % EOLE_VERS: [],
                                                            'horus-%s' % EOLE_VERS: []}, 'conf-scribe']
        CONF_PACKS['eole-dhcp'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                        'horus-%s' % EOLE_VERS: [],
                                        'eclair-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-fichier'] = ['fichier/common/dicos', {'scribe-%s' % EOLE_VERS: [],
                                                               'horus-%s' % EOLE_VERS: []}, 'conf-scribe']
        CONF_PACKS['eole-fichier-primaire'] = ['fichier/fichier-primaire/dicos', {'scribe-%s' % EOLE_VERS: [],
                                                        'horus-%s' % EOLE_VERS: []}, 'conf-scribe']
        CONF_PACKS['eole-exim'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                        'seshat-%s' % EOLE_VERS: [],}, '']
        CONF_PACKS['eole-web'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                       'horus-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-webmail'] = ['webmail/dicos', {'scribe-%s' % EOLE_VERS: []}, 'conf-scribe']
        CONF_PACKS['eole-sympa'] = ['', {'scribe-%s' % EOLE_VERS: []}, '']
        #CONF_PACKS['eole-envole'] = ['envole/dicos', {'scribe-%s' % EOLE_VERS: []}, 'conf-scribe'
        CONF_PACKS['eole-ssmtp'] = ['ssmtp/dicos', {'horus-%s' % EOLE_VERS: [],
                                                    'zephir-%s' % EOLE_VERS: [],
                                                    'sphynx-%s' % EOLE_VERS: [],
                                                    'amon-%s' % EOLE_VERS: [],
                                                    'eclair-%s' % EOLE_VERS: [],
                                                    'eolebase-%s' % EOLE_VERS: [],
                                                    'preludemanager-%s' % EOLE_VERS: [],
                                                    'zephirlog-%s' % EOLE_VERS: [],
                                                    'sentinelle-%s' % EOLE_VERS: []}, 'eole-common']
        CONF_PACKS['eole-courier'] = ['', {'scribe-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-spamassassin'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                                'seshat-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-bacula'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                          'horus-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-esu-rules'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                       'horus-%s' % EOLE_VERS: []}, 'eole-esu']
        CONF_PACKS['eole-mysql'] = ['', {'scribe-%s' % EOLE_VERS: [],
                                         'horus-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-sso-client'] = ['client/dicos', {'amon-%s' % EOLE_VERS: [],
                                                          'horus-%s' % EOLE_VERS: [],
                                                          'scribe-%s' % EOLE_VERS: [],
                                                          'eclair-%s' % EOLE_VERS: [],
                                                          'sentinelle-%s' % EOLE_VERS: [],
                                                          'seshat-%s' % EOLE_VERS: [],
                                                          'sphynx-%s' % EOLE_VERS: [],
                                                          'zephir-%s' % EOLE_VERS: [],
                                                          'zephirlog-%s' % EOLE_VERS: []}, 'eole-sso']
        CONF_PACKS['eole-controle-vnc'] = ['', {'scribe-%s' % EOLE_VERS: []}, 'controle-vnc']
        CONF_PACKS['eole-userpassword'] = ['password/dicos', {'horus-%s' % EOLE_VERS: [],
                                                            'scribe-%s' % EOLE_VERS: []}, 'conf-scribe']
        # paquets envole eole 2.3
        CONF_PACKS['eole-envole-infos'] = ['eole/dicos', {'scribe-%s' % EOLE_VERS: []}, 'envole-infos']
        CONF_PACKS['eole-ajaxplorer'] = ['dicos', {'scribe-%s' % EOLE_VERS: []}, 'ajaxplorer']
        CONF_PACKS['eole-piwik'] = ['', {'scribe-%s' % EOLE_VERS: []}, 'piwik2']
        CONF_PACKS['eole-xdesktop'] = ['', {'scribe-%s' % EOLE_VERS: []}, 'xDesktop']
        CONF_PACKS['envole-mobile'] = ['', {'scribe-%s' % EOLE_VERS: []}, 'envole-mobile']
        CONF_PACKS['eole-posh'] = ['', {'scribe-%s' % EOLE_VERS: []}, '']
        CONF_PACKS['eole-posh-profile'] = ['', {'scribe-%s' % EOLE_VERS: []}, 'posh-profil']
        CONF_PACKS['eole-sap'] = ['', {'scribe-%s' % EOLE_VERS: []}, 'sap']
        CONF_PACKS['eole-gaspacho'] = ['', {'amonecole+-%s' % EOLE_VERS: []}, 'gaspacho']
        CONF_PACKS['eole-gaspacho-agent'] = ['', {'eclair-%s' % EOLE_VERS: []}, 'gaspacho-agent']
        CONF_PACKS['conf-zephirlog'] = ['', {}, '']

        # paquets obsolètes
        del(CONF_PACKS['ajax-portail'])
        del(CONF_PACKS['conf-eolebase'])
        del(CONF_PACKS['conf-eolevz'])
        del(CONF_PACKS['conf-preludemanager'])
        del(CONF_PACKS['eole-taskfreak'])
        del(CONF_PACKS['eole-jappix'])
        del(CONF_PACKS['envole-cdt'])
        del(CONF_PACKS['envole-grr'])
        del(CONF_PACKS['envole-calendar'])
        del(CONF_PACKS['client-common'])
        del(CONF_PACKS['envole-wordpress'])
        del(CONF_PACKS['conf-zephirlogs'])

    if EOLE_VERS == "2.3":
        # HACK !!!! pour l'instant on prend tous les paquets
        liste_paqs = [ [paq, 'X-X'] for paq in CONF_PACKS.keys()]
    else:
        for pack in list_packages(paq_search_path):
            if pack[0] in CONF_PACKS:
                liste_paqs.append(pack)

    print u"Export des dictionnaires ...\n"

    if os.path.isdir(DEST_DIR):
        shutil.rmtree(DEST_DIR)
    os.makedirs(os.path.join(DEST_DIR, 'git'))
    for name, tag in liste_paqs:
        tag = tag.rsplit("-")[1]
        print u" - %s (tag %s)" % (name, tag)
        if CONF_PACKS[name][0] == '':
            path_dicos = 'dicos'
        else:
            path_dicos = CONF_PACKS[name][0]
        #    # chemin par défaut (conf module)
        #    svn_path = "/".join([REPOS_DIST, name.lstrip('conf-'), name, 'tags', tag, 'dicos'])
        #else:
        if CONF_PACKS[name][2] == '':
            git_path = "/".join([REPOS_DIST, name])
        else:
            # nom de projet git != nom de paquet
            git_path = "/".join([REPOS_DIST, CONF_PACKS[name][2]])

        # lancement du clone GIT sur la branche de la distribution
        dest_path = os.path.join(DEST_DIR, name)
        export_path = os.path.join(DEST_DIR, 'git', name)
        if not os.path.exists(export_path):
            # si projet avec plusieurs paquets contenant des dicos, on ne réexporte pas
            run_cmd(['/usr/bin/git', 'clone', '-b', BRANCHE_DIST, git_path, export_path])
        # conservation seulement du répertoire des dictionnaires
        if not os.path.isdir('%s/%s' % (export_path, path_dicos)):
            print "** %s : erreur, le répertoire de dictionnaires %s n'a pas été trouvé" % (str(name), str(path_dicos))
        else:
            run_cmd(['/bin/mv', '%s/%s' % (export_path, path_dicos), dest_path])

    shutil.rmtree(os.path.join(DEST_DIR, 'git'))
    # test xmllint de tous les fichiers xml
    print u"\nVérification de la syntaxe (xmllint) ...\n"
    for fic_xml in glob("%s/*/*.xml" % DEST_DIR):
        run_cmd(['/usr/bin/xmllint', '-noout', fic_xml])

    print u"\nMise à jour des dictionnaire Zephir ...\n"
    # définition des copies à effectuer

    copies = []
    for paq in liste_paqs:
        name = paq[0]
        # copies automatiques pour les paquets conf-<module>
        if name.startswith('conf-'):
            mod_name = name.lstrip('conf-')
            dest = os.path.join(ZEPHIR_DICT_DIR, "%s-%s/" % (mod_name, EOLE_VERS))
            if os.path.isdir(dest):
                if CONF_PACKS[name][1] != {}:
                    # modules et/ou dictionnaires spécifiés
                    for mod_dest in CONF_PACKS[name][1].keys():
                        if CONF_PACKS[name][1][mod_dest] != []:
                            dict_list = CONF_PACKS[name][1][mod_dest]
                            for dict_name in dict_list:
                                fic_xml = os.path.join(DEST_DIR, name, dict_name)
                                copies.append((fic_xml, dest))
                                if fic_xml not in dico_paqs:
                                    dico_paqs.append(fic_xml)
                        else:
                            # tous les dictionnaires présents
                            for fic_xml in glob(os.path.join(DEST_DIR, name, '*.xml')):
                                copies.append((fic_xml, dest))
                                if fic_xml not in dico_paqs:
                                    dico_paqs.append(fic_xml)
                else:
                    for fic_xml in glob(os.path.join(DEST_DIR, name,'*.xml')):
                        copies.append((fic_xml, dest))
                        if fic_xml not in dico_paqs:
                            dico_paqs.append(fic_xml)
            else:
                print  u"** %s : Fichiers non copiés (module non géré dans zephir)**" % name
        if CONF_PACKS[name][1] != {}:
            if CONF_PACKS[name][1].keys() == ['ALL']:
                # à envoyer sur tous les modules
                dict_list = CONF_PACKS[name][1]['ALL']
                mod_dests = {}
                for dest in ALL_MODS:
                    mod_dests['%s-%s' % (dest, EOLE_VERS)] = dict_list
                CONF_PACKS[name] = [CONF_PACKS[name][0], mod_dests, CONF_PACKS[name][2]]
            # copies spécifiques
            dests = CONF_PACKS[name][1].keys()
            for mod_dest in dests:
                dest = os.path.join(ZEPHIR_DICT_DIR, mod_dest)
                if os.path.isdir(dest):
                    if CONF_PACKS[name][1][mod_dest] != []:
                        # dictionnaires spécifiés
                        dict_list = CONF_PACKS[name][1][mod_dest]
                        for dict_name in dict_list:
                            fic_xml = os.path.join(DEST_DIR, name, dict_name)
                            copies.append((fic_xml, dest))
                        if fic_xml not in dico_paqs:
                            dico_paqs.append(fic_xml)
                    else:
                        # tous les dictionnaires présents
                        for fic_xml in glob(os.path.join(DEST_DIR, name, '*.xml')):
                            copies.append((fic_xml, dest))
                        if fic_xml not in dico_paqs:
                            dico_paqs.append(fic_xml)
                else:
                    print u"** %s : destination inexistante (%s)**" % (name, dest)

    # dictionnaires communs
    for pack_name in CONF_PACKS:
        if pack_name.startswith('conf-'):
            mod_name = pack_name.lstrip('conf-')
            dest = os.path.join(ZEPHIR_DICT_DIR, "%s-%s/" % (mod_name, EOLE_VERS))
            if os.path.isdir(dest):
                # ajout automatique des dictionnaires de eole-common
                if os.path.isdir(os.path.join(DEST_DIR, 'eole-common')):
                    for fic_xml in glob(os.path.join(DEST_DIR, 'eole-common', '*.xml')):
                        if (os.path.basename(fic_xml) != '2_logs_amon.xml') or (mod_name in ('amon', 'amonecole', 'amonhorus', 'amonecole+')):
                            copies.append((fic_xml, dest))
                            if fic_xml not in dico_paqs:
                                dico_paqs.append(fic_xml)
                # ajout des dictionnaires eole-sso
                if mod_name not in ('eolevz', 'eolebase', 'preludemanager', 'zephirlogs'):
                    if os.path.isdir(os.path.join(DEST_DIR, 'eole-sso')):
                        for fic_xml in glob(os.path.join(DEST_DIR, 'eole-sso', '*.xml')):
                            copies.append((fic_xml, dest))
                            if fic_xml not in dico_paqs:
                                dico_paqs.append(fic_xml)


    # pour tous les modules >= 2.3 : copie du dictionnaire 29_zephir_conteneur.xml
    # active des options de saisie supplémentaires lorsqu'on est dans le formulaire
    # de l'application web (ex : activation du mode conteneur)
    if float(EOLE_VERS) > 2.2:
        mod_dirs = glob(os.path.join(ZEPHIR_DICT_DIR, "*-%s/" % EOLE_VERS))
        for mod_dir in mod_dirs:
            if not (mod_dir.endswith("amonecole-%s/" % EOLE_VERS) or \
                    mod_dir.endswith("amonhorus-%s/" % EOLE_VERS) or \
                    mod_dir.endswith("amonecole+-%s/" % EOLE_VERS)):
                copies.append((os.path.join(ZEPHIR_DICT_DIR, '29_zephir_redefine.xml'), mod_dir))

    # lancement des copies
    print u"\nCopie des dictionnaires dans le dépot local de zephir-parc ..."
    for src, dst in copies:
        # print u" %s --> %s" % (src, dst)
        run_cmd(["/bin/cp", "-f", src, dst])

    # GESTION DES MODULES 'COMPOSES'
    copies = []
    # cas d'amonecole : recopie des dictionnaires amon et scribe
    src_dirs = [os.path.join(ZEPHIR_DICT_DIR, 'amon-%s' % EOLE_VERS)]
    if EOLE_VERS == "2.3":
        src_dirs.append(os.path.join(ZEPHIR_DICT_DIR, 'scribe-%s' % EOLE_VERS))
    for src_dir in src_dirs:
        if os.path.isdir(src_dir):
            dest = os.path.join(ZEPHIR_DICT_DIR, "amonecole-%s" % EOLE_VERS)
            for fic_xml in glob(os.path.join(src_dir, '*.xml')):
                if os.path.basename(fic_xml) not in ('99_module.xml', '29_zephir_redefine.xml', '20_ssmtp.xml'):
                    copies.append((fic_xml, dest))
    if EOLE_VERS == "2.3":
        # cas d'amonecole+ :  amonecole + eclair
        src_dirs.append(os.path.join(ZEPHIR_DICT_DIR, 'eclair-%s' % EOLE_VERS))
        dest = os.path.join(ZEPHIR_DICT_DIR, "amonecole+-%s" % EOLE_VERS)
        for src_dir in src_dirs:
            if os.path.isdir(src_dir):
                for fic_xml in glob(os.path.join(src_dir, '*.xml')):
                    if os.path.basename(fic_xml) not in ('99_module.xml', '29_zephir_redefine.xml', '20_ssmtp.xml', '50_amonecole.xml', '50_amonecole+.xml'):
                        copies.append((fic_xml, dest))
        # cas d'amonhorus : recopie des dictionnaires amon et horus + reprise du dictionnaire amonecole ...
        src_dirs = [os.path.join(ZEPHIR_DICT_DIR, 'amon-%s' % EOLE_VERS)]
        src_dirs.append(os.path.join(ZEPHIR_DICT_DIR, 'horus-%s' % EOLE_VERS))
        for src_dir in src_dirs:
            if os.path.isdir(src_dir):
                dest = os.path.join(ZEPHIR_DICT_DIR, "amonhorus-%s" % EOLE_VERS)
                for fic_xml in glob(os.path.join(src_dir, '*.xml')):
                    if os.path.basename(fic_xml) not in ('99_module.xml', '29_zephir_redefine.xml'):
                        copies.append((fic_xml, dest))
        copies.append((os.path.join(ZEPHIR_DICT_DIR, "amonecole-%s" % EOLE_VERS, '50_amonecole.xml'),
                      os.path.join(ZEPHIR_DICT_DIR, "amonhorus-%s" % EOLE_VERS, '50_amonhorus.xml')))
        # cas d'amonhorus 2.3 remplacement de "amonecole" par "amonhorus" dans dictionnaire !!
        fic_horus = os.path.join(ZEPHIR_DICT_DIR, "amonhorus-%s" % EOLE_VERS, '50_amonhorus.xml')
        try:
            content = open(fic_horus).read()
            f_horus = open(fic_horus, 'w')
            f_horus.write(content.replace('<value>amonecole<', '<value>amonhorus<'))
            f_horus.close()
        except:
            print u"\n\n !! Erreur lors du remplacement des valeurs par défaut dans 50_amonhorus.xml !!\n\n"

    # lancement des copies
    # création / maj de l'arborescence des dictionnaires par paquet
    for dict in dico_paqs:
        nom_dico = os.path.basename(dict)
        # on récupère le nom du projet
        dest = os.path.join(ZEPHIR_DICT_DIR, EOLE_VERS, dict.split(os.sep)[-2])
        if not os.path.isdir(dest):
            os.makedirs(dest)
        print u"%s --> %s" % (dict, dest)
        run_cmd(["/bin/cp", "-f", dict, dest])

    # copie en mode classique (copie des dictionnaires dans chaque module)
    for src, dst in copies:
        # print u"%s --> %s" % (src, dst)
        run_cmd(["/bin/cp", "-f", src, dst])

    # copie des répertoires par paquet dans le pool de dictionnaires de la distribution
    for paq_name in os.listdir(DEST_DIR):
        paq_dir = os.path.join(DEST_DIR, paq_name)
        if os.path.isdir(paq_dir):
            paq_pooldir = os.path.join(ZEPHIR_DICT_DIR, EOLE_VERS, 'eole', paq_name)
            if os.path.isdir(paq_pooldir):
                shutil.rmtree(paq_pooldir)
            shutil.move(paq_dir, paq_pooldir)
    # Truande pour amonhorus !
    amonhorus_dir = os.path.join(ZEPHIR_DICT_DIR, EOLE_VERS, 'eole', 'conf-amonhorus')
    if not os.path.isdir(amonhorus_dir):
        os.makedir(amonhorus_dir)
    shutil.copy(fic_horus, os.path.join(ZEPHIR_DICT_DIR, EOLE_VERS, 'eole', 'conf-amonhorus', '50_amonhorus.xml'))
    # nettoyage du répertoire temporaire
    shutil.rmtree(DEST_DIR)


print "\nVérification de l'état des fichiers (svn st) :\n"
os.chdir(ZEPHIR_DICT_DIR)
print "***", os.getcwd()
run_cmd(["/usr/bin/git", "status"], True)
