#!/usr/bin/env python
#-*- coding:utf-8 -*-

###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# client.py
# client XMLRPC pour accès aux données de configuration CREOLE
#
###########################################################################

from creole2 import config
import xmlrpclib, json
from creole2.eosfunc import load_container_var

# modification du décodeur par défaut pour empêcher le passage en unicode des chaînes
#
# basé sur une solution trouvée ici :
#
# http://stackoverflow.com/questions/4723535/how-to-decode-json-to-str-and-not-unicode-in-python-2-6

from json import decoder, scanner
from pyeole2.process import tcpcheck

try:
    from _json import scanstring as c_scanstring
except ImportError:
    c_scanstring = decoder.py_scanstring

_CONSTANTS = json.decoder._CONSTANTS

# Convert from unicode to str
def str_scanstring(*args, **kwargs):
    result = c_scanstring(*args, **kwargs)
    return result[0].encode(decoder.DEFAULT_ENCODING), result[1]

# Little dirty trick here
json.decoder.scanstring = str_scanstring

class StrJSONDecoder(decoder.JSONDecoder):
    def __init__(self, encoding=None, object_hook=None, parse_float=None,
            parse_int=None, parse_constant=None, strict=True,
            object_pairs_hook=None):
        self.encoding = encoding
        self.object_hook = object_hook
        self.object_pairs_hook = object_pairs_hook
        self.parse_float = parse_float or float
        self.parse_int = parse_int or int
        self.parse_constant = parse_constant or _CONSTANTS.__getitem__
        self.strict = strict
        self.parse_object = decoder.JSONObject
        self.parse_array = decoder.JSONArray
        self.parse_string = str_scanstring

# And another little dirty trick there
_default_decoder = StrJSONDecoder(encoding=None, object_hook=None,
                               object_pairs_hook=None)

json._default_decoder = _default_decoder

class CreoleClient(xmlrpclib.ServerProxy):

    def __init__(self):
        self.dico = None
        conf_containers = load_container_var()
        addr_serveur = 'http://%s:%s/xmlrpc' % (conf_containers['adresse_ip_br0'], config.port_rpc)
        xmlrpclib.ServerProxy.__init__(self, addr_serveur)

    def __request_json(self, methodname, params):
        return json.loads(self._ServerProxy__request(methodname, params))

    def __getattr__(self, name):
        return xmlrpclib._Method(self.__request_json, name)

