# -*- coding: UTF-8 -*-
"""
Parseur DOM des fichiers XML de collecte des variables eoles
"""

import xml.dom.minidom
from pyeole2.deprecation import deprecated
from creole2.error import *
from creole2.utils import string_to_bool, get_text_node
from creole2.config import VIRTMASTER

service_level = 0
file_level = 0

@deprecated
def parse_xml_file(filename):
    """
    @param filename: nom du fichier xml source
    @return: structure de données permettant de créer les objets Eole
    """
    try:
        document = xml.dom.minidom.parse(filename)
        return _parse_root_node(document)
    except Exception, err:
        # FIXME
        import traceback
        traceback.print_exc()
        raise ConfigError, "Erreur lors du parsing du fichier %s : %s" % (filename, str(err))

@deprecated
def parse_string(string):
    try:
        document = xml.dom.minidom.parseString(string)
        return _parse_root_node(document)
    except Exception, err:
        raise ConfigError, "Erreur lors du parsing : %s" % str(err)


def _parse_root_node(document):
    """
    @param document: le document DOM contenant l'arborescence xml
    """
    root_node = document.documentElement


    variables = parse_variables(root_node.getElementsByTagName('variables')[0])
    families, order = parse_families(root_node.getElementsByTagName('variables')[0])
    file_node = root_node.getElementsByTagName('files')
    softwares = {}
    if file_node != []:
        if len(file_node) != 1:
            raise Exception("Erreur plusieurs balises <files> par dictionnaire")
        file_root_node = file_node[0]
        files = parse_files(file_root_node)
        file_packages = parse_packages(file_root_node)
        file_services = parse_services(file_root_node)
        softwares[VIRTMASTER] = [files, file_packages, file_services, {}, '1', '', '']

    containers_node = root_node.getElementsByTagName('containers')
    if containers_node != []:
        for container in containers_node:
            softwares.update(parse_containers(container))

    constraint_node = root_node.getElementsByTagName('constraints')
    if constraint_node != []:
        constraints = parse_constraints(constraint_node[0])
    else:
        constraints = {'checks' : {},
                       'fills' : {},
                       'conditions' : {},
                       'auto' : {}
                      }
    group_node = root_node.getElementsByTagName('constraints')
    if group_node != []:
        groups = parse_groups(group_node[0])
    else:
        groups = {}
    help_node = root_node.getElementsByTagName('help')
    if help_node != []:
        helps = parse_help(help_node[0])
    else:
        helps = {'variables':{},
                 'families':{}
                }
    sep_node = root_node.getElementsByTagName('separators')
    if sep_node != []:
        separators = parse_separators(sep_node[0])
    else:
        separators = {}
    return softwares, variables, families, order, constraints, groups, helps, separators


def _get_boolean_attr(fic, attr_name):
    """
    Gestion spécifique pour les attributs booléens
    Ils sont à False par défaut
    """
    val = fic.getAttribute(attr_name)
    if val.lower() == 'true':
        return True
    else:
        return False

def parse_files(file_node):
    """
    Parsing des balises <file>
    @file_node : noeud xml
    """
    global file_level
    result = {}
    for fic in file_node.getElementsByTagName('file'):
        file_level += 1

        result[fic.getAttribute('name')] = {'hidden':False,
                                             'source':fic.getAttribute('source'),
                                             'mode':fic.getAttribute('mode'),
                                             'owner':fic.getAttribute('owner'),
                                             'group':fic.getAttribute('group'),
                                             'mkdir':_get_boolean_attr(fic, 'mkdir'),
                                             'filelist':fic.getAttribute('filelist'),
                                             'rm':_get_boolean_attr(fic, 'rm'),
                                             'del_comment':fic.getAttribute('del_comment'),
                                             'container_only':_get_boolean_attr(fic, 'container_only'),
                                             'level': file_level
                                            }
    return result

def parse_packages(package_node):
    return [str(get_text_node(pack)) for pack in package_node.getElementsByTagName('package')]

def parse_disknod(disknod):
    return [str(get_text_node(pack)) for pack in disknod.getElementsByTagName('disknod')]

def parse_services(service_node):
    global service_level
    result = {}
    for serv in service_node.getElementsByTagName('service'):
        service_level += 1
        method = serv.getAttribute('method')
        if method == '':
            method = 'service'
        try:
            pty = string_to_bool(serv.getAttribute('pty'))
        except (TypeError, ValueError):
            pty = True
        try:
            #True : seulement en mode conteneur
            #False : seulement en mode non conteneur
            #None : dans les deux modes
            in_container = string_to_bool(serv.getAttribute('in_container'))
        except (TypeError, ValueError):
            in_container = None
        result[str(get_text_node(serv))] = {'servicelist':serv.getAttribute('servicelist'),
                'startlevel': serv.getAttribute('startlevel'),
                'stoplevel': serv.getAttribute('stoplevel'),
                'method': method,
                'pty': pty,
                'level': service_level,
                'in_container': in_container}
    return result

def parse_interfaces(interface_node):
    result = {}
    for interface in interface_node.getElementsByTagName('interface'):
        method = interface.getAttribute('method')
        if method == '':
            method = 'macvlan'
        if method not in ['macvlan', 'bridge']:
            raise Exception('method pour une interface doit être macvlan ou bridge et pas {0}'.format(method))
        result[str(get_text_node(interface))] = {'interfacelist': interface.getAttribute('interfacelist'),
                                                 'linkto': interface.getAttribute('linkto'),
                                                 'ip': interface.getAttribute('ip'),
                                                 'mask': interface.getAttribute('mask'),
                                                 'bcast': interface.getAttribute('bcast'),
                                                 'method': method
                                                }
    return result

def parse_containers(containers_node):
    result = {}
    for container_node in containers_node.getElementsByTagName('container'):
        name = str(container_node.getAttribute('name'))
        containerid = str(container_node.getAttribute('id'))
        groupid = str(container_node.getAttribute('group'))
        if name == VIRTMASTER:
            raise Exception("Le nom '%s' est interdit pour une balise <container>" % VIRTMASTER)
        if name in result:
            raise Exception("Le nom %s doit etre unique par dictionnaire" % name)

        file_nodes = parse_files(container_node)
        packages = parse_packages(container_node)
        services = parse_services(container_node)
        interfaces = parse_interfaces(container_node)
        disknods = parse_disknod(container_node)
        result[name] = [file_nodes, packages, services, interfaces, containerid, groupid, disknods]
    return result

def parse_groups(node):
    result = {}
    for group in node.getElementsByTagName('group'):
        slaves = [get_text_node(slave)
                  for slave in group.getElementsByTagName('slave')]
        result[group.getAttribute('master')] = slaves
    return result


def parse_variables(var_node):
    """
    @param var_node: node DOM des variables
    """
    result = {}
    for var in var_node.getElementsByTagName('variable'):
        try:
            hidden = string_to_bool(var.getAttribute('hidden'))
        except (TypeError, ValueError):
            hidden = False
        try:
            multi = string_to_bool(var.getAttribute('multi'))
        except (TypeError, ValueError):
            multi = False
        try:
            redefine = string_to_bool(var.getAttribute('redefine'))
        except (TypeError, ValueError):
            redefine = False
        try:
            exists = string_to_bool(var.getAttribute('exists'))
        except (TypeError, ValueError):
            exists = True
        mode = str(var.getAttribute('mode'))
        if mode != 'expert':
            mode = 'normal'
        name = var.getAttribute('name')
        value = parse_value(var)
        typ = var.getAttribute('type')
        desc = var.getAttribute('description')
        result[name] = dict(value=value,
                            type=typ,
                            description=desc,
                            hidden=hidden,
                            multi=multi,
                            auto='',
                            redefine=redefine,
                            exists=exists,
                            mode=mode
                            )
    return result


def parse_constraints(node):
    """@param node: node DOM des contraintes"""
    constraints = {'checks' : parse_funcs(node,'check'),
                   'fills' : parse_funcs(node,'fill'),
                   'auto' : parse_funcs(node,'auto'),
                   'conditions' : parse_conditions(node)
                  }
    return constraints


def parse_funcs(node, func_type):
    """
    @param node: node DOM des fonctions
    @param func_type: TagName of the functions to find
    """
    # fonctions de vérification
    funcs = {}
    for func in node.getElementsByTagName(func_type):
        # lecture des paramètres
        # XXX (adim): est-ce que le fait que params ne soit pas réinitialisé
        #             à chaque tour de boucle "for target in targets" est un bug ?
        params = []
        targets = [ get_text_node(t) for t in func.getElementsByTagName('target') ]
        if not targets:
            targets = [func.getAttribute('target')]
        for target in targets:
            if target is not None:
                for param in func.getElementsByTagName('param'):
                    params.append(parse_param(param))
                funcs.setdefault(target, []).append([func.getAttribute('name'),
                                                     params])
    return funcs

def parse_conditions(node):
    """
    @param node: node DOM des fonctions
    """
    # fonctions de vérification
    funcs = {}
    for func in node.getElementsByTagName('condition'):
        # lecture des paramètres
        targets = []
        family_targets = []
        file_targets = []
        filelist_targets = []
        servicelist_targets = []
        interfacelist_targets = []
        # paramètres de la fonction
        params = [parse_param(param)
                  for param in func.getElementsByTagName('param')]
        # cibles de la dépendance
        for target in func.getElementsByTagName('target'):
            ttype = target.getAttribute('type')
            if ttype == 'family':
                family_targets.append(get_text_node(target))
            elif ttype == 'file':
                file_targets.append(get_text_node(target))
            elif ttype == 'filelist':
                filelist_targets.append(get_text_node(target))
            elif ttype == 'servicelist':
                servicelist_targets.append(get_text_node(target))
            elif ttype == 'interfacelist':
                interfacelist_targets.append(get_text_node(target))
            else:
                targets.append(get_text_node(target))
        funcdef = [func.getAttribute('name'), family_targets, targets,
                   file_targets, filelist_targets, servicelist_targets, interfacelist_targets, params]
        funcs.setdefault(func.getAttribute('source'), []).append(funcdef)
    return funcs


def parse_help(node):
    var_help = dict( (var.getAttribute('name'), get_text_node(var).strip())
                     for var in node.getElementsByTagName('variable') )
    fam_help = dict( (var.getAttribute('name'), get_text_node(var).strip())
                     for var in node.getElementsByTagName('family') )
    return {'variables':var_help, 'families': fam_help}

def parse_separators(node):
    """dictionnaire des séparateurs, format {'variable':'text'}
    variable : nom de la première variable après le sépateur"""
    var_sep = {}
    for var in node.getElementsByTagName('separator'):
        var_sep[var.getAttribute('name')] = (get_text_node(var).strip(), _get_boolean_attr(var, 'never_hidden'))
    return var_sep

def parse_param(param_node):
    return {'name'  : param_node.getAttribute('name'),
            'type'  : param_node.getAttribute('type'),
            'value' : get_text_node(param_node),
            'optional' : param_node.getAttribute('optional'),
            'hidden' : param_node.getAttribute('hidden'),
            }

def parse_value(varnode):
    return [get_text_node(val) for val in varnode.getElementsByTagName('value')]

def parse_families(var_node):
    result = {}
    order = []
    families = var_node.getElementsByTagName('family')
    for family in families:
        family_name = family.getAttribute('name')
        order.append(family_name)
        hidden = family.getAttribute('hidden')
        mode = family.getAttribute('mode')
        if hidden == 'True':
            hidden = True
        else:
            hidden = False
        result[family_name] = {'hidden':hidden, 'mode':mode, 'vars':get_vars_name(family, family_name, result)}
    return result, order


def get_vars_name(family_node, family_name, family_parse):
    varsname = []
    for var in family_node.getElementsByTagName('variable'):
        try:
            redefine = string_to_bool(var.getAttribute('redefine'))
        except:
            redefine = False
        varsname.append(var.getAttribute('name'))
    return varsname

