# -*- coding: UTF-8 -*-
"""
Fonctions de gestion des locks Eole
"""
from os import unlink, system
from os.path import join, isfile
from creole2.config import LOCK_PATH, LOCK_FILES
from pyeole2 import lock

def add_lock(lock_name):
    """création d'un lock
    renvoie False si le fichier n'a pas pu être créé
    """
    return lock.add_lock(LOCK_PATH, lock_name)

def del_lock(lock_name):
    """suppression d'un lock
    True si existant, False sinon
    """
    return lock.del_lock(LOCK_PATH, lock_name)

def check_lock(lock_name):
    """Test d'existance d'un lock
    """
    return lock.check_lock(LOCK_PATH, lock_name)

def check_all_locks():
    """Test d'existance de l'un des locks
    du système
    """
    for lock_file in LOCK_FILES:
        if lock.check_lock(LOCK_PATH, lock_file):
            return lock_file
    return ''

