# -*- coding: utf-8 -*-
"""
fonctions communes Creole
"""
import glob
import subprocess
import os, time, sys, signal
from os.path import join, isfile
from pyeole2.ihm import question_ouinon
from pyeole2.process import system_out, system_code
from pyeole2.ansiprint import print_orange
from creole2 import config
from creole2.eosfunc import test_vz


def patch():
    """
    applique les patchs
    """
    distrib_dir = config.distrib_dir
    patch_dir = config.patch_dir
    template_dir = config.templatedir
    var_dir = join(patch_dir,'variante')
    # sauvegarde du répertoire de départ
    cur_dir = os.getcwd()
    os.chdir(template_dir)
    # purge du répertoire de travail (#6600)
    os.system('rm -f %s/*' % template_dir)
    # copie des templates originaux
    os.system('cp -f %s/* %s' % (distrib_dir, template_dir))
    # patches variante + locaux
    for directory in [var_dir, patch_dir]:
        patches = os.listdir(directory)
        for pat in patches:
            if pat.endswith('.patch'):
                os.system('patch -N -p1 < %s >> %s' % (
                           join(directory, pat), config.logfile))
    os.chdir(cur_dir)

######################
# Gestion des noyaux #
######################

def get_wanted_kernel():
    """
    renvoie le nom du noyau sur lequel on veut tourner
    """
    if isfile(config.LOCALKERNEL_FILE):
        # noyau personnalisé détecté
        kernel_file = config.LOCALKERNEL_FILE
    elif isfile(config.KERNEL_FILE):
        kernel_file = config.KERNEL_FILE
    else:
        print "\n!! Fichier de définition noyau non trouvé !!\n"
        return get_current_kernel()
    return file(kernel_file).read().strip()

def get_current_kernel():
    """
    renvoie le nom du noyau sur lequel on tourne
    """
    return system_out(['uname', '-r'])[1].strip()

def get_installed_kernel(kernel):
    """
    renvoie la liste des noyaux installés
    correspondant à celui demandé
    """
    cmd = """COLUMNS=180 dpkg -l 2>/dev/null |  awk -F " " '/^(i|h)i.*%s/ {print $2}'""" % kernel
    return os.popen(cmd).read().splitlines()

def get_eole_kernel():
    """
    renvoie le nom du noyau recommandé par EOLE
    (en dépendance de linux-image-eole)
    """
    kernels = []
    cmd = ['dpkg-query', '-W', "-f=${Depends}", 'linux-image-eole']
    depends = system_out(cmd)[1].split(',')
    for dep in depends:
        if dep.startswith('linux-image-'):
            kernels.append(dep.lstrip('linux-image-'))
    return kernels

def get_headers_depend(version, packages):
    """Return headers package dependency
    """
    keep_packages = []
    headers_package = 'linux-headers-{0}'.format(version)
    if headers_package in packages and headers_package.endswith('-eole'):
        # EOLE headers require base headers
        keep_packages.append(headers_package.rstrip('-eole'))
    return keep_packages

def controle_kernel():
    """
    Vérifie si on est sur le noyau désiré
    Renvoie True si un reboot est nécessaire
    """
    need_boot = False
    if isfile(config.REBOOT_FILE):
        # i.e. /var/run/reboot-required
        need_boot = True

    wanted_kernel = get_wanted_kernel()
    # on utilise le noyau spécifié
    if wanted_kernel != get_current_kernel():
        need_boot = True
        # Update grub does the job since eole-kernel-version 2.3-eole37~2
        print "Mise à jour de la configuration Grub :"
        system_code("/usr/sbin/update-grub2")
    # reboot nécessaire ?
    return need_boot

def regen_initrd():
    """
    vérifie la présence de l'initrd
    """
    noyau = get_wanted_kernel()
    if not isfile("/boot/initrd.img-%s" % noyau):
        print "Initramfs manquant, génération :"
        cmd = ["/usr/sbin/update-initramfs", '-c', '-k', noyau]
        system_code(cmd)

def remove_kernel():
    """
    Suppression de tous les noyaux sauf :
        - le noyau courant
        - le noyau demandé par EOLE
        - l'éventuel noyau personnalisé
    """
    # paquets spéciaux
    eole_kernel = ['linux-firmware', 'linux-eole', 'linux-image-eole',
                   'linux-headers-eole', 'linux-libc-dev', 'xtables-addons-modules-eole']
    # ajout des noyaux EOLE et personnalisé
    for kernel_file in [config.KERNEL_FILE, config.LOCALKERNEL_FILE]:
        if isfile(kernel_file):
            kernel = open(kernel_file).read().strip()
            eole_kernel.extend(get_installed_kernel(kernel))
            eole_kernel.extend(get_headers_depend(kernel, eole_kernel))
    # ajout du noyau courant et du noyau recommandé
    # avec les dépendances de leur headers
    for kernel_version in [get_current_kernel()] + get_eole_kernel():
        if 'linux-image-{0}'.format(kernel_version) not in eole_kernel:
            eole_kernel.extend(get_installed_kernel(kernel_version))
            eole_kernel.extend(get_headers_depend(kernel_version, eole_kernel))

    # liste des noyaux installés
    list_kernel = get_installed_kernel('linux-')

    # Add xtables-addons-modules
    list_kernel.extend(get_installed_kernel('xtables-addons-modules-'))

    kernel_keep_list = []
    # recherche des sous-chaines
    for kern in list_kernel:
        for list_k in eole_kernel:
            if list_k in kern:
                kernel_keep_list.append(kern)

    kernel_remove_list = list(set(list_kernel)-set(kernel_keep_list))
    ficlog = open('/var/log/remove-package-eole.log','w')
    for uninstall_kernel in kernel_remove_list:
        ficlog.write("===================== %s ====================="%time.ctime())
        print "Désinstallation du paquet %s ... " % uninstall_kernel.strip()
        pop = subprocess.Popen(args=["apt-get remove -q --purge --force-yes --assume-yes %s" % uninstall_kernel], stdout=subprocess.PIPE, shell=True)
        output = pop.stdout.read()
        ficlog.write(output)
    ficlog.close()

    return True

def remove_package():
    """
    Suppresion des paquets demandés par la liste /usr/share/eole/remove.d/*
    """
    ficlog = open('/var/log/remove-package-eole.log','w')
    remove = []
    if not os.path.isdir('/usr/share/eole/remove.d'):
        print "Répertoire /usr/share/eole/remove.d non trouvé"
        return False
    for files in glob.glob('/usr/share/eole/remove.d/*.conf'):
        remove.extend(open(files).read().splitlines())

    for deb in remove:
        deb = deb.strip()
        process = subprocess.Popen(args=["dpkg", "-l", deb.strip()],
                                   stdout=subprocess.PIPE,
                                   stderr=subprocess.PIPE, shell=False)
        code = process.wait()
        if code != 0:
            # paquet non installé
            continue
        dpkg_info = process.stdout.read()
        pkg_status = dpkg_info.strip().split('\n')[-1].split()
        if pkg_status[0].lower() in ['pn', 'un']:
            # ancien paquet purgé (status = pn) ou desinstallé (status = un)
            continue
        # on vérifie que le status est bien "installé"
        ficlog.write("===================== %s ====================="%time.ctime())
        print "Désinstallation du paquet %s ... " % deb.strip()
        pop = subprocess.Popen(args=["apt-get remove -q --purge --force-yes --assume-yes %s" % deb], stdout=subprocess.PIPE, shell=True)
        output = pop.stdout.read()
        ficlog.write(output)
    ficlog.close()
    return True

def purge_rc():
    """
    Purge des paquets "rc"
    """
    cmd = """COLUMNS=180 dpkg -l|grep "^rc"|awk -F " " '{print $2}'"""
    rcs = os.popen(cmd).read().splitlines()
    for pak in rcs:
        os.system("dpkg -P %s >/dev/null" % pak)

def zephir(etat, msg, type_proc):
    """ gestion des messages Zephir """
    # selon l'etat donné, on indique l'état de la tache
    etat_zeph = None
    if etat.upper().startswith("INIT"):
        etat_zeph = -1
    elif etat.upper().startswith("FIN"):
        etat_zeph = 0
    elif etat.upper().startswith('ERR'):
        etat_zeph = 1
    elif etat.upper().startswith('MSG'):
        etat_zeph = -2
    # log local si msg ou erreur
    if (len(msg) > 0) or (etat.upper() == "ERR"):
        log(etat, msg, type_proc)
    # log sur zephir si disponible
    if etat_zeph is not None and config.zephir_actif:
        config.log(type_proc, etat_zeph, msg, str(time.ctime()))

def log(etat, msg, type_proc):
    """
    effectue un log local et éventuellement sur zephir
    """
    if etat == "ERR":
        sys.stderr.write("\n%s : Erreur => %s\n" % (type_proc, msg))
    # log local
    os.system("""/usr/bin/logger -t \"zephir\" -p local2.err  \"%s => %s : %s \" """ % (type_proc, etat, msg))

def init_proc(type_proc):
    """
    initialisation d'une procédure (log démarrage + bcage éventuel)
    """
    if verify_lock(type_proc):
        return True
    else:
        return False

#def end_proc(etat,msg,type_proc):
#    """
#    loggue la fin d'une procédure
#    """
#     log(etat,msg,type_proc )

def verify_lock(name):
    """
    vérifie le bloquage ou non d'une  procédure
    """
    LOCK_FILE = "/usr/share/zephir/zephir_locks"
    if name == "":
        return True
    from zephir.lib_zephir import zephir_path
    try:
        from zephir.lib_zephir import config, zephir, convert
        locks = convert(zephir.serveurs.get_locks(config.id_serveur))
        if locks[0] == 0:
            # erreur sur zephir, on ignore cette phase
            raise Exception
        locks = [lock[0] for lock in locks[1]]
    except Exception, mess:
        # pas de message d'erreur si le serveur n'est pas enregistré
        zephir_error = False
        if isfile(join(zephir_path, "zephir_conf", "zephir_conf.py")):
            # on ne bloque pas si l'appel à zephir échoue
            print ""
            print_orange("Impossible de vérifier sur Zéphir les interdictions pour %s" %name)
            print_orange("Message d'erreur : %s" % str(mess))
            zephir_error = True
        # on regarde le denier état
        if os.path.exists(LOCK_FILE):
            if zephir_error:
                print_orange("Utilisation des paramètres en cache")
            file_lock = file(LOCK_FILE)
            locks = file_lock.read().split('\n')
            file_lock.close()
            # on bloque si interdit
            if name in locks:
                return False
    else:
        # mise en place du fichier de droits
        content = "\n".join(locks)
        try:
            file_lock = file(LOCK_FILE, "w")
            file_lock.write(content)
            file_lock.close()
        except:
            print "impossible de mettre à jour %s (droits insuffisants)" % LOCK_FILE
        # retour du code
        if name in locks:
            return False
    return True

def register_ead(dico):
    """
        Enregistrement de l'EAD local
    """
    if dico['adresse_ip_eth0'] == '':
        return
    sys.path.insert(1, '/usr/share')
    try:
        from ead2.frontend.web.lib.servers import servers
        from ead2.lib.libead import EadKeyParser
        from ead2.lib.crypto import create_key as create_magicnb
        from ead2.backend.config.config import CONFIG_DIR, FRONTEND_KEYS_FILE
        from ead2.config.config import BACKEND_LISTEN_PORT
    except:
        return
    ead = EadKeyParser()
    ead.parse_file(join(CONFIG_DIR, FRONTEND_KEYS_FILE))
    if ead.get_key_dict() != {}:
        # des frontend sont déjà enregistrés
        return
    key = create_magicnb('admin','admin')
    dic = {'127.0.0.1' : key}
    # ecriture clé ead-serveur
    ead.write_file(join(CONFIG_DIR, FRONTEND_KEYS_FILE), dic)
    # ecriture clé ead-web
    servers().add_server('https://127.0.0.1',
                         str(BACKEND_LISTEN_PORT),
                         dico['nom_machine'],
                         str(key))

def register_module(ask=False):
    """
    Enregistrement Eole
    """
    if test_vz():
        # les serveurs virtuels sont exemptés d'enregistrement
        return
    os.system("/usr/share/creole/diag.py &>/dev/null &")
    tool_dir = '/usr/share/register'
    if not os.path.isdir(tool_dir):
        # eole-register pas installé ?
        return
    if not isfile(join(tool_dir,'.registerok')):
        # pas d'enregistrement préalable
        if not ask:
            return
        print
        print "http://eole.ac-dijon.fr/materiel/ vous permet de consulter une base des matériels compatibles"
        if question_ouinon("Pour enrichir cette base, acceptez-vous l'envoi de la description matérielle de ce serveur ?", 'oui') == 'non':
            return
        file(join(tool_dir, '.registerok'), 'w').close()

    sys.path.append('/usr/share/')
    from register import register
    os.chdir(tool_dir)
    register.initialize()

def proper_exit(*args):
    """callback à appeler lors d'un ctrl-c"""
    print("Abandon utilisateur")
    os._exit(1)

def catch_signal(exit_func=None):
    """gestion du ctrl-c"""
    if not exit_func:
        signal.signal(signal.SIGINT, proper_exit)
    else:
        signal.signal(signal.SIGINT, exit_func)

