# -*- coding: UTF-8 -*-

"""

Interface ligne de commande pour créole

"""

from creole2 import config
from creole2.error import TemplateError
from os import listdir
from os.path import join, isdir
import sys
from creole2.log import logger

__version__ = '%prog v0.1'


def parse_command_line():
    """
    Construit le parser d'options de la ligne de commande,
    parse la ligne de commande, et retourne les options
    """

    from optparse import OptionParser
    parser = OptionParser("""\n%prog [options] <data_file>""", version = __version__)

    parser.add_option("-t", "--templatedir", dest="templatedir",
                      default=config.templatedir,
                      help="repertoire de base des templates",
                      metavar="TEMPLATEDIR")

    parser.add_option("-c", "--creolefile", dest="eoledirs",
                      default=config.eoledirs,
                      help="fichier xml creole",
                      metavar="CREOLEFILE")

   # parser.add_option("-d", "--datafile", dest="datafile",
   #                   default=None,
   #                   help="fichier de donnees",
   #                   metavar="DATAFILE")

   # parser.add_option("-l", "--log", dest="logfile",
   #                   default=config.logfile,
   #                   help="fichier de rapport d'instanciation",
   #                   metavar="LOGFILE")

    options, args = parser.parse_args()

    # le fichier de donné est un argument obligatoire
    if len(args) != 1:
        parser.print_usage()
        sys.exit(1)

    return options, args[0]


def load(data_file=config.configeol, silent=False):
    """
    Gestion de la ligne de commande pour dialog
    """

    from creole2 import cfgparser

    d = cfgparser.EoleDict(templatedir = config.templatedir)

    # définition de l'emplacement des dictionnaires
    dictionnaires = []
    #dirs = ['eole/dicos/local', 'eole/dicos/', 'eole/dicos/variante']
    if type(config.eoledirs) == list:
        dirs = config.eoledirs
    else:
        dirs = [config.eoledirs]
    # lecture dictionnaires principaux
    for my_dir in dirs:
        if isdir(my_dir):
            fichiers = listdir(my_dir)
            fichiers.sort()
            for dico in fichiers:
                if dico.endswith('.xml'):
                    # ajout des dicos additionnels
                    dictionnaires.append(join(my_dir,dico))

    for dictionnaire in dictionnaires:
        # chargement des dictionnaires:
        try:
            if not silent:
                print "chargement des paramètres :", dictionnaire
            d.read(dictionnaire)
        except Exception, e:
            print 'erreur lors du chargement de %s : %s' % (dictionnaire, str(e))
            raise TemplateError, e

    if data_file != None:
        print "chargement des valeurs"
        d.load_values(data_file)
    return d

def lxc_install(dico, container=None):
    #fonction utilise par gen_conteneurs
    print "Installation des conteneurs"
    dico.lxc_install(container=container)

def lxc_postinstall(dico, container=None):
    try:
        print "\n## Postconfiguration des conteneurs ##"
        dico.lxc_postinstall(container=container)
    except Exception, e:
        print e

def test_container_conf(dico):
    dico.test_container_conf()

def services(dico, container=None):
    try:
        dico.write_init_service()
        dico.instance_services(container=container)
    except Exception, e:
        print "erreur : %s" % str(e)

def run(data_file=config.configeol, dico=None, container=None, debug=False):
    if dico == None:
        d = load(data_file, silent=True)
    else:
        d = dico
    try:
        d.instance(container=container)
    except TemplateError, e:
        if debug:
            print "erreur d'instanciation : %s" % str(e)
        else:
            print (str(e))
            raise TemplateError, e
        print "Fin de l'instanciation, veuillez consulter le fichier de log %s"%config.logfile

if __name__ == "__main__" :
    try:
        run()
    except TemplateError:
        sys.exit(1)
