#-*-coding:utf-8-*-
from ConfigParser import ConfigParser
KEYS = ['val', 'valprec', 'valdefault']

class Dico(ConfigParser):

    def get_val(self, var, default=''):
        """
        Renvoie la valeur (en string !) d'une variable
        ou la valeur de default
        """
        if self.has_section(var):
            return self.get(var, 'val')
        return default

    def copy(self, old, new):
        """
        Renomme ou copie une variable
        vers une autre
        """
        if self.has_section(old):
            if not self.has_section(new):
                self.add_section(new)
            for key in KEYS:
                value = self.get(old, key)
                if key == 'val': print new, '=', value
                self.set(new, key, value)

    def simple2multi(self, src, new):
        """
        n variables simples => 1 multi
        """
        res = []
        for var in src:
            if self.has_section(var):
                try:
                    value = eval(self.get(var, 'val'))[0]
                    if value != '':
                        res.append(value)
                except:
                    print "variable source %s invalide" % var
        if res != []:
            self.fill_var(new, res)

    def fill_var(self, var, val, valprec=[], valdefault=[]):
        """
        Crée ou met à jour une variable
        """
        if type(val) != list:
            val = [val]
        if not self.has_section(var):
            self.add_section(var)
        print var, '=', val
        self.set(var, 'val', val)
        self.set(var, 'valprec', valprec)
        self.set(var, 'valdefault', valdefault)

    def save(self, fichier):
        """
        Enregistre le résultat
        """
        fic = file(fichier, 'w')
        self.write(fic)
        fic.close()

def upgrade(configfile):
    """
    Mise à jour d'un fichier .eol
    de 2.2 vers 2.3
    """
    dico = Dico(dict_type=dict)
    dico.read(configfile)

    # famille General
    dico.copy('proxy', 'activer_proxy_client')
    dico.copy('proxy_server', 'proxy_client_adresse')
    dico.copy('proxy_port', 'proxy_client_port')
    dico.simple2multi(['serveur_maj', 'serveur_maj2'], 'serveur_maj')
    # spécifique Amon
    domaine = dico.get_val('nom_domaine_academique')
    if domaine != '':
        if '.' in domaine:
            ac, dom = eval(domaine)[0].rsplit('.', 1)
        else:
            # gère le cas particulier de sphynx ou le suffixe n'était pas
            # dans le domaine académique (.fr par défaut)
            ac = eval(domaine)[0]
            dom = 'fr'
        dico.fill_var('nom_academie', ac)
        dico.fill_var('suffixe_domaine_academique', dom)
    # rien sur Zéphir 2.2
    if dico.has_section('ip_ssh_eth0'):
        # ip/netmask facultatifs sur Scribe-2.2
        if 'oui' in dico.get_val('ssh_eth0') and dico.get_val('ip_ssh_eth0') == '[]':
            dico.fill_var('ip_ssh_eth0', '0.0.0.0')
            dico.fill_var('netmask_ssh_eth0', '0.0.0.0')
        # pas de ssh_eth0 sur Horus-2.2
        if not dico.has_section('ssh_eth0'):
            # FIXME ip_ssh_eth0 semble faculatif
            dico.fill_var('ssh_eth0', 'oui')
        # familles Interface-X
        for num in range(0, 5):
            dico.copy('ssh_eth%s' % num, 'admin_eth%s' % num)
            dico.copy('ip_ssh_eth%s' % num, 'ip_admin_eth%s' % num)
            dico.copy('netmask_ssh_eth%s' % num, 'netmask_admin_eth%s' % num)
    dico.copy('agregation', 'activer_agregation')

    # famille Services
    dico.copy('cups', 'activer_cups')
    dico.copy('dhcp', 'activer_dhcp')
    dico.copy('ftp_perso', 'activer_proftpd')
    dico.copy('ead_web', 'activer_ead_web')
    dico.copy('apache', 'activer_apache')
    dico.copy('mysql', 'activer_mysql')
    dico.copy('xinet_interbase', 'activer_interbase')
    if 'oui' in dico.get_val('sso'):
        dico.fill_var('activer_sso', 'local')
    else:
        dico.fill_var('activer_sso', 'non')

    # famille Messagerie
    dico.copy('passerelle_smtp_aca', 'passerelle_smtp')
    dico.copy('spamassassin', 'activer_spamassassin')
    if 'oui' in dico.get_val('courier_imap'):
        if 'oui' in dico.get_val('courier_pop'):
            dico.fill_var('activer_courier', 'pop - imap')
        else:
            dico.fill_var('activer_courier', 'imap')
    elif 'oui' in dico.get_val('courier_pop'):
        dico.fill_var('activer_courier', 'pop')
    else:
        dico.fill_var('activer_courier', 'non')
    # Zéphir
    dico.copy('serveur_smtp', 'passerelle_smtp')
    dico.copy('compte_smtp', 'system_mail_from')
    if '465' in dico.get_val('port_smtp'):
        dico.fill_var('tls_smtp', 'port 465')

    # famille Client_ldap
    dico.copy('base_ldap', 'ldap_base_dn')
    serveur_ldap = dico.get_val('serveur_ldap', '[]')
    if serveur_ldap != '[]':
        dico.copy('serveur_ldap', 'adresse_ip_ldap')
        if eval(serveur_ldap)[0] not in ['127.0.0.1', 'localhost']:
            dico.fill_var('activer_client_ldap', 'distant')

    # famille Eole-sso
    dico.copy('adresse_ip_sso', 'eolesso_adresse')
    dico.copy('port_sso', 'eolesso_port')
    # eolesso_ldap (multi)
    dico.copy('ldap_sso', 'eolesso_ldap')
    dico.copy('port_ldap_sso', 'eolesso_port_ldap')
    dico.copy('base_ldap_sso', 'eolesso_base_ldap')
    dico.copy('sso_ldap_label', 'eolesso_ldap_label')
    dico.copy('sso_ldap_reader', 'eolesso_ldap_reader')
    dico.copy('sso_ldap_reader_passfile', 'eolesso_ldap_reader_passfile')
    # la "suite"
    dico.copy('adresse_sso_parent', 'eolesso_adresse_parent')
    dico.copy('port_sso_parent', 'eolesso_port_parent')
    dico.copy('sso_pam_securid', 'eolesso_pam_securid')
    dico.copy('sso_cert', 'eolesso_cert')
    dico.copy('sso_ca_location', 'eolesso_ca_location')
    dico.copy('sso_session_timeout', 'eolesso_session_timeout')
    dico.copy('sso_css', 'eolesso_css')

    # famille Applications web
    dico.copy('phpmyadmin', 'activer_phpmyadmin')
    dico.copy('posh', 'activer_envole')
    dico.copy('web_domain', 'web_url')
    dico.copy('web_default', 'web_redirection')
    posh_path = dico.get_val('posh_path', '[]')
    if posh_path != '[]' and eval(posh_path)[0] != '':
        dico.fill_var('alias_envole', '/' + eval(posh_path)[0])

    # famille Bacula
    if 'oui' in "%s%s%s" % (dico.get_val('active_bacula_dir'),
                            dico.get_val('active_bacula_fd'),
                            dico.get_val('active_bacula_sd')):
        dico.fill_var('activer_bacula', 'oui')
        dico.copy('active_bacula_dir', 'activer_bacula_dir')
        dico.copy('active_bacula_sd', 'activer_bacula_sd')
        # bacula_fd n'est plus géré
    else:
        dico.fill_var('activer_bacula', 'non')

    # famille Clamav
    dico.copy('enable_clamd', 'dansguardian_clam')

    # famille Certifs-ssl
    dico.copy('ssl_serveur_name', 'ssl_server_name')

    # famille Authentification
    dico.copy('active_nufw', 'activer_nufw')
    dico.copy('freeradius', 'activer_freeradius')

    # famille Logs
    if 'Oui' in dico.get_val('activate_tls'):
        dico.fill_var('rsyslog_tls', 'oui')

    # famille Reverse proxy
    revprox = dico.get_val('revprox_domainname', '[]')
    if revprox != '[]' and eval(revprox)[0] != '':
        dico.fill_var('revprox_activate_http', 'oui')

    # famille réseau avancé
    route = dico.get_val('route_adresse', '[]')
    if route != '[]' and eval(route)[0] != '':
        dico.fill_var('activer_route', 'oui')

    # famille Vpn-pki
    dico.simple2multi(['url_crl1', 'url_crl2'], 'url_crl')

    return dico._sections
