# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# db_utils.py
#  
# fonctions utiles pour l'accès à la base de données (via adbapi)
#       
###########################################################################
from zephir.backend import config
from twisted.enterprise import adbapi
import traceback

class DBException(Exception): pass

def db_client_failed(error,*args):
    """errback du deffered
    """
    try:
        traceback.print_exc()
        return 0, str(error.type), error.getErrorMessage()
    except:
        return 0,''

def dbClientSucceeded(l):
    """callback du deffered
    """
    if l:
        return 1,'ok'
    else:
        return 0,"no records"
        raise DBException("No records")

def db_connect():
    """crée un pool de connexion pour la base de données zephir
    """
    return adbapi.ConnectionPool("psycopg2",host=config.DB_HOST,user=config.DB_USER,password=config.DB_PASSWD,database=config.DB_NAME)

def db_log(dbpool,id_serveur,date,type_msg,msg):
    """insère un log dans la base zephir
    """
    query = """insert into log_serveur (id_serveur,date,type,message) values (%s,%s,%s,%s)"""
    return dbpool.runOperation(query, (int(id_serveur),date,type_msg,msg))

class Serveur:
    """classe utilitaire pour récupérer diverses données sur un serveur"""

    def __init__(self, id_s):
        """initialise l'objet serveur et récupère les infos
        """
        # réucpération de l'établissement et de l'état
        import psycopg2 as pgsql
        cx = PgSQL.connect(database=config.DB_NAME,user=config.DB_USER,password=config.DB_PASSWD)
        cu = cx.cursor()
        cu.execute("select * from serveurs where id=%s", (int(id_s),))
        cu.close()
        cx.close()

