# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
Fichier de configuration de l'application Zephir
"""
from os.path import join, dirname, abspath, isdir, isfile
from os import listdir
from creole.client import CreoleClient
import locale
from twisted.python import log
log.FileLogObserver.timeFormat = "%Y/%m/%d %H:%M:%S %Z"

# XXX FIXME / config template
conf = CreoleClient()

charset = "UTF-8"

ADRESSE_LDAP = conf.get_creole("adresse_ip_ldap", "localhost") or "localhost"
ADRESSE_ZEPHIR = conf.get_creole("adresse_ip_eth0") or "localhost"
BASE_LDAP = conf.get_creole("ldap_base_dn", "o=gouv, c=fr") or "o=gouv,c=fr"
LDAP_CLIENT = conf.get_creole('activer_client_ldap', "local") or "local"
if LDAP_CLIENT == "local":
    LDAP_TLS = "non"
else:
    LDAP_TLS = conf.get_creole("ldap_tls", "non") or "non"
PORT_HTTP = "8090"
PORT_ZEPHIR = "7080"
PORT_WEB = 8070
NO_LOCAL_AGENTS = conf.get_creole("no_local_agents", "non") or "non"

NOBODY_GID = NOBODY_UID = 65534

LOG_ACTIONS = False
if (conf.get_creole('log_actions', 'non') or 'non') == 'oui':
    # Logguer les appels xmlrpc authentifiés dans les logs du backend
    LOG_ACTIONS = True

USE_THREADS = False
# mise en cache des configurations creole
if (conf.get_creole('zephir_use_threads', 'oui') or 'oui') == 'oui':
    # conservation en mémoire de la configuration creole des serveurs
    USE_THREADS = True
CREOLE_CACHE = False
# mise en cache des configurations creole
if (conf.get_creole('zephir_creole_cache', 'oui') or 'oui') == 'oui':
    # conservation en mémoire de la configuration creole des serveurs
    CREOLE_CACHE = True

# répertoire de base appli
ROOT_DIR = "/usr/share/zephir/"
PORT_AGENT = "8090"
AGENT_DIR = "agents"
CLIENT_UPDATE_HOST = "eoleng.ac-dijon.fr"
CLIENT_NG_URL = "/eoleng/eole-%s-security/%s"
SERVEURS_MAJ_CLIENTS = conf.get_creole('serveur_maj_clients', []) or []

MAIL_ADRESSE = conf.get_creole("passerelle_smtp", "localhost") or "localhost"
MAIL_TLS = conf.get_creole("tls_smtp", "non") or "non"
MAIL_ACCOUNT = conf.get_creole("system_mail_from", "") or ""

# répertoire de base des donnees backend
PATH_ZEPHIR = "/var/lib/zephir/"
PATH_TEMP = join("/tmp", "zephir_temp")
PATH_MODULES = PATH_ZEPHIR + 'modules/'
ADRESSE_SAUVEGARDE = join(PATH_ZEPHIR, 'user_prefs')

# certificats par défaut
cert_file = conf.get_creole('server_cert', '/etc/eole/ssl/eole.crt') or '/etc/eole/ssl/eole.crt'
key_file = conf.get_creole('server_key', '/etc/eole/ssl/eole.key') or '/etc/eole/ssl/eole.key'

# manager prelude par défaut
PRELUDE_PORT = 4691

# détails des distributions gérées (nom_de_code, version_eole, maintenue)
DISTRIBS = {1:("Mdk 9.X", "1.X", False),
            2:("feisty", "2.0", False),
            3:("gutsy", "2.1", False),
            4:("hardy", "2.2", False),
            5:("lucid", "2.3", False),
            6:("precise", "2.4", True),
            7:("precise", "2.4.1", True),
            8:("precise", "2.4.2", True),
            9:("trusty", "2.5.0", True),
            10:("trusty", "2.5.1", True),
            11:("trusty", "2.5.2", True)}

# version de creole en fonction de la version de distribution eole
CREOLE_VERSIONS = {1:'creole1',
                   2:'creole2',
                   3:'creole2',
                   4:'creole2',
                   5:'creole2',
                   6:'creole3',
                   7:'creole3',
                   8:'creole3',
                   9:'creole3',
                   10:'creole3',
                   11:'creole3',
                  }

# versions d'envole en fonction de la version eole
ENVOLE_VERSION = {8:"4", 9:"4", 10:"4", 11:"5"}

liste_modules = {}
PATH_DEF_MODULES = join(ROOT_DIR, 'default_modules')
# liste des modules eole, classés par version (la version 1 n'est plus gérée)
liste_modules = {
 1:['amon-1.5','sphynx-1.1','scribe-1.0','horus-1.0']
}
for num_dist in DISTRIBS.keys()[1:]:
    # recherche des modules Eole NG par défaut
    modules = []
    dist_dir = join(PATH_DEF_MODULES, str(num_dist))
    for mod_name in listdir(dist_dir):
        # on ignore les fichiers ~, .bak, etc...
        if isfile(join(dist_dir, mod_name)) and not \
                (mod_name.endswith('~') or \
                mod_name.endswith('.bak') or \
                mod_name.endswith('.swp')):
                # on vérifie qu'un répertoire de dictionnaires est bien présent pour ce module
                # if isdir(join(ROOT_DIR, 'dictionnaires', mod_name)):
                modules.append(mod_name)
    liste_modules[num_dist] = modules

default_upgrades = {2:[4], 4:[5,6,7,8,9,10,11], 5:[7,8,9,10,11], 6:[8,9,10,11], 7:[9,10,11], 8:[10,11]}
# liste des modules autorisés à migrer de plus d'une version
allowed_upgrades = {'horus': default_upgrades,
                    'scribe': default_upgrades,
                    'amon': default_upgrades,
                    'sphynx': default_upgrades,
                    'eolebase': default_upgrades,
                    'amonecole': default_upgrades,
                    'esbl':{4:[7], 5:[7,8,10,11]},
                    'ecdl':{4:[7], 5:[7,8,10,11]},
                    'seshat':{5:[9,10,11]},
                   }

# définition des migrations entre modules (adaptation de configuration nécessaire)
allowed_migrations = {1:[2,3,4], 4:[5,6,7,8,10,11], 5:[6,7,8,9,10,11], 6:[9,10,11], 7:[9,10,11], 8:[9,10,11]}

# liste des modules autorisés à être modifiés (édition de serveur)
default_mod_edits = {'amon':['amonecole'], 'amonecole':['amon']}
allowed_mod_edits = {4: default_mod_edits,
                     5: default_mod_edits,
                     7: default_mod_edits,
                     8: default_mod_edits,
                     9: default_mod_edits,
                     10: default_mod_edits,
                     11: default_mod_edits,
                    }

# liste des verrous existants et de leurs dépendances
verrous = {'uucp':['Execution des tâches Zephir'],
           'sauvegarde':['Maj-Auto','Maj-Cd'],
           'maj':[],
           'configure':[],
           'reconfigure':[]}

# types  de fichiers à sauvegarder/envoyer
data_files = {0:('Tout', ['dicos','patchs','fichiers_perso','fichiers_zephir','zephir.eol','dico.eol','auth_keys','droits_zephir', 'droits_variante']),
              1:('Dictionnaires/templates/patchs/configuration/clés ssh', ['dicos','patchs','fichiers_perso','zephir.eol','auth_keys']),
              2:('Dictionnaires/templates/patchs', ['dicos','patchs','fichiers_perso']),
              3:('Fichiers divers/paquets', ['fichiers_zephir', 'droits_zephir', 'droits_variante']),
              4:('Configuration seulement (config.eol)', ['zephir.eol']),
              5:('Clés ssh seulement', ['auth_keys']),
             }

# libellés à affecter aux différents types de restrictions de ressources, table et champs correspondant (pour validation)
type_res_label =  {'rne':('numéro RNE', 'etablissements', 'rne'),
                   'groupe':('numéro de groupe', 'groupes_serveurs', 'id'),
                   'id_s':('numéro de serveur', 'serveurs', 'id'),
                   'id_var':('numéro de variante', 'variantes', 'id'),
                   'id_mod':('numéro de module', 'modules', 'id'),
                  }

# correspondance des caractères pour les xml des agents eole1
xml_table={'\\xc9':'\\xc3\\xa9',
           '\\xe9':'\\xc3\\xa9',
           '\\xc8':'\\xc3\\xa8',
           '\\xe8':'\\xc3\\xa8',
           '\\xf4':'\\xc3\\xb4',
           '\\xe0':'\\xc3\\xa0',
           }

# liste des variables creole donnant l'adresse d'un portail etablissement sur Scribe/Amonecole
var_portail = ['web_url', 'posh_url', 'scribe_envole_url', 'cas_domainname']
mod_portail = ['scribe', 'amonecole']

# temps entre chaque vérification des timeout (secondes)
SCAN_DELAY = 300
