# -*- coding: UTF-8 -*-

"""Diagnostic pour serveurs Horus
"""

import os, commands
from agent import Agent
# import des micro-agents
from zephir.monitor.agent.diagnose import ldap
from zephir.monitor.agent.diagnose import samba
from zephir.monitor.agent.diagnose import ssh
from zephir.monitor.agent.diagnose import cups
from zephir.monitor.agent.diagnose import lpd
from zephir.monitor.agent.diagnose import ead

class Diagnose_horus(Agent):
    def __init__(self):
        self.name="diagnostic"
        self.description="""Etat des services"""
        # liste des micro-agents utilisés
        self.agents = [ldap.Ldap(),samba.Samba(),cups.Cups(),lpd.Lpd(),ead.Ead(),ssh.Ssh()]
        Agent.__init__(self)
        # traitements
        self.contenu_xml,self.contenu_html = self._traitement()
        # écriture dans les fichiers
        self.write_xml()
        self.write_html()
    
    def _traitement(self):
        """traitement des micro-agents
        """
        res_xml =""
        res_html="<table>"
        # parcours des agents
        for agent in self.agents :
            res_xml += agent.contenu_xml
            res_html+= agent.contenu_html
            # un des micro-agents donne l'alerte !
            if agent.status == "0":
                self.set_status("0")             
        res_html+="</table>"
        return res_xml,res_html
        
    
if __name__ == "__main__":
    Diagnose_horus()
