# -*- coding: UTF-8 -*-

"""Diagnostic pour serveurs Scribe
"""

import os, commands
from agent import Agent
# import des micro-agents
from zephir.monitor.agent.diagnose import ldap
from zephir.monitor.agent.diagnose import samba
from zephir.monitor.agent.diagnose import ftp
from zephir.monitor.agent.diagnose import mysql
from zephir.monitor.agent.diagnose import cups
from zephir.monitor.agent.diagnose import lpd
from zephir.monitor.agent.diagnose import smtp
from zephir.monitor.agent.diagnose import imap
from zephir.monitor.agent.diagnose import pop
from zephir.monitor.agent.diagnose import webmail
from zephir.monitor.agent.diagnose import ead
from zephir.monitor.agent.diagnose import ssh

class Diagnose_scribe(Agent):
   def __init__(self):
        self.name="diagnostic"
        self.description="""Etat des services"""
        # liste des micro-agents utilisés
        self.agents = [ldap.Ldap(),samba.Samba(),ftp.Ftp(),cups.Cups(),lpd.Lpd(),smtp.Smtp(),imap.Imap(),pop.Pop(),webmail.Webmail(),ead.Ead(),ssh.Ssh(),mysql.Mysql()]
        Agent.__init__(self)
        # traitements
        self.contenu_xml,self.contenu_html = self._traitement()
        # écriture dans les fichiers
        self.write_xml()
        self.write_html()

   def _traitement(self):
        """traitement des micro-agents
        """
        res_xml =""
        res_html="<table>"
        # parcours des agents
        for agent in self.agents :
            res_xml += agent.contenu_xml
            res_html+= agent.contenu_html
            # un des micro-agents donne l'alerte !
            if agent.status == "0":
                self.set_status("0")             
        res_html+="</table>"
        return res_xml,res_html
    
if __name__ == "__main__":
    Diagnose_scribe()
