# -*- coding: UTF-8 -*-
"""Etat des montages
"""

import os,commands
from zephir.monitor.utils import list2list_to_table
from agent import Agent

class MontagesAgent(Agent):
    """Bilan de l'etat des montages
    """
    def __init__(self):
        self.name = "montages"
        self.description="""Etat des montages"""
        Agent.__init__(self)
        # traitements
        brut = self._montages()
        self.contenu_xml = list2list_to_table(brut)
        self.contenu_html = self.contenu_xml
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    def _montages(self):
        """Appel et traitement des commandes
        """
        # commandes utilisées
        cmd_montages = "df -kP"
        cmd_info = "/bin/cat /proc/mounts"
        # exécution des commandes
        mnt = commands.getoutput(cmd_montages)
        inf = commands.getoutput(cmd_info)
        # récupération des lignes
        lmnt = mnt.splitlines()
        linf = inf.splitlines()
        
        # traitement de info
        d_type = {}
        for lin in linf :
            d_type[lin.split()[0]]=lin.split()[2]
        
        # traitement mnt
        lmnt=lmnt[1:]
        liste = [['montage','partition','type','utilisation','libre (mo)','utilisé (mo)','taille (mo)']]
        for lmn in lmnt :
            l = []
            l.append(lmn.split()[5]) # montage
            l.append(lmn.split()[0]) # partition
            try :
                l.append(d_type[lmn.split()[0]]) # jointure sur le type
            except:
                l.append("?")
            l.append(lmn.split()[4]) # utilisation (%)
            l.append( int(lmn.split()[3])/1024 ) # dispo
            l.append( int(lmn.split()[2])/1024 ) # utilisé
            l.append( int(lmn.split()[1])/1024 ) # taille
            liste.append(l)
            # Alerte si une partition est remplie à plus de XX (%)
            if int(lmn.split()[4][:-1]) > 95:
                # on ignore les cdroms pour les alertes
                if lmn.count('iso9660') == 0:
                    self.set_status("0")
            
        return liste
                                                                                                               
if __name__ == "__main__":
    MontagesAgent()

