# -*- coding: UTF-8 -*-

"""Informations sur les cartes ethernet
"""
import commands
import os

from agent import Agent
from zephir.monitor.utils import list_to_table

class Reseau(Agent):
    """Infos réseau
    """
    def __init__(self):
        self.name="reseau"
        self.description="""Informations reseau (configuration des cartes ethernet)"""
        Agent.__init__(self)
        
        # traitements
        resultat = self._reseau()
        self.contenu_xml = list_to_table(resultat)
        self.contenu_html = self.contenu_xml # list_to_table(resultat)
        
        # écriture dans les fichiers
        self.write_xml()
        self.write_html()

    def _reseau(self):
        """Récupère une sortie système
        """
        exec_cmd = "/bin/cat /proc/net/dev"
        s = commands.getoutput(exec_cmd)
        lignes = s.splitlines()
        # une ligne pour chaque carte
        lignes = lignes[2:]

        d = {}
        for ligne in lignes:
            deb_ligne = ligne.split(':')[0].strip()
            fin_ligne = ligne.split(':')[1]
            champs = fin_ligne.split()
            # calcul du pourcentage d'erreur en entrée et sortie
            if float(champs[1]) != 0:
                pourc_in = (float(champs[2]) * 100) / float(champs[1])
            else:
                pourc_in = 0
                
            if float(champs[9]) != 0:
                pourc_out =(float(champs[10]) * 100) / float(champs[9])
            else:
                pourc_out = 0
                
            # transforme les octets en kilo-octets
            d[deb_ligne] = [round(float(champs[0])/1024), round(float(champs[8])/1024),round(pourc_in),round(pourc_out)]

        exec_cmd = "/sbin/ifconfig"
        s = commands.getoutput(exec_cmd)
        cartes = s.split("\n\n")
        
        for lignes in cartes:
            ligne = lignes.splitlines()[0]
            nom_carte = ligne.split()[0]
            # si c'est un alias, on ignore
            if nom_carte.count(':') == 0:
                ligne = lignes.splitlines()[1]
                adresses = ligne.strip()
                adr_carte = adresses[adresses.index(':')+1:].split()[0]
                # ajoute les informations au dictionnaire
                d[nom_carte].append(adr_carte)

        # transformation du dico de listes en liste de dicos (ah ah ah)
        l = []
        for device in d.keys():
            try:
                # Si on detecte un fort taux d'erreurs (>= 10%), on pose une alerte
                if (d[device][2] >= 10) or (d[device][3] >= 10):
                    self.set_status("0")
                    l.append({'nom':'<font color="#cc0000">'+device+'</font>','entree (ko)':d[device][0],'entree (erreurs)':d[device][2],'sortie (ko)':d[device][1],'sortie (erreurs)':d[device][3]})
                else:
                    l.append({'nom':'<font color="#00cc00">'+device+'</font>','entree (ko)':d[device][0],'entree (erreurs)':d[device][2],'sortie (ko)':d[device][1],'sortie (erreurs)':d[device][3]})

            except:
                pass
        return l


if __name__ == "__main__":
    Reseau()
