# -*- coding: UTF-8 -*-
"""Etat du serveur de fichier
"""

import os,commands
from agent import Agent

class SambaAgent(Agent):
    """Etat du serveur de fichier
    """
    def __init__(self):
        self.name = "samba"
        self.description="""Partage de fichier Samba"""
        Agent.__init__(self)
        cmd = "net status sessions | grep \"(\" |wc -l"
        nb = commands.getoutput(cmd).lstrip()
        virus = self._virus_log()
        # traitements (à restructurer si possible arf arf)
        self.contenu_xml = self._dump_xml(nb,virus)
        self.contenu_html= self._dump_html(nb,virus)
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    def _dump_xml(self,nb,virus):
        """sortie en xml
        """
        
        UPT_DATA = """<variable name="nbconnectes" value="%s"/>
                      <variable name="lastvirus" value="%s"/>
                   """

        return UPT_DATA % (nb,virus)
        
    def _dump_html(self,nb,virus):
        """sortie en html
        """
        UPT_HTM = """<table><tr><td>
        Nombres d'utilisateurs connectés : %s
        </td></tr><tr><td>
        Dernier virus détecté : %s
        </td></tr></table>
        """
        
        return UPT_HTM % (nb,virus)


    def _virus_log(self):
        """ traitement des virus
        loggés dans syslog avec samba-vscan
        """
        fichier = "/var/log/syslog"
        try :
            fp = open(fichier,'r')
        except:
             return("Erreur de lecture")
        lignes = fp.readlines()
        lignes.reverse()
        for ligne in lignes:
            if ligne.find("infected with virus") != -1 :
                ## mois (ang) et jour (num)
                date = ligne[4:6]+" "+ligne[0:3]
                ligne = ligne[ligne.find("'")+1:]
                next = ligne.find("'")
                ## fichier
                fichier = ligne[0:next]
                ligne = ligne[next+23:]
                next = ligne.find("'")
                ## virus
                virus = ligne[0:next]
                ## client
                client = ligne[next+12:-2]
                return("<font color=red>"+virus+"</font> sur le client"+" "+client+" ("+date+")")
                
        return("Aucun")           
                
if __name__ == "__main__":
    SambaAgent()

