# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# utils.py
#  
# Utilitaires divers (deprecated)
#       
###########################################################################
import time

# manipulation de fichiers

def readfile(filename):
    """Lit un fichier et le met dans une variable
    """
    try:
        fh = file(filename, "r")
        s = fh.read()
        fh.close()
        return s
    except:
        raise Exception, "Impossible de lire un fichier"
    
def createfile(long_filename, string):
    """Créee un fichier avec le contenu de la string
    """
    try:
        fh = file(long_filename, "w")
        fh.write(string)
        fh.close()
    except:
        raise Exception, "Impossible d'ecrire dans un fichier"

# 
# mapping types de base python -> formatage html
#

def _dict_to_table_row(d):
    """Mapping
    dictionnaire python -> logidee table row

    exemple
    -------

    {'libelle': 'horus', 'id': 13}

    devient : 

    <row><col>horus</col><col>13</col></row>
    """
    l = []
    l.append("<tr>")
    for s in d.values():
        l.append( "<td>%s</td>" % str(s) )
    l.append("</tr>")
    return "".join(l)

def _list_to_table_row(ligne):
    """génération d'une ligne de tableau
      à partir d'une liste"""
    l = []
    l.append("<tr>")
    for s in ligne :
        l.append( "<td>%s</td>" % str(s) )
    l.append("</tr>")
    return "".join(l)
    
def _dict_to_table_head(d):
    """Mapping
    dictionnaire python -> table head
    """
    l = []
    l.append("<tr>")
    for s in d.keys():
        l.append( "<td>%s</td>" % s )
    l.append("</tr>")    
    return "".join(l)

def list_to_table(list_dict):
    """Mapping
    liste de dictionnaires python -> html table
    """
    l = ["<table>"]
    # renseigne l'en-tête de la table
    l.append(_dict_to_table_head(list_dict[0]))
    # remplis le tableau
    for d in list_dict:
        l.append(_dict_to_table_row(d))
    l.append("</table>")        
    return "".join(l)
    
def list2list_to_table(list2list):
    """Mapping
    liste de listes python -> html table
    """
    l = ["<table>"]
    # parcours de la liste
    for ligne in list2list:
        l.append(_list_to_table_row(ligne))
    l.append("</table>")        
    return "".join(l)
    
def dict_to_list(dict):
    """Mapping
    dictionnaire python -> liste logidee
    """
    l=[]
    l.append("<ul>")
    for em,item in dict.items():
        l.append("<li><em> %s </em> : %s </li>" % (em, item) )
    l.append("</ul>")
    return "".join(l)

def list_to_list(list, id):
    """Mapping
    liste python -> liste hmtl
    """
    l = []
    l.append("""<ul id="%s">""" % id)
    for item in list :
        l.append("<li> %s </li>" % item )
    l.append("</ul>")

    return "".join(l)

