# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# index.py
#
# page principale de l'application web Zephir
#
###########################################################################
from twisted.web.resource import Resource
from twisted.web import static
from zephir.web.config import Navigation, PATH_TEMP

from zephir.web.html.erreur import *

from zephir.web.template.design import Design, proxy, get_user
from zephir.web.html import etabs, utilisateurs, modules, serveurs, services, dicos
from os.path import isfile, join
from zephir.eolerpclib import xmlrpclib

class Index(Design):

    def getChild(self, name, request):

        entites = {
            # etablissements
            'etab':etabs.Etab(),
            # utilisateurs
            'administration':utilisateurs.Admin(),
            'preferences':utilisateurs.Preferences(),
            'logout':utilisateurs.Logout(),
            # modules
            'module':modules.Module(),
            # serveurs
            'serveur':serveurs.Serveur(),
            # services
            'services':services.Services(),
            # identifiants ent
            'aff_ent':utilisateurs.AffCodeEnt(),
            # gestion des dictionnaires
           'dicos':dicos.PoolDicos(),
        }

        if static.isDangerous(name):
            return static.dangerousPathError
        if name in entites.keys():
            return entites[name]
        return self

    def wmfactory_menu(self, request):
        return Navigation(aide="index.html").menu()

    def wmfactory_title(self,request):
        return "Bienvenue sur l'application web Zéphir"

    def formulaire(self, request, groups, user_groups, plages_ent):
        """ affiche les groupes de serveurs surveillés par l'utilisateur
        """

        # conversion de la liste des groupes de l'utilisateur
        l = ["""<center><table border="0" cellspacing="0" cellpadding="30" align='center' valign='middle' width='100%'><!--contenu2--><tr><td align=center>"""]
        l.append("""<table id="tab_accueil"><tr><td class="td_titre" colspan="3" align="center">Liste des groupes en surveillance</td></tr>""")

        groups.sort(key=lambda x:x[1].lower())
        if user_groups == []:
            l.append("""<tr><td colspan="3" align="center">Aucun groupe selectionné</td></tr>""")
        else:
            for groupe in groups:
                if groupe[0] in user_groups:
                    string = """<tr><td><a href="/serveur/aff_groupe?id_groupe=%s">%s</a></td><td align="center"><a href="/serveur/detail_groupe?id=%s"><i>modifier</i></a></td><td>%d serveurs</td></tr>""" % (str(groupe[0]), groupe[1], str(groupe[0]), len(groupe[2]))
                    l.append(string)

        alertes = backend(proxy(request).serveurs.get_alertes())
        stats = backend(proxy(request).get_stats())
        if len(alertes) > 0:
            alertes = """<a href="/serveur/aff_alertes">Serveurs en alerte</a></td><td align="center"><font color="red">%s</font>""" % len(alertes)
        else:
            alertes = """<a href="/serveur/aff_alertes">Aucun serveur en alerte</a>"""
        l.append("""<tr><td colspan="3" align="center" class="td_titre">Statistiques générales</td></tr>""")
        if stats.get('load_percent',''):
            l.append("""<tr><td colspan="2" align="center"><font color="orange">Mise en cache des configurations</font></td><td align="center">%s %%</td></tr>""" % stats['load_percent'])
        l.append("""<tr><td colspan="2" align="center">Nombre total de serveurs</td><td align="center">%s</td></tr>""" % stats['nb_serv'])
        l.append("""<tr><td colspan="2" align="center">Serveurs non enregistrés</td><td align="center">%s</td></tr>""" % len(stats['no_contact']))
        l.append("""<tr><td colspan="2" align="center">%s</td></tr>""" % alertes)
        l.append("""<tr><td colspan="3" align="center"><a href="/serveur/aff_migration">Suivi de la migration</a></td></tr>""")
        # gestion des identifiants ent si disponible
        if plages_ent:
            l.append("""<tr><td colspan="3" align="center"><a href="/aff_ent">gestion des identifiants ENT</a></td></tr>""")
        l.append("""</table></td></tr>""")
        l.append("""</table><!--fin:contenu2-->""")

        return "".join(l)

    def wmfactory_content(self, request):
        string = "<h1>Zéphir Web - Accueil</h1>"
        # + Navigation().render()
        string = """<center><h1>Bienvenue !</h1>Vous êtes connecté en tant que : %s
        <SCRIPT LANGUAGE="JavaScript">
        <!--
        function clear() {
                location.reload(false)
                }
        setTimeout ("clear()", 60000);
        // -->
        </SCRIPT>
        <form id="form_pref" method="POST" action="/preferences"><input type="submit" value="Vos préférences"></form></center>""" % get_user(request)
        # lien sur les groupes surveillés par l'utilisateur
        # session dans self.prefs
        self.prefs=request.getSession()
        # on récupère l'utilisateur courant
        user = get_user(request)
        # calcul de la page
        groups=[]
        info_user=[]
        try:
            groups = backend(proxy(request).serveurs.get_groups())
            info_user = backend(proxy(request).get_user(u(user)))[8]
        except Exception, e:
            pass
        try:
            # vérification des permissions d'accès aux fonctions ENT
            assert 12 in backend(proxy(request).get_permissions(u(user)))
            plages_ent = backend(proxy(request).entid.get_code_ent(), False)
        except:
            plages_ent = []
        try:
            string += self.formulaire(request, groups, info_user, plages_ent)
        except xmlrpclib.ProtocolError:
            string = """Vous n'êtes pas autorisé à effectuer cette action"""
        except Exception, e:
            string = "erreur frontend : %s" % str(e)

        rapport_file = join(PATH_TEMP,"rapport.pdf")
        rapport_url = join("/tmp","rapport.pdf")
        rapport = """<p><a href="javascript:void(window.open('/aide/howto/index.html','rapport', 'scrollbars=yes, resizable=yes, location=no, directories=no, status=no'))">Tutoriel Zéphir</a><br/>"""

        if isfile(rapport_file):
            rapport += """
            </p><p><a href="javascript:void(window.open('%s','rapport', 'scrollbars=yes, resizable=yes, location=no, directories=no, status=no'))">Récupérer le rapport complet <img border="0" src="/images/pdf.png"></a> (<a href="/etab/gen_rapport">actualiser</a>)
            </p>
            """ % rapport_url

        else :
            rapport += """
            </p><p><a href=etab/gen_rapport>Générer le rapport complet <img border="0" src="/images/pdf.png"></a><br>(cette action peut prendre du temps)</p>
            """
        return string + rapport

