#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# import_modules.py
#  
# script d'insertion des données par défaut dans la base de données
# (types établissement et modules par défaut)
#       
###########################################################################

# insertion des types d'établissement
from zephir.lib_zephir import *
import httplib, socket
import xmlrpclib, getpass, os, sys
from zephir.config import *
from creole import utils

help = """
    %s <option>

--help/-h : affiche ce message
--check/-c : affiche des statistiques sur la prise en compte de l'adresse par les clients
--purge/-p : annule les demandes de changement d'adresse auprès des clients
pas d'option : envoie au client une nouvelle adresse de zephir à prendre en compte
""" % sys.argv[0]

if '--help' in sys.argv or '-h' in sys.argv:
    print help
    sys.exit(0)
if '--check' in sys.argv or '-c' in sys.argv:
    mode = "check"
elif '--purge' in sys.argv or '-p' in sys.argv:
    mode = "purge"
else:
    mode = "prepare"

login_ok = 0
print ""
while login_ok == 0:
    user = raw_input("Entrez votre login zephir (rien pour sortir) : ")
    if user != "":
        password = getpass.getpass("Mot de passe zephir pour %s : " % user)
        zephir_proxy = EoleProxy("https://"+user+":"+password+"@"+ADRESSE_ZEPHIR+":"+PORT_ZEPHIR,transport=TransportEole())
        login_ok = 1
        try:
            res=convert(zephir_proxy.get_permissions(user))
        except xmlrpclib.ProtocolError:
            login_ok = 0
            print "\n Erreur d'authentification \n"
        except socket.error:
            sys.exit("\nImpossible de se connecter à %s\n" % adresse_zephir)
    else:
        sys.exit("! abandon de la procédure !")
# initialisation des données
id_servs = []
waiting_servs = []
# récupération des serveurs (NG seulement pour l'instant)
code, modules = convert(zephir_proxy.modules.get_module())
mod_ng = []
for mod in modules:
    if mod['version'] >= 2:
        mod_ng.append(mod['id'])

code, serveurs = convert(zephir_proxy.serveurs.get_serveur())
for serv in serveurs:
    if serv['module_actuel'] in mod_ng:
        id_servs.append(serv['id'])

# état actuel des serveurs
if mode in ('check', 'purge'):
    # mode check : vérification de l'état des serveurs
    ip_status = {0:[],1:[],2:[],3:[]}
    print ""
    for serv in id_servs:
        try:
            code, status = convert(zephir_proxy.serveurs.get_status(serv))
            assert code == 1
        except:
            utils.print_rouge("erreur de récupération du status du serveur %d" % serv)
            continue
        if status.has_key('new_key'):
            ip_status[status['new_key'][0]].append(str(serv))
            if status['new_key'][0] in (2,3):
                waiting_servs.append(serv)
        else:
            ip_status[0].append(str(serv))

if mode == 'check':
    # affichage des statistiques
    print "\nStatistiques de suivi\n"
    if len(ip_status[2]) != 0:
        print " - Serveurs en attente de récupération de l'adresse :\n"
        utils.print_orange("\t%s" % ", ".join(ip_status[2]))
        print ""
    if len(ip_status[0]) != 0:
        print " - Serveurs non préparés :\n"
        utils.print_red("\t%s" % ", ".join(ip_status[0]))
        print ""
    if len(ip_status[3]) != 0:
        print " - Nombre de serveurs ayant récupéré l'adresse : %d\n" % len(ip_status[3])

if mode == 'prepare':
    # demande de la nouvelle adresse ip
    new_addr = ""
    while new_addr == "":
        new_addr = raw_input("\nEntrez la nouvelle adresse du serveur zephir : ")
    # envoi de l'adresse aux serveurs
    sent = 0
    errs = []
    print "\nEnvoi de l'adresse aux serveurs ...\n"
    for serv in id_servs:
        try:
            code, resp = convert(zephir_proxy.serveurs.regen_key(serv, False, new_addr))
            assert code == 1 and resp == []
        except:
            errs.append(str(serv))
            continue
        sent += 1
    print "L'adresse a été définie pour %d serveurs\n" % sent
    if errs != []:
        print "Adresse non envoyée aux serveurs suivants :\n"
        utils.print_orange("\t%s" % ", ".join(errs))
        print ""

if mode == 'purge':
    utils.print_red("""Attention, toutes les demandes de prise en compte
d'une nouvelle adresse de zephir vont être annulées
""")
    confirm = raw_input('Purger les demandes (O/N) ? ')
    if not confirm.upper() in ['OUI','O']:
        sys.exit("! abandon de la procédure de purge!")
    print "\npurge en cours sur les  serveurs..."
    code, resp = convert(zephir_proxy.serveurs.purge_key(waiting_servs))
    if resp != []:
        print "Erreur de purge sur les clients suivants : " , resp
    print ""
