/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SosaParser {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private BigInteger sosa;
    private String daboville;
    private Integer generation;

    public SosaParser(String sosaString) {
        this.parseSosa(sosaString);
    }

    private void parseSosa(String sosaString) {
        String[] espace = sosaString.split(" ");
        if (espace.length == 2) {
            this.generation = Integer.valueOf(espace[1].substring(1));
        }
        if (espace[0] != null && !"".equals(espace[0])) {
            int premierPoint = espace[0].indexOf(45);
            if (premierPoint > 0) {
                this.sosa = new BigInteger(espace[0].substring(0, premierPoint));
                this.daboville = "1" + espace[0].substring(premierPoint);
            } else {
                try {
                    this.sosa = new BigInteger(espace[0]);
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.FINER, "Not a Sosa number (for the records) :", e);
                    this.daboville = espace[0];
                }
            }
        }
    }

    public BigInteger getSosa() {
        return this.sosa;
    }

    public String getDaboville() {
        return this.daboville;
    }

    public Integer getGeneration() {
        return this.generation;
    }
}

