/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing.svg;

import ancestris.util.swing.svg.AncestrisResourcesPolicy;
import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.DocumentLimits;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.ResourcePolicy;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JPanel;

public class SvgDisplay
extends JPanel {
    private SVGDocument svgdocument;
    private double scale = 1.0;
    private FloatSize size;

    public SvgDisplay(File file) {
        this.setFile(file);
        if (this.svgdocument != null) {
            this.size = this.svgdocument.size();
        }
        this.setBackground(Color.WHITE);
    }

    public final void setFile(File file) {
        SVGDocument doc;
        try {
            SVGLoader loader = new SVGLoader();
            DocumentLimits dl = new DocumentLimits(30, 45, 200000);
            doc = loader.load(file.toURI().toURL(), LoaderContext.builder().documentLimits(dl).externalResourcePolicy((ResourcePolicy)new AncestrisResourcesPolicy()).build());
        }
        catch (MalformedURLException e) {
            doc = null;
        }
        this.svgdocument = doc;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.size != null) {
            return new Dimension((int)(this.size.getWidth() * this.scale), (int)(this.size.getHeight() * this.scale));
        }
        return new Dimension(100, 100);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.svgdocument != null) {
            this.svgdocument.render((Component)this, (Graphics2D)g, new ViewBox(0.0f, 0.0f, (float)((int)(this.size.getWidth() * this.scale)), (float)((int)(this.size.getHeight() * this.scale))));
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.setPreferredSize(this.getPreferredSize());
    }

    public BufferedImage getImageDefaultSize() {
        BufferedImage image = new BufferedImage((int)this.size.getWidth(), (int)this.size.getHeight(), 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.svgdocument.render(null, graphics);
        graphics.dispose();
        return image;
    }
}

