/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class GridBagHelper {
    public static final int FILL_HORIZONTAL = 1;
    public static final int FILL_VERTICAL = 2;
    public static final int FILL_BOTH = 4;
    public static final int GROW_HORIZONTAL = 16;
    public static final int GROW_VERTICAL = 32;
    public static final int GROW_BOTH = 64;
    public static final int GROWFILL_HORIZONTAL = 17;
    public static final int GROWFILL_VERTICAL = 34;
    public static final int GROWFILL_BOTH = 68;
    private final GridBagLayout layout;
    private final GridBagConstraints constraints;
    private final Container container;
    private Insets presetInsets = new Insets(0, 0, 0, 0);
    private int presetParameter = 0;
    private int presetAnchor = 10;

    public GridBagHelper(Container container) {
        this.container = container;
        this.layout = new GridBagLayout();
        container.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
    }

    public GridBagHelper setInsets(Insets set) {
        this.presetInsets = set;
        return this;
    }

    public GridBagHelper setParameter(int set) {
        this.presetParameter = set;
        return this;
    }

    public GridBagHelper setAnchor(int set) {
        if (set < 0) {
            set = 10;
        }
        this.presetAnchor = set;
        return this;
    }

    public Component add(Component component, int x, int y) {
        return this.add(component, x, y, 1, 1);
    }

    public Component add(Component component, int x, int y, int w, int h) {
        return this.add(component, x, y, w, h, this.presetParameter);
    }

    public Component add(Component component, int x, int y, int w, int h, int parm) {
        return this.add(component, x, y, w, h, parm, this.presetInsets);
    }

    public Component add(Component component, int x, int y, int w, int h, int parm, Insets insets) {
        this.container.add(component);
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.constraints.gridwidth = w;
        this.constraints.gridheight = h;
        this.constraints.weightx = this.isSet(parm, 64) || this.isSet(parm, 16) ? 1.0 : 0.0;
        this.constraints.weighty = this.isSet(parm, 64) || this.isSet(parm, 32) ? 1.0 : 0.0;
        this.constraints.fill = 0;
        this.constraints.insets = insets;
        if (this.isSet(parm, 4) || this.isSet(parm, 1) && this.isSet(parm, 2)) {
            this.constraints.fill = 1;
        } else if (this.isSet(parm, 1)) {
            this.constraints.fill = 2;
        } else if (this.isSet(parm, 2)) {
            this.constraints.fill = 3;
        }
        this.constraints.anchor = this.presetAnchor;
        this.layout.setConstraints(component, this.constraints);
        return component;
    }

    public void addFiller(int x, int y) {
        this.add(new Fill(new Dimension(0, 0)), x, y, 1, 1, 64);
    }

    public void addFillerH(int x, int y) {
        this.add(new Fill(new Dimension(0, 0)), x, y, 1, 1, 16);
    }

    public void addFiller(int x, int y, Dimension dim) {
        this.add(new Fill(dim), x, y, 1, 1);
    }

    private boolean isSet(int value, int mask) {
        return (value & mask) != 0;
    }

    private class Fill
    extends Component {
        Dimension size;

        Fill(Dimension size) {
            this.size = size;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }
    }
}

