/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SafeProxy {
    public static <T> T unwrap(T object) {
        try {
            return ((SafeHandler)Proxy.getInvocationHandler(object)).impl;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("not wrapped");
        }
    }

    public static <T> T harden(T implementation) {
        return SafeProxy.harden(implementation, Logger.getAnonymousLogger());
    }

    public static <T> List<T> harden(List<T> ts, Logger logger) {
        ListIterator<T> li = ts.listIterator();
        while (li.hasNext()) {
            li.set(SafeProxy.harden(li.next(), logger));
        }
        return ts;
    }

    public static <T> T harden(T implementation, Logger logger) {
        if (logger == null || implementation == null) {
            throw new IllegalArgumentException("implementation|logger==null");
        }
        ArrayList interfaces = new ArrayList();
        for (Class<?> c = implementation.getClass(); c != null; c = c.getSuperclass()) {
            for (Class<?> i : c.getInterfaces()) {
                if (!Modifier.isPublic(i.getModifiers()) || interfaces.contains(i)) continue;
                interfaces.add(i);
            }
        }
        return (T)Proxy.newProxyInstance(implementation.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), new SafeHandler<T>(implementation, logger));
    }

    private static class SafeHandler<T>
    implements InvocationHandler {
        private T impl;
        private Logger logger;

        private SafeHandler(T impl, Logger logger) {
            this.impl = impl;
            this.logger = logger;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Throwable t;
            if ("equals".equals(method.getName()) && args.length == 1) {
                try {
                    return this.impl.equals(((SafeHandler)Proxy.getInvocationHandler((Object)args[0])).impl);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            try {
                return method.invoke(this.impl, args);
            }
            catch (InvocationTargetException ite) {
                t = ite.getCause();
            }
            catch (Throwable tt) {
                t = tt;
            }
            this.logger.log(Level.WARNING, "Implementation " + this.impl.getClass().getName() + "." + method.getName() + " threw exception " + t.getClass().getName() + "(" + t.getMessage() + ")", t);
            return null;
        }
    }
}

