/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo.renderer;

import ancestris.modules.geo.GeoMapTopComponent;
import ancestris.modules.geo.GeoPoint;
import ancestris.modules.geo.renderer.AncestrisWaypointRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.Waypoint;

public class NameWaypointRenderer
extends AncestrisWaypointRenderer {
    public NameWaypointRenderer(int size, Color couleur, GeoMapTopComponent theGtmc) {
        super(size, couleur, theGtmc);
    }

    public NameWaypointRenderer() {
    }

    public void paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
        Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
        int x = Long.valueOf(Math.round(point.getX())).intValue();
        int y = Long.valueOf(Math.round(point.getY())).intValue();
        double coex = (double)this.markersSize / 10.0;
        String name = ((GeoPoint)wp).getGeoNodeObject().getCity();
        g.setFont(new Font("Dialog", 0, (int)(12.0 * coex)));
        double width = (int)g.getFontMetrics().getStringBounds(name, g).getWidth();
        Color currentColor = this.adjustGenerationColor(wp);
        g.setPaint(currentColor);
        Polygon triangle = new Polygon();
        triangle.addPoint(x, y);
        triangle.addPoint(x + (int)(7.0 * coex), y + (int)(-11.0 * coex));
        triangle.addPoint(x + (int)(-7.0 * coex), y + (int)(-11.0 * coex));
        g.fill(triangle);
        GradientPaint colortowhite = new GradientPaint(x + (int)(-width / 2.0 - 5.0), y - 4 * this.markersSize, currentColor, x + (int)(-width / 2.0 - 5.0), y - 2 * this.markersSize, Color.WHITE, true);
        g.setPaint(colortowhite);
        g.fillRoundRect(x + (int)(-width / 2.0 - 5.0), y - 3 * this.markersSize, (int)(width + 10.0), 2 * this.markersSize, 10, 10);
        g.setPaint(currentColor);
        g.drawString(name, x + (int)(-width / 2.0), y + (int)(-16.0 * coex));
    }
}

