/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.marking;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.document.view.DocumentViewTopComponent;
import ancestris.modules.gedcom.marking.MarkingPanel;
import ancestris.modules.gedcom.marking.MarkingTask;
import ancestris.modules.gedcom.marking.MarkingTaskFactory;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.SelectEntityPanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.util.Trackable;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import spin.Spin;

public final class MarkingAction
extends AbstractAncestrisContextAction {
    private Gedcom gedcom = null;

    public MarkingAction() {
        this.setIconBase("ancestris/modules/gedcom/marking/MarkingIcon.png");
        this.setText(NbBundle.getMessage(MarkingAction.class, (String)"CTL_MarkingAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        this.gedcom = contextToOpen.getGedcom();
        MarkingPanel markingPanel = new MarkingPanel(this.getContext());
        Object choice = DialogManager.create((String)NbBundle.getMessage(MarkingAction.class, (String)"MarkingAction.AskParams"), (JComponent)markingPanel).setMessageType(3).setOptionType(2).setDialogId("markingPanel").show();
        if (choice == DialogManager.OK_OPTION) {
            markingPanel.savePreferences();
            Indi indiDeCujus = null;
            if (markingPanel.getSettings().isTreeTop || markingPanel.getSettings().isTreeBottom) {
                Entity entity = contextToOpen.getEntity();
                if (entity instanceof Indi) {
                    indiDeCujus = (Indi)entity;
                } else {
                    SelectEntityPanel select = new SelectEntityPanel(this.gedcom, "INDI", NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MarkingAction.AskIndividual"), contextToOpen.getEntity());
                    if (DialogManager.OK_OPTION != DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_MarkingAction"), (JComponent)select).setMessageType(3).setOptionType(2).setDialogId("markingPanelIndi").show()) {
                        return;
                    }
                    indiDeCujus = (Indi)select.getSelection();
                }
                if (indiDeCujus == null) {
                    return;
                }
            }
            DocumentViewTopComponent.findInstance().close();
            MarkingTask task = (MarkingTask)Spin.off((Object)MarkingTaskFactory.create(contextToOpen, indiDeCujus, markingPanel.getSettings()));
            ProgressListener.Dispatcher.processStarted((Trackable)task);
            this.commit(task);
            ProgressListener.Dispatcher.processStopped((Trackable)task);
        }
    }

    private void commit(Runnable task) {
        block5: {
            try {
                if (this.gedcom.isWriteLocked()) {
                    task.run();
                    break block5;
                }
                this.gedcom.doUnitOfWork(localGedcom -> task.run());
            }
            catch (GedcomException ge) {
                Exceptions.printStackTrace((Throwable)ge);
            }
        }
    }
}

