/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.RelevePanel;
import ancestris.modules.releve.merge.MergeQuery;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldDate;
import ancestris.modules.releve.model.GedcomLink;
import ancestris.modules.releve.model.RecordModel;
import ancestris.modules.releve.utils.CompareString;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GedcomLinkProvider {
    private final HashMap<AbstractRecord, GedcomLink> gedcomLinkList = new HashMap();
    private Gedcom gedcom = null;
    private boolean showGedcomLink = false;
    private static final TagPath marrDateTag = new TagPath("FAM:MARR:DATE");
    private static final TagPath marbDateTag = new TagPath("FAM:MARB:DATE");
    private static final TagPath marcDateTag = new TagPath("FAM:MARC:DATE");
    private static final TagPath marlDateTag = new TagPath("FAM:MARL:DATE");
    private static final TagPath evenDateTag = new TagPath("FAM:EVEN:DATE");
    private static final TagPath indiEvenDateTag = new TagPath("INDI:EVEN:DATE");
    private static final TagPath willDateTag = new TagPath("INDI:WILL:DATE");
    private final Set<String> miscIndiTagPathList = new HashSet<String>();
    private final Set<String> miscFamTagPathList = new HashSet<String>();

    public void init(RecordModel recordModel, Gedcom gedcom, boolean showGedcomLink, boolean quiet) {
        this.gedcom = gedcom;
        this.showGedcomLink = showGedcomLink;
        ArrayList<RecordEntry> recordBirth = new ArrayList<RecordEntry>();
        ArrayList<RecordEntry> recordDeath = new ArrayList<RecordEntry>();
        ArrayList<RecordEntry> recordMarriage = new ArrayList<RecordEntry>();
        ArrayList<RecordEntry> recordMisc = new ArrayList<RecordEntry>();
        ArrayList<IndiEntry> indiBirth = new ArrayList<IndiEntry>();
        ArrayList<IndiEntry> indiDeath = new ArrayList<IndiEntry>();
        ArrayList<IndiEntry> indiMisc = new ArrayList<IndiEntry>();
        ArrayList<FamEntry> famMarriage = new ArrayList<FamEntry>();
        ArrayList<FamEntry> famMisc = new ArrayList<FamEntry>();
        if (gedcom != null && showGedcomLink) {
            int rwoCount = recordModel.getRowCount();
            for (int i = 0; i < rwoCount; ++i) {
                AbstractRecord record = recordModel.getRecord(i);
                this.createRecordList(record, recordBirth, recordDeath, recordMarriage, recordMisc);
            }
            this.createIndiList(indiBirth, indiDeath, indiMisc);
            this.createFamList(famMarriage, famMisc);
            this.gedcomLinkList.clear();
            this.compareList(recordBirth, indiBirth);
            this.compareList(recordDeath, indiDeath);
            this.compareListMarriage(recordMarriage, famMarriage);
            this.compareList(recordMisc, indiMisc);
            this.compareListMarriage(recordMisc, famMisc);
            if (recordModel.getRowCount() > 0) {
                recordModel.fireRecordModelUpdated(0, recordModel.getRowCount() - 1);
            }
            if (!quiet && this.gedcomLinkList.isEmpty()) {
                JOptionPane.showConfirmDialog(null, NbBundle.getMessage(RelevePanel.class, (String)"GedcomLinkProvider.HighlightNone"), NbBundle.getMessage(RelevePanel.class, (String)"GedcomLinkProvider.title"), -1);
            }
        } else {
            if (!quiet && showGedcomLink) {
                JOptionPane.showConfirmDialog(null, NbBundle.getMessage(RelevePanel.class, (String)"GedcomLinkProvider.HighlightNeedGedcom"), NbBundle.getMessage(RelevePanel.class, (String)"GedcomLinkProvider.title"), -1);
            }
            this.gedcomLinkList.clear();
            if (recordModel.getRowCount() > 0) {
                recordModel.fireRecordModelUpdated(0, recordModel.getRowCount() - 1);
            }
        }
    }

    public void addRecord(AbstractRecord record) {
        ArrayList<RecordEntry> recordBirth = new ArrayList<RecordEntry>();
        ArrayList<RecordEntry> recordDeath = new ArrayList<RecordEntry>();
        ArrayList<RecordEntry> recordMisc = new ArrayList<RecordEntry>();
        ArrayList<RecordEntry> recordMarriage = new ArrayList<RecordEntry>();
        ArrayList<IndiEntry> indiBirth = new ArrayList<IndiEntry>();
        ArrayList<IndiEntry> indiDeath = new ArrayList<IndiEntry>();
        ArrayList<IndiEntry> indiMisc = new ArrayList<IndiEntry>();
        ArrayList<FamEntry> famMarriage = new ArrayList<FamEntry>();
        ArrayList<FamEntry> famMisc = new ArrayList<FamEntry>();
        if (record != null && this.gedcom != null && this.showGedcomLink) {
            switch (record.getType()) {
                case BIRTH: {
                    this.createRecordList(record, recordBirth, recordDeath, recordMarriage, recordMisc);
                    this.createIndiList(indiBirth, indiDeath, indiMisc);
                    this.compareList(recordBirth, indiBirth);
                    break;
                }
                case MARRIAGE: {
                    this.createRecordList(record, recordBirth, recordDeath, recordMarriage, recordMisc);
                    this.createIndiList(indiBirth, indiDeath, indiMisc);
                    this.createFamList(famMarriage, famMisc);
                    this.compareListMarriage(recordMarriage, famMarriage);
                    break;
                }
                case DEATH: {
                    this.createRecordList(record, recordBirth, recordDeath, recordMarriage, recordMisc);
                    this.createIndiList(indiBirth, indiDeath, indiMisc);
                    this.compareList(recordDeath, indiDeath);
                    break;
                }
                default: {
                    this.createRecordList(record, recordBirth, recordDeath, recordMarriage, recordMisc);
                    this.createIndiList(indiBirth, indiDeath, indiMisc);
                    this.createFamList(famMarriage, famMisc);
                    this.compareList(recordMisc, indiMisc);
                    this.compareListMarriage(recordMisc, famMisc);
                }
            }
        }
    }

    private void createRecordList(AbstractRecord record, ArrayList<RecordEntry> recordBirth, ArrayList<RecordEntry> recordDeath, ArrayList<RecordEntry> recordMarriage, ArrayList<RecordEntry> recordMisc) {
        try {
            switch (record.getType()) {
                case BIRTH: {
                    Field recordDate = record.getField(AbstractRecord.FieldType.indiBirthDate);
                    if (recordDate == null || recordDate.isEmpty()) {
                        recordDate = record.getField(AbstractRecord.FieldType.eventDate);
                    }
                    if (recordDate == null || recordDate.isEmpty()) break;
                    int julian = ((FieldDate)recordDate).getPropertyDate().getStart().getJulianDay();
                    recordBirth.add(new RecordEntry(julian, record));
                    break;
                }
                case MARRIAGE: {
                    Field recordDate = record.getField(AbstractRecord.FieldType.eventDate);
                    if (recordDate == null || recordDate.isEmpty()) break;
                    int julian = ((FieldDate)recordDate).getPropertyDate().getStart().getJulianDay();
                    recordMarriage.add(new RecordEntry(julian, record));
                    break;
                }
                case DEATH: {
                    Field recordDate = record.getField(AbstractRecord.FieldType.eventDate);
                    if (recordDate == null || recordDate.isEmpty()) break;
                    int julian = ((FieldDate)recordDate).getPropertyDate().getStart().getJulianDay();
                    recordDeath.add(new RecordEntry(julian, record));
                    break;
                }
                case MISC: {
                    Field recordDate = record.getField(AbstractRecord.FieldType.secondDate);
                    if (recordDate == null || recordDate.isEmpty()) {
                        recordDate = record.getField(AbstractRecord.FieldType.eventDate);
                    }
                    if (recordDate != null && !recordDate.isEmpty()) {
                        int julian = ((FieldDate)recordDate).getPropertyDate().getStart().getJulianDay();
                        recordMisc.add(new RecordEntry(julian, record));
                    }
                    Field recordTag = record.getField(AbstractRecord.FieldType.eventTag);
                    String tag = recordTag.getValue();
                    this.miscIndiTagPathList.add("INDI:" + tag + ":DATE");
                    this.miscFamTagPathList.add("FAM:" + tag + ":DATE");
                }
            }
            Collections.sort(recordBirth);
            Collections.sort(recordDeath);
            Collections.sort(recordMarriage);
            Collections.sort(recordMisc);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void createIndiList(ArrayList<IndiEntry> indiBirth, ArrayList<IndiEntry> indiDeath, ArrayList<IndiEntry> indiMisc) {
        if (this.gedcom != null && this.showGedcomLink) {
            for (Indi indi : this.gedcom.getIndis()) {
                PropertyDate deathDate;
                PropertyDate birthDate = indi.getBirthDate();
                if (birthDate != null) {
                    try {
                        indiBirth.add(new IndiEntry(birthDate.getStart().getJulianDay(), indi, (Property)birthDate));
                    }
                    catch (GedcomException gedcomException) {
                        // empty catch block
                    }
                }
                if ((deathDate = indi.getDeathDate()) != null) {
                    try {
                        indiDeath.add(new IndiEntry(deathDate.getStart().getJulianDay(), indi, (Property)deathDate));
                    }
                    catch (GedcomException gedcomException) {
                        // empty catch block
                    }
                }
                for (String tag : this.miscIndiTagPathList) {
                    TagPath tagPath = new TagPath(tag);
                    for (Property indiEventDate : indi.getProperties(tagPath)) {
                        try {
                            indiMisc.add(new IndiEntry(((PropertyDate)indiEventDate).getStart().getJulianDay(), indi, indiEventDate));
                        }
                        catch (GedcomException gedcomException) {
                            // empty catch block
                        }
                    }
                }
            }
            Collections.sort(indiBirth);
            Collections.sort(indiDeath);
            Collections.sort(indiMisc);
        }
    }

    private void createFamList(ArrayList<FamEntry> famMarriage, ArrayList<FamEntry> famMisc) {
        if (this.gedcom != null && this.showGedcomLink) {
            for (Fam fam : this.gedcom.getFamilies()) {
                for (Property marriageDate : fam.getProperties(marrDateTag)) {
                    try {
                        famMarriage.add(new FamEntry(((PropertyDate)marriageDate).getStart().getJulianDay(), fam, marriageDate));
                    }
                    catch (GedcomException gedcomException) {
                        // empty catch block
                    }
                }
                for (String tag : this.miscFamTagPathList) {
                    TagPath tagPath = new TagPath(tag);
                    for (Property eventDate : fam.getProperties(tagPath)) {
                        try {
                            famMisc.add(new FamEntry(((PropertyDate)eventDate).getStart().getJulianDay(), fam, eventDate));
                        }
                        catch (GedcomException gedcomException) {
                            // empty catch block
                        }
                    }
                }
            }
            Collections.sort(famMarriage);
            Collections.sort(famMisc);
        }
    }

    private void compareList(ArrayList<RecordEntry> recordEntries, ArrayList<IndiEntry> indiEntries) {
        int recordCount = 0;
        int recordCountMax = recordEntries.size();
        int indiCount = 0;
        int indiCountMax = indiEntries.size();
        while (indiCount < indiCountMax && recordCount < recordCountMax) {
            RecordEntry recordEntry = recordEntries.get(recordCount);
            IndiEntry indiEntry = indiEntries.get(indiCount);
            int result = recordEntries.get(recordCount).compareTo(indiEntries.get(indiCount));
            if (result == 0) {
                this.gedcomLinkList.put(recordEntry.record, new GedcomLink(recordEntry.record, (Entity)indiEntry.entity, indiEntry.property));
                ++recordCount;
                continue;
            }
            if (result > 0) {
                ++indiCount;
                continue;
            }
            ++recordCount;
        }
    }

    private void compareListMarriage(ArrayList<RecordEntry> recordEntries, ArrayList<FamEntry> famEntries) {
        int recordCount = 0;
        int recordCountMax = recordEntries.size();
        int indiCount = 0;
        int indiCountMax = famEntries.size();
        while (indiCount < indiCountMax && recordCount < recordCountMax) {
            RecordEntry recordEntry = recordEntries.get(recordCount);
            FamEntry indiEntry = famEntries.get(indiCount);
            int result = recordEntries.get(recordCount).compareTo(famEntries.get(indiCount));
            if (result == 0) {
                this.gedcomLinkList.put(recordEntry.record, new GedcomLink(recordEntry.record, (Entity)indiEntry.entity, indiEntry.property));
                ++recordCount;
                continue;
            }
            if (result > 0) {
                ++indiCount;
                continue;
            }
            ++recordCount;
        }
    }

    public GedcomLink getGedcomLink(AbstractRecord record) {
        return this.gedcomLinkList.get(record);
    }

    public void removeRecord(AbstractRecord record) {
        this.gedcomLinkList.remove(record);
    }

    public void removeAll() {
        this.gedcomLinkList.clear();
    }

    private static class RecordEntry
    implements Comparable<RecordEntry> {
        private final int julianDay;
        private final AbstractRecord record;

        public RecordEntry(int julianDay, AbstractRecord record) {
            this.julianDay = julianDay;
            this.record = record;
        }

        @Override
        public int compareTo(RecordEntry that) {
            int result = this.julianDay - that.julianDay;
            if (result == 0 && (result = CompareString.compareStringUTF8(this.record.getFieldValue(AbstractRecord.FieldType.indiLastName), that.record.getFieldValue(AbstractRecord.FieldType.indiLastName))) == 0) {
                result = CompareString.compareStringUTF8(this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName), that.record.getFieldValue(AbstractRecord.FieldType.indiFirstName));
            }
            return result;
        }

        @Override
        public int compareTo(IndiEntry indiEntry) {
            if (indiEntry.julianDay == this.julianDay) {
                Indi indi = indiEntry.entity;
                if (this.record.getField(AbstractRecord.FieldType.eventTag).getValue().equals(indiEntry.tag) && (this.record.getField(AbstractRecord.FieldType.indiSex) != null && this.record.getField(AbstractRecord.FieldType.indiSex).equalsProperty(indi.getProperty("SEX")) || this.record.getField(AbstractRecord.FieldType.indiSex) == null && indi.getSex() == 0) && !this.record.getFieldValue(AbstractRecord.FieldType.indiLastName).isEmpty() && MergeQuery.isSameLastName(this.record.getFieldValue(AbstractRecord.FieldType.indiLastName), indi.getLastName()) && !this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName).isEmpty() && MergeQuery.isSameFirstName(this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName), indi.getFirstName())) {
                    return 0;
                }
                int result = CompareString.compareStringUTF8(this.record.getFieldValue(AbstractRecord.FieldType.indiLastName), indi.getLastName());
                if (result == 0) {
                    result = CompareString.compareStringUTF8(this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName), indi.getFirstName());
                    if (result > 0) {
                        return 1;
                    }
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return -1;
            }
            return this.julianDay - indiEntry.julianDay;
        }

        @Override
        public int compareTo(FamEntry famEntry) {
            if (famEntry.julianDay == this.julianDay) {
                Indi husband = famEntry.entity.getHusband();
                Indi wife = famEntry.entity.getWife();
                if (husband == null && wife == null) {
                    return -1;
                }
                if (!this.record.getField(AbstractRecord.FieldType.eventTag).getValue().equals(famEntry.tag)) {
                    return -1;
                }
                if (husband != null && !this.record.getFieldValue(AbstractRecord.FieldType.indiLastName).isEmpty() && !this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName).isEmpty() && MergeQuery.isSameLastName(this.record.getFieldValue(AbstractRecord.FieldType.indiLastName), husband.getLastName()) && MergeQuery.isSameFirstName(this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName), husband.getFirstName()) || wife != null && !this.record.getFieldValue(AbstractRecord.FieldType.wifeLastName).isEmpty() && !this.record.getFieldValue(AbstractRecord.FieldType.wifeFirstName).isEmpty() && MergeQuery.isSameLastName(this.record.getFieldValue(AbstractRecord.FieldType.wifeLastName), wife.getLastName()) && MergeQuery.isSameFirstName(this.record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), wife.getFirstName())) {
                    return 0;
                }
                int result = CompareString.compareStringUTF8(this.record.getFieldValue(AbstractRecord.FieldType.indiLastName), husband.getLastName());
                if (result == 0) {
                    result = CompareString.compareStringUTF8(this.record.getFieldValue(AbstractRecord.FieldType.indiFirstName), husband.getFirstName());
                    if (result > 0) {
                        return 1;
                    }
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return -1;
            }
            return this.julianDay - famEntry.julianDay;
        }
    }

    private static class IndiEntry
    implements Comparable<IndiEntry> {
        private final int julianDay;
        private final Indi entity;
        private final Property property;
        private final String tag;

        public IndiEntry(int julianDay, Indi entity, Property property) {
            this.julianDay = julianDay;
            this.entity = entity;
            this.property = property;
            this.tag = property.getParent().getTag();
        }

        @Override
        public int compareTo(IndiEntry that) {
            int result = this.julianDay - that.julianDay;
            if (result == 0 && (result = CompareString.compareStringUTF8(this.entity.getLastName(), that.entity.getLastName())) == 0) {
                result = CompareString.compareStringUTF8(this.entity.getFirstName(), that.entity.getFirstName());
            }
            return result;
        }
    }

    private static class FamEntry
    implements Comparable<FamEntry> {
        private final int julianDay;
        private final Fam entity;
        private final Property property;
        private final String tag;

        public FamEntry(int julianDay, Fam entity, Property property) {
            this.julianDay = julianDay;
            this.entity = entity;
            this.property = property;
            this.tag = property.getParent().getTag();
        }

        @Override
        public int compareTo(FamEntry that) {
            int result = this.julianDay - that.julianDay;
            if (result == 0 && this.entity.getHusband() != null && that.entity.getHusband() != null && (result = CompareString.compareStringUTF8(this.entity.getHusband().getLastName(), that.entity.getHusband().getLastName())) == 0) {
                result = CompareString.compareStringUTF8(this.entity.getHusband().getFirstName(), that.entity.getHusband().getFirstName());
            }
            return result;
        }
    }
}

