/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import ancestris.api.editor.Editor;
import ancestris.app.ErrorPanel;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.SubMenuAction;
import ancestris.core.resources.Images;
import ancestris.modules.gedcom.searchdupes.DuplicatesFinder;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.edit.ChoosePropertyBean;
import genj.edit.EditView;
import genj.edit.EditViewFactory;
import genj.edit.PropertyTreeWidget;
import genj.edit.SelectEntityToPropagatePanel;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.io.FileAssociation;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

class AdvancedEditor
extends Editor {
    private static final Logger LOG = Logger.getLogger("ancestris.edit");
    private static final Clipboard clipboard = AdvancedEditor.initClipboard();
    private static Gedcom copyFrom = null;
    private static final Registry REGISTRY = Registry.get(AdvancedEditor.class);
    private Set<TagPath> expands = new TreeSet<TagPath>();
    private boolean ignoreTreeSelection = false;
    private static Resources resources = Resources.get(AdvancedEditor.class);
    private Gedcom gedcom;
    private PropertyTreeWidget tree = null;
    private JPanel editPane;
    private PropertyBean bean = null;
    private JSplitPane splitPane = null;
    private EditView view;
    private Callback callback;

    private static Clipboard initClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable t) {
            return new Clipboard("Ancestris");
        }
    }

    public AdvancedEditor(Gedcom gedcom, EditView view) {
        this.gedcom = gedcom;
        this.view = view;
        this.tree = new Tree();
        this.callback = new Callback();
        this.tree.addTreeSelectionListener(this.callback);
        this.tree.addTreeWillExpandListener(this.callback);
        JScrollPane treePane = new JScrollPane((Component)((Object)this.tree));
        treePane.setMinimumSize(new Dimension(160, 128));
        treePane.setPreferredSize(new Dimension(160, 128));
        treePane.getHorizontalScrollBar().setFocusable(false);
        treePane.getVerticalScrollBar().setFocusable(false);
        this.editPane = new JPanel(new BorderLayout());
        JScrollPane editScroll = new JScrollPane(this.editPane);
        editScroll.getVerticalScrollBar().setFocusable(false);
        editScroll.getHorizontalScrollBar().setFocusable(false);
        this.splitPane = new JSplitPane(0, treePane, editScroll);
        this.splitPane.setDividerLocation(REGISTRY.get("divider", 300));
        this.splitPane.setContinuousLayout(true);
        this.splitPane.addPropertyChangeListener(evt -> {
            if ("dividerLocation".equals(evt.getPropertyName())) {
                REGISTRY.put("divider", this.splitPane.getDividerLocation());
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.splitPane, "Center");
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
        String paths = REGISTRY.get("expand", "INDI:BIRT,INDI:RESI,INDI:OBJE,FAM:MARR");
        for (String path : paths.split(",")) {
            try {
                this.expands.add(new TagPath(path));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public Component getEditorComponent() {
        return this.tree;
    }

    public void removeNotify() {
        WordBuffer paths = new WordBuffer(",");
        for (TagPath path : this.expands) {
            paths.append((Object)path);
        }
        REGISTRY.put("expand", paths.toString());
        super.removeNotify();
    }

    public ViewContext getContext() {
        return this.tree.getContext();
    }

    protected void setContextImpl(Context context) {
        this.setContextImpl(context, false);
    }

    private void setContextImpl(Context context, boolean pickFirstProperty) {
        List<Object> props;
        Property root;
        if (this.bean != null) {
            this.bean.removeChangeListener((ChangeListener)this.changes);
        }
        this.bean = null;
        this.editPane.removeAll();
        this.editPane.revalidate();
        this.editPane.repaint();
        this.changes.setChanged(false);
        if (context.getGedcom() == null) {
            try {
                this.ignoreTreeSelection = true;
                this.tree.setRoot(null);
            }
            finally {
                this.ignoreTreeSelection = false;
            }
            return;
        }
        if (context.getEntities().isEmpty()) {
            context = new Context(context.getGedcom().getFirstEntity("HEAD"));
        }
        this.ignoreTreeSelection = true;
        this.tree.clearSelection();
        Entity entity = context.getEntity();
        if (entity != this.tree.getRoot()) {
            this.tree.setRoot((Property)entity);
            for (TagPath path : this.expands) {
                this.expand(path);
            }
        }
        if ((root = this.tree.getRoot()) != null) {
            this.view.commit();
        }
        if ((props = context.getProperties()).isEmpty()) {
            props = pickFirstProperty && entity.getNoOfProperties() > 0 ? Collections.singletonList(entity.getProperty(0)) : Collections.singletonList(entity);
        }
        this.tree.setSelection((List<? extends Property>)props);
        this.ignoreTreeSelection = false;
        if (props.isEmpty()) {
            return;
        }
        Property prop = (Property)props.get(props.size() - 1);
        try {
            this.expand(prop.getPath());
            this.bean = PropertyBean.getBean(prop.getClass()).setContext(prop);
            this.editPane.add((Component)this.bean, "Center");
            JToolBar header = new JToolBar();
            header.setFloatable(false);
            if (prop instanceof PropertyXRef) {
                PropertyXRef propertyXRef = (PropertyXRef)prop;
                JButton follow = new JButton((Action)((Object)new Follow(propertyXRef)));
                header.add(follow);
            } else {
                JLabel label = new JLabel(Gedcom.getName((String)prop.getTag()), (Icon)prop.getImage(false), 2);
                label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                header.add(label);
                this.addLinkButtons(prop, header);
            }
            this.editPane.add((Component)header, "North");
            this.changes.setChanged(false);
            this.bean.addChangeListener((ChangeListener)this.changes);
            if (this.view.isGrabFocus()) {
                this.bean.requestFocus();
            }
            this.setRequestFocusEnabled(!this.view.isGrabFocus());
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Property bean " + this.bean, t);
        }
    }

    public void expand(TagPath path) {
        this.tree.expand(path);
    }

    public void commit() throws GedcomException {
        Property root = this.tree.getRoot();
        if (root == null) {
            return;
        }
        Indi individual = null;
        if (root instanceof Indi) {
            Indi indi;
            individual = indi = (Indi)root;
            individual.setOld();
        }
        if (root.getEntity().getTag().equals("HEAD")) {
            WindowManager.getDefault().invokeWhenUIReady(() -> this.setContextImpl((Context)this.getContext()));
        } else if (this.bean != null) {
            this.bean.commit();
            if (GedcomOptions.getInstance().getAutoCheck()) {
                if (individual != null) {
                    this.checkErrors((Entity)individual);
                } else {
                    this.checkErrors(root.getEntity());
                }
            }
            if (individual != null) {
                if (GedcomOptions.getInstance().getDuplicateAnyTime()) {
                    SwingUtilities.invokeLater((Runnable)new DuplicatesFinder((Entity)individual));
                }
            } else if (GedcomOptions.getInstance().getDuplicateAnyTime()) {
                SwingUtilities.invokeLater((Runnable)new DuplicatesFinder(root.getEntity()));
            }
        }
    }

    private void checkErrors(Entity e) {
        ErrorPanel ep = new ErrorPanel();
        if (ep.setErrors(e)) {
            DialogManager.create((String)ep.getMessage(e), (JComponent)ep).setMessageType(2).setOptionType(10).show();
        }
    }

    public Image getImageIcon() {
        return new EditViewFactory().getImage().getImage();
    }

    public String getName() {
        return new EditViewFactory().getTitle();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Entity getEditedEntity() {
        return this.view.getEntity();
    }

    private void addLinkButtons(Property prop, JToolBar header) {
        Pattern urlPattern = Pattern.compile("(?:^|[\\W])((ht|f)tp(s?):\\/\\/|www\\.)(([\\w\\-]+\\.){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)", 42);
        String txt = prop.getDisplayValue();
        Matcher matcher = urlPattern.matcher(txt);
        for (int nb = 0; matcher.find() && nb < 5; ++nb) {
            int matchStart = matcher.start(1);
            int matchEnd = matcher.end();
            JButton webLink = new JButton((Action)((Object)new WebLink(txt.substring(matchStart, matchEnd).replaceAll(" ", "%20"))));
            header.add(webLink);
        }
    }

    private class Tree
    extends PropertyTreeWidget
    implements AncestrisActionProvider {
        private Tree() {
            super(AdvancedEditor.this.gedcom);
            new Cut(null).install(this, "cut-to-clipboard", 0);
            new Copy(null).install(this, "copy-to-clipboard", 0);
            new Paste(null).install(this, "paste-from-clipboard", 0);
        }

        public List<Action> getActions(boolean hasFocus, Node[] nodes) {
            if (!hasFocus) {
                return new ArrayList<Action>();
            }
            List<Property> selection = AdvancedEditor.this.tree.getSelection();
            ArrayList<Action> result = new ArrayList<Action>();
            if (nodes.length != 0) {
                result.add((Action)((Object)new Cut(selection)));
                result.add((Action)((Object)new Copy(selection)));
            }
            if (selection.size() == 1) {
                result.add((Action)((Object)new Paste(selection.get(0))));
                result.add(null);
                Property prop = selection.get(0);
                if (!prop.isTransient()) {
                    SubMenuAction menu = new SubMenuAction(resources.getString("action.add"));
                    menu.setTip(resources.getString("action.add.tip"));
                    Object[] metas = prop.getNestedMetaProperties(5);
                    Arrays.sort(metas);
                    for (Object meta : metas) {
                        if (!meta.isInstantiated()) {
                            // empty if block
                        }
                        menu.addAction((Action)((Object)new Add(prop, (MetaProperty)meta)));
                    }
                    result.add((Action)menu);
                    result.add((Action)((Object)new Add(prop)));
                }
            } else {
                result.add(null);
            }
            if (!selection.isEmpty() && !selection.contains(AdvancedEditor.this.tree.getRoot())) {
                result.add((Action)((Object)new Propagate(selection)));
            }
            return result;
        }
    }

    private class Callback
    implements TreeSelectionListener,
    TreeWillExpandListener {
        private Callback() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (AdvancedEditor.this.ignoreTreeSelection || AdvancedEditor.this.tree.getRoot() == null) {
                return;
            }
            List<Property> selection = AdvancedEditor.this.tree.getSelection();
            Context ctx = new Context(AdvancedEditor.this.gedcom, Collections.singletonList((Entity)AdvancedEditor.this.tree.getRoot()), selection);
            if (!selection.isEmpty()) {
                SelectionDispatcher.fireSelection((Context)ctx);
                if (ctx.getProperties().size() != 1) {
                    AdvancedEditor.this.setContextImpl(ctx, false);
                }
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            int len = path.getPathCount();
            if (len == 1) {
                throw new ExpandVetoException(event);
            }
            String[] tags = new String[len];
            for (int i = 0; i < len; ++i) {
                tags[i] = ((Property)path.getPathComponent(i)).getTag();
            }
            AdvancedEditor.this.expands.remove(new TagPath(tags, null));
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            int len = path.getPathCount();
            if (len == 1) {
                return;
            }
            String[] tags = new String[len];
            for (int i = 0; i < len; ++i) {
                tags[i] = ((Property)path.getPathComponent(i)).getTag();
            }
            AdvancedEditor.this.expands.add(new TagPath(tags, null));
        }
    }

    private class FocusPolicy
    extends LayoutFocusTraversalPolicy {
        private FocusPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            Component result = super.getComponentAfter(focusCycleRoot, aComponent);
            if (result == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(result, (Component)AdvancedEditor.this.bean)) {
                WindowManager.getDefault().invokeWhenUIReady(() -> {
                    int[] selection = AdvancedEditor.this.tree.getSelectionRows();
                    if (selection != null && selection.length > 0) {
                        AdvancedEditor.this.tree.setSelectionRow((selection[0] + 1) % AdvancedEditor.this.tree.getRowCount());
                        if (AdvancedEditor.this.tree.getSelection().isEmpty()) {
                            AdvancedEditor.this.tree.setSelectionRow(selection[0] % AdvancedEditor.this.tree.getRowCount());
                        }
                    }
                });
            }
            return result;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            Component result = super.getComponentBefore(focusCycleRoot, aComponent);
            if (result == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(result, (Component)AdvancedEditor.this.bean)) {
                WindowManager.getDefault().invokeWhenUIReady(() -> {
                    int i;
                    int[] selection = AdvancedEditor.this.tree.getSelectionRows();
                    if (selection != null && selection.length > 0 && (i = selection[0] - 1) >= 0) {
                        AdvancedEditor.this.tree.setSelectionRow(i % AdvancedEditor.this.tree.getRowCount());
                    }
                });
            }
            return result;
        }
    }

    private class Follow
    extends AbstractAncestrisAction {
        private PropertyXRef xref;

        public Follow(PropertyXRef xref) {
            this.xref = xref;
            this.setText(Gedcom.getName((String)(xref.getTarget() != null ? xref.getTarget().getTag() : xref.getValue())));
            this.setImage((Icon)xref.getImage(false));
            this.setTip(resources.getString("action.follow.tip", new Object[]{""}));
        }

        public void actionPerformed(ActionEvent e) {
            SelectionDispatcher.fireSelection((Context)new Context((Property)this.xref.getTarget()));
        }
    }

    private class WebLink
    extends AbstractAncestrisAction {
        String link = "";

        public WebLink(String link) {
            this.link = link;
            this.setText(null);
            this.setImage((Icon)new ImageIcon(MetaProperty.class, "images/Web"));
            this.setTip(resources.getString("action.weblink.tip", new Object[]{link}));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileAssociation.getDefault().execute(new URL(this.link));
            }
            catch (MalformedURLException ex) {
                DialogManager.createError((String)resources.getString("link.error"), (String)this.link).show();
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class Add
    extends AbstractAncestrisAction {
        private final Property parent;
        private String[] tags;
        private boolean addDefaults = true;

        protected Add(Property parent, MetaProperty meta) {
            this.parent = parent;
            Object txt = meta.getName();
            if (!((String)txt).equals(meta.getTag())) {
                txt = (String)txt + " (" + meta.getTag() + ")";
            }
            this.setText((String)txt);
            this.setImage((Icon)meta.getImage());
            this.tags = new String[]{meta.getTag()};
        }

        protected Add(Property parent) {
            this.parent = parent;
            this.setText(resources.getString("action.list.add") + "...");
            this.setTip(resources.getString("action.list.add.tip"));
            this.setImage((Icon)Images.imgAdd);
        }

        public void actionPerformed(ActionEvent event) {
            PropertyEvent propertyEvent;
            PropertyDate pdate;
            Property newProp;
            if (this.tags == null) {
                ChoosePropertyBean choosePanel = new ChoosePropertyBean(this.parent);
                Object o = DialogManager.create((String)resources.getString("add.title"), (JComponent)choosePanel).setMessageType(3).setOptionType(2).setDialogId("add.title").show();
                choosePanel.saveSettings();
                if (o != DialogManager.OK_OPTION) {
                    return;
                }
                this.tags = choosePanel.getSelectedTags();
                this.addDefaults = choosePanel.isCheckSelected();
                if (this.tags.length == 0) {
                    DialogManager.createError(null, (String)resources.getString("add.must_enter")).show();
                    return;
                }
            }
            AdvancedEditor.this.tree.clearSelection();
            ArrayList newProps = new ArrayList();
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(gedcom1 -> {
                for (String tag : this.tags) {
                    Property prop = this.parent.addProperty(tag, "");
                    newProps.add(prop);
                    if (!this.addDefaults) continue;
                    prop.addDefaultProperties();
                }
            });
            Property property = newProp = newProps.isEmpty() ? null : (Property)newProps.get(0);
            if (newProp instanceof PropertyEvent && (pdate = (propertyEvent = (PropertyEvent)newProp).getDate(false)) != null) {
                newProp = pdate;
            }
            try {
                AdvancedEditor.this.tree.setSelectionPath(new TreePath(AdvancedEditor.this.tree.getPathFor(newProp)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class Paste
    extends AbstractAncestrisAction {
        private Property presetParent;

        protected Paste(Property property) {
            this.presetParent = property;
            this.setText(resources.getString("action.paste"));
            this.setTip(resources.getString("action.paste.tip"));
            this.setImage("org/openide/resources/actions/paste.gif");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
        }

        protected Paste() {
        }

        public void actionPerformed(ActionEvent event) {
            Property parent;
            String content;
            try {
                content = clipboard.getContents((Object)this).getTransferData(DataFlavor.stringFlavor).toString();
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Accessing system clipboard as stringFlavor failed ({0})", t.getMessage());
                return;
            }
            if (this.presetParent != null) {
                parent = this.presetParent;
            } else if (AdvancedEditor.this.tree.getSelectionCount() == 1) {
                parent = AdvancedEditor.this.tree.getSelection().get(0);
            } else {
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(gedcom1 -> {
                PropertyReader reader = new PropertyReader((Reader)new StringReader(content), null, true);
                reader.setMerge(true, copyFrom == gedcom1);
                try {
                    reader.read(parent);
                    copyFrom = null;
                }
                catch (IOException e) {
                    throw new GedcomException("IO during read()");
                }
            });
        }

        private void install(Tree tree, String actionName, int focus) {
            tree.getInputMap(focus).put(KeyStroke.getKeyStroke(86, 128), actionName);
            tree.getActionMap().put(actionName, (Action)((Object)this));
        }

        public boolean isEnabled() {
            List<Property> list = AdvancedEditor.this.tree.getSelection();
            return !list.isEmpty();
        }
    }

    private class Copy
    extends AbstractAncestrisAction {
        protected List<Property> presetSelection;

        protected Copy(List<Property> preset) {
            this.presetSelection = preset != null ? Property.normalize(preset) : null;
            this.setText(resources.getString("action.copy"));
            this.setTip(resources.getString("action.copy.tip"));
            this.setImage("org/openide/resources/actions/copy.gif");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
        }

        protected Copy() {
        }

        public void actionPerformed(ActionEvent event) {
            List<Property> selection = this.presetSelection;
            if (selection == null) {
                selection = Property.normalize(AdvancedEditor.this.tree.getSelection());
            }
            if (selection.contains(AdvancedEditor.this.tree.getRoot())) {
                selection = Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties());
            }
            copyFrom = AdvancedEditor.this.gedcom;
            try {
                clipboard.setContents(new PropertyTransferable(selection).getStringTransferable(), null);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Couldn't copy properties", t);
            }
        }

        private void install(Tree tree, String actionName, int focus) {
            tree.getInputMap(focus).put(KeyStroke.getKeyStroke(67, 128), actionName);
            tree.getActionMap().put(actionName, (Action)((Object)this));
        }

        public boolean isEnabled() {
            List<Property> list = AdvancedEditor.this.tree.getSelection();
            return !list.isEmpty();
        }
    }

    private class Cut
    extends AbstractAncestrisAction {
        protected List<Property> presetSelection;

        private Cut(List<Property> preset) {
            this.presetSelection = preset != null ? Property.normalize(preset) : null;
            this.setImage("org/openide/resources/actions/cut.gif");
            this.setText(resources.getString("action.cut"));
            this.setTip(resources.getString("action.cut.tip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 128));
        }

        public void actionPerformed(ActionEvent event) {
            String veto;
            List selection;
            List list = selection = this.presetSelection != null ? this.presetSelection : Property.normalize(AdvancedEditor.this.tree.getSelection());
            if (selection.isEmpty()) {
                return;
            }
            if (selection.contains(AdvancedEditor.this.tree.getRoot())) {
                selection.clear();
                selection.addAll(Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties()));
            }
            if ((veto = this.getVeto(selection)).length() > 0) {
                String cut = resources.getString("action.cut");
                if (DialogManager.create((String)resources.getString("action.cut"), (String)veto).setMessageType(2).setOptions(new Object[]{cut, DialogManager.CANCEL_OPTION}).setDialogId("action.cut").show() != cut) {
                    return;
                }
            }
            try {
                clipboard.setContents(new PropertyTransferable(selection).getStringTransferable(), null);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Couldn't copy properties", t);
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(gedcom1 -> {
                Property parent1 = null;
                for (Property prop : selection) {
                    parent1 = prop.getParent();
                    parent1.delProperty(prop);
                }
                if (parent1 != null) {
                    SelectionDispatcher.fireSelection((Context)new Context(parent1));
                    AdvancedEditor.this.expand(parent1.getPath());
                }
            });
        }

        private String getVeto(List<Property> properties) {
            boolean found = false;
            String msg = resources.getString("del.warning.message") + "\n\n";
            StringBuilder result = new StringBuilder();
            for (Property p : properties) {
                String veto = p.getDeleteVeto();
                if (veto == null) continue;
                found = true;
                result.append(resources.getString("del.warning", new Object[]{p.getPropertyName(), p.getParent().getPropertyName(), veto}));
                result.append("\n\n");
            }
            if (found) {
                return msg + result.toString();
            }
            return "";
        }

        private void install(Tree tree, String actionName, int focus) {
            tree.getInputMap(focus).put(KeyStroke.getKeyStroke(88, 128), actionName);
            tree.getActionMap().put(actionName, (Action)((Object)this));
        }

        public boolean isEnabled() {
            List<Property> list = AdvancedEditor.this.tree.getSelection();
            return !list.isEmpty();
        }
    }

    private class Propagate
    extends AbstractAncestrisAction {
        private Entity entity;
        private List<Property> properties;
        private String what;

        private Propagate(List<Property> selection) {
            this.entity = (Entity)AdvancedEditor.this.tree.getRoot();
            this.properties = Property.normalize(selection);
            this.setImage((Icon)Images.imgPropagate);
            if (this.properties.isEmpty()) {
                this.setText(resources.getString("action.propagate", new Object[]{""}));
                this.setEnabled(false);
                return;
            }
            this.what = "'" + Property.getPropertyNames(this.properties, (int)5) + "'";
            this.setText(resources.getString("action.propagate") + "...");
            this.setTip(resources.getString("action.propagate.tip", new Object[]{this.what}));
        }

        public void actionPerformed(ActionEvent event) {
            SelectEntityToPropagatePanel select = new SelectEntityToPropagatePanel(AdvancedEditor.this.gedcom, this.entity.getTag(), this.what, AdvancedEditor.this.gedcom.getEntity(REGISTRY.get("select." + this.entity.getTag(), (String)null)), resources.getString("action.propagate.toall"));
            if (DialogManager.OK_OPTION != DialogManager.create((String)resources.getString("action.propagate", new Object[]{""}), (JComponent)select).setMessageType(2).setOptionType(2).setDialogId("propagate.entityselected").show()) {
                return;
            }
            Entity selection = select.getSelection();
            REGISTRY.put("select." + this.entity.getTag(), selection != null ? selection.getId() : null);
            try {
                AdvancedEditor.this.gedcom.doUnitOfWork(gedcom1 -> {
                    for (Entity entity : selection != null ? Collections.singletonList(selection) : gedcom1.getEntities(this.entity.getTag())) {
                        this.copy(this.properties, this.entity, entity, select.isSelected());
                    }
                });
            }
            catch (GedcomException e) {
                DialogManager.createError(null, (String)e.getMessage()).show();
            }
        }

        private void copy(List<Property> selection, Entity from, Entity to, boolean values) throws GedcomException {
            if (from == to) {
                return;
            }
            for (Property property : selection) {
                TagPath path = property.getParent().getPath();
                Property root = to.getProperty(path);
                if (root == null) {
                    root = to.setValue(path, "");
                }
                root.copyProperties(property, values);
            }
        }
    }
}

