# 0.0.20

**Version:** 0.0.20
**Published:** 2023-07-14T16:35:47Z

## Release Notes

🎉 Get ready for the newest release of Rust Coreutils! Top highlights of this release are substantial improvements in GNU test suite compatibility and refined operations in multiple utilities including cksum, chmod, chroot, comm, cp, cut, among others.
Supporting our development is as easy as sponsoring us on GitHub! Your contributions can help us afford a more robust Continuous Integration process through GitHub Actions. To sponsor, please visit https://github.com/sponsors/uutils.

## GNU test suite compatibility

Many utils have gotten minor changes to improve GNU compatibility. Below is a summary of the progress. See https://github.com/uutils/coreutils-tracking/ for more details

| result | 0.0.19 | 0.0.20 | change |
|--------|-------:|-------:|-------:|
| pass   |    365 |    373 |    +8  |
| skip   |     49 |     49 |    0   |
| fail   |    186 |    178 |   -8   |
| error  |      2 |      2 |    0   |
| xpass  |      0 |      0 |    0   |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)



## What's Changed

* Create a FUNDING.yml file by @sylvestre in https://github.com/uutils/coreutils/pull/4969

### cp
* cp: use mkdir_all() instead of mkdir() in test by @cakebaker in https://github.com/uutils/coreutils/pull/5029
* cp: allow multiple usages of -R - Closes: #5027 by @sylvestre in https://github.com/uutils/coreutils/pull/5028
* cp,du: fix warnings in tests on Windows by @cakebaker in https://github.com/uutils/coreutils/pull/5014
* cp: fix "unused variable" warning on Windows by @cakebaker in https://github.com/uutils/coreutils/pull/5016

### date
* date: use custom value parser by @cakebaker in https://github.com/uutils/coreutils/pull/4977
* Remove time dependency from date by @wanderinglethe in https://github.com/uutils/coreutils/pull/4952
* date: switch to parse_datetime by @cakebaker in https://github.com/uutils/coreutils/pull/4968
### dd
* dd: fix typos by @crapStone in https://github.com/uutils/coreutils/pull/5022
* dd: use an alarm thread instead of elapsed() calls by @Freaky in https://github.com/uutils/coreutils/pull/4447

### df
* df: disable failing tests on Windows by @cakebaker in https://github.com/uutils/coreutils/pull/5017
* Find MountInfo properly when symlink is used by @kropacf in https://github.com/uutils/coreutils/pull/4929

### du
* docs: add "du" to extensions by @cakebaker in https://github.com/uutils/coreutils/pull/5050
* du: directories have apparent size of 0 by @shinhs0506 in https://github.com/uutils/coreutils/pull/4991
### hashsum
* hashsum: use file_stem() instead of file_name() by @indygreg in https://github.com/uutils/coreutils/pull/5020

### install
* install: remove time crate by @miles170 in https://github.com/uutils/coreutils/pull/4948
### ls
* ls: Implement new sort option --sort=width  by @Skryptonyte in https://github.com/uutils/coreutils/pull/4954
* docs: add "ls --long" to extensions by @cakebaker in https://github.com/uutils/coreutils/pull/5024
* ls: force fetching metadata when called with -L -Z by @granquet in https://github.com/uutils/coreutils/pull/4960
* ls: Limit value of --width to maximum value if overflowing by @Skryptonyte in https://github.com/uutils/coreutils/pull/5074
* ls: --l should output the same as --literal by @yt2b in https://github.com/uutils/coreutils/pull/5055
* ls: fix version cmp by @shinhs0506 in https://github.com/uutils/coreutils/pull/5038



### mkdir
* mkdir: remove TEST_DIR<x> consts in tests by @cakebaker in https://github.com/uutils/coreutils/pull/4957
### more
* More implement arguments plain and from line by @Ideflop in https://github.com/uutils/coreutils/pull/4950

### mv
* mv: fix into-self-2.sh test by @Skryptonyte in https://github.com/uutils/coreutils/pull/4966
* mv: Fix for tests/mv/symlink-onto-hardlink-to-self.sh by @Skryptonyte in https://github.com/uutils/coreutils/pull/4976
* mv: add the check with --b=simple and when the source is a backup by @sylvestre in https://github.com/uutils/coreutils/pull/4999

### nl
* nl: change value name to match help text by @cakebaker in https://github.com/uutils/coreutils/pull/5062
* nl: add "after help" by @cakebaker in https://github.com/uutils/coreutils/pull/5070
* nl: use value parser for "--number-format" by @cakebaker in https://github.com/uutils/coreutils/pull/5063
* nl: show error if --number-width is zero by @cakebaker in https://github.com/uutils/coreutils/pull/5065
* nl: add test for "--number-separator" by @cakebaker in https://github.com/uutils/coreutils/pull/5073
* nl: fix typo in nl.md by @cakebaker in https://github.com/uutils/coreutils/pull/4994
* nl: implement Default for Settings by @cakebaker in https://github.com/uutils/coreutils/pull/4995
* nl: make -p/--no-renumber a flag by @cakebaker in https://github.com/uutils/coreutils/pull/5036
### numfmt
* numfmt: add --invalid option by @sbentmar in https://github.com/uutils/coreutils/pull/4249
* numfmt: remove duplicate info from help output by @cakebaker in https://github.com/uutils/coreutils/pull/5034

### od
* od: fix parsing of hex input ending with `E` by @TheDcoder in https://github.com/uutils/coreutils/pull/4983

### pr
* `pr` use chrono instead of time by @x-dune in https://github.com/uutils/coreutils/pull/4942

### seq
* seq: rename "--widths" to "--equal-width" by @cakebaker in https://github.com/uutils/coreutils/pull/5012
* seq: remove two chars in seq.md by @cakebaker in https://github.com/uutils/coreutils/pull/5000
* fix: seq panic on no arguments #4749 by @NikolaiSch in https://github.com/uutils/coreutils/pull/4750
* docs: add seq to extensions; add some backticks by @cakebaker in https://github.com/uutils/coreutils/pull/5007

### shred
* fixed shred -u for windows by @Statheres in https://github.com/uutils/coreutils/pull/4986
### sort
* leading zeros are ignored in version compare by @shinhs0506 in https://github.com/uutils/coreutils/pull/5013
* sort: migrate from ouroboros to self_cell by @cakebaker in https://github.com/uutils/coreutils/pull/4972
### split
* split: reject some invalid values by @sylvestre in https://github.com/uutils/coreutils/pull/5032

### stty
* stty: Finish '--save' support by @dezgeg in https://github.com/uutils/coreutils/pull/5054
* stty: Support setting baud rate by @dezgeg in https://github.com/uutils/coreutils/pull/5053



### sync
* sync: fix error msg by @shinhs0506 in https://github.com/uutils/coreutils/pull/4984

### tail
* `tail`: Refactor `paths::Input::from` and `Settings::inputs` by @Joining7943 in https://github.com/uutils/coreutils/pull/4756

### tsort
* tsort: Switch to BTreeMap and BTreeSet by @cazou in https://github.com/uutils/coreutils/pull/4931

### touch
* touch: accept "modify" & "mtime" for --time arg by @cakebaker in https://github.com/uutils/coreutils/pull/5058
* touch: rename CURRENT to TIMESTAMP by @cakebaker in https://github.com/uutils/coreutils/pull/4989
* touch: use parse_datetime instead of humantime_to_duration by @cakebaker in https://github.com/uutils/coreutils/pull/5030

### yes
* yes: add --version option by @yt2b in https://github.com/uutils/coreutils/pull/4990

### Code quality
* Reformat toml and add it to the CI by @sylvestre in https://github.com/uutils/coreutils/pull/4958
* clippy: fix warnings introduced by Rust 1.71.0 by @cakebaker in https://github.com/uutils/coreutils/pull/5079

### Documentation
* Initial oranda setup by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5044
* cspell: ignore oranda.json by @cakebaker in https://github.com/uutils/coreutils/pull/5056

### CI
* fix: fixpr.yml unrecognized named-value: 'steps' by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/5057
* deny.toml: add comments by @cakebaker in https://github.com/uutils/coreutils/pull/4959
* deny.toml: add hashbrown to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/4985
* deny.toml: remove MPL license from allow list by @cakebaker in https://github.com/uutils/coreutils/pull/5076

### misc
* Make tests/help/help-version-getopt.sh pass by @sylvestre in https://github.com/uutils/coreutils/pull/4987
* util/build-gnu.sh: Improve error message when missing GNU Coreutils repository by @sargas in https://github.com/uutils/coreutils/pull/5019
* try to fix ignore intermittent by @sylvestre in https://github.com/uutils/coreutils/pull/4992
* Remove the auto capitalization of error message by @sylvestre in https://github.com/uutils/coreutils/pull/5004
* Update the version to 0.0.20 by @sylvestre in https://github.com/uutils/coreutils/pull/5082

### Dependencies
* Remove users crate by @cakebaker in https://github.com/uutils/coreutils/pull/4943
* chore(deps): update rust crate once_cell to 1.18.0 by @renovate in https://github.com/uutils/coreutils/pull/4944
* chore(deps): update rust crate regex to 1.8.4 by @renovate in https://github.com/uutils/coreutils/pull/4951
* fix(deps): update rust crate libc to 0.2.146 by @renovate in https://github.com/uutils/coreutils/pull/4945
* chore(deps): update rust crate tempfile to 3.6.0 by @renovate in https://github.com/uutils/coreutils/pull/4955
* fix(deps): update rust crate memmap2 to 0.7 by @renovate in https://github.com/uutils/coreutils/pull/4961
* chore(deps): update rust crate blake3 to 1.4.0 by @renovate in https://github.com/uutils/coreutils/pull/4962
* Bump getrandom from 0.2.8 to 0.2.9 by @cakebaker in https://github.com/uutils/coreutils/pull/4947
* Bump fundu to 1.0.0 and fix compile errors by @cakebaker in https://github.com/uutils/coreutils/pull/4927
* chore(deps): update rust crate phf_codegen to 0.11.2 by @renovate in https://github.com/uutils/coreutils/pull/5002
* chore(deps): update rust crate phf to 0.11.2 by @renovate in https://github.com/uutils/coreutils/pull/5001
* chore(deps): update vmactions/freebsd-vm action to v0.3.1 by @renovate in https://github.com/uutils/coreutils/pull/5006
* fix(deps): update rust crate libc to 0.2.147 by @renovate in https://github.com/uutils/coreutils/pull/5008
* chore(deps): update rust crate fundu to 1.1.0 by @renovate in https://github.com/uutils/coreutils/pull/5011
* chore(deps): update rust crate self_cell to 1.0.1 by @renovate in https://github.com/uutils/coreutils/pull/5009
* chore(deps): update davidanson/markdownlint-cli2-action action to v11 by @renovate in https://github.com/uutils/coreutils/pull/4975
* chore(deps): update rust crate sha2 to 0.10.7 by @renovate in https://github.com/uutils/coreutils/pull/4979
* chore(deps): update rust crate notify to v6.0.1 by @renovate in https://github.com/uutils/coreutils/pull/4980
* chore(deps): update rust crate bigdecimal to 0.4 by @renovate in https://github.com/uutils/coreutils/pull/5040
* chore(deps): update rust crate bstr to 1.6 by @renovate in https://github.com/uutils/coreutils/pull/5045
* chore(deps): update rust crate smallvec to 1.11 by @renovate in https://github.com/uutils/coreutils/pull/5046
* chore(deps): update rust crate regex to 1.9.0 by @renovate in https://github.com/uutils/coreutils/pull/5043
* chore(deps): update rust crate rstest to 0.18.1 by @renovate in https://github.com/uutils/coreutils/pull/5039
* chore(deps): update rust crate regex to 1.9.1 by @renovate in https://github.com/uutils/coreutils/pull/5052
* chore(deps): update rust crate fundu to 1.2.0 by @renovate in https://github.com/uutils/coreutils/pull/5061
* fix(deps): update rust crate itertools to 0.11.0 by @renovate in https://github.com/uutils/coreutils/pull/4996
* chore(deps): update rust crate rust-ini to 0.19.0 by @renovate in https://github.com/uutils/coreutils/pull/4825
* chore(deps): update rust crate rlimit to 0.10.0 by @renovate in https://github.com/uutils/coreutils/pull/5035
* Move memmap2 in the root workpace by @sylvestre in https://github.com/uutils/coreutils/pull/5018
* Bump proc-macro2 from 1.0.47 to 1.0.63 by @cakebaker in https://github.com/uutils/coreutils/pull/5021
* Bump iana-time-zone-haiku from 0.1.1 to 0.1.2 by @cakebaker in https://github.com/uutils/coreutils/pull/5041
* update platform-info 2.0.2 by @sylvestre in https://github.com/uutils/coreutils/pull/5071
* Bump pretty_assertions from 1.3.0 to 1.4.0 by @cakebaker in https://github.com/uutils/coreutils/pull/5075
* Bump syn and add it to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5047
* Bump hermit-abi and num_cpus by @cakebaker in https://github.com/uutils/coreutils/pull/5037

## New Contributors
* @x-dune made their first contribution in https://github.com/uutils/coreutils/pull/4942
* @cazou made their first contribution in https://github.com/uutils/coreutils/pull/4931
* @Skryptonyte made their first contribution in https://github.com/uutils/coreutils/pull/4954
* @wanderinglethe made their first contribution in https://github.com/uutils/coreutils/pull/4952
* @kropacf made their first contribution in https://github.com/uutils/coreutils/pull/4929
* @Statheres made their first contribution in https://github.com/uutils/coreutils/pull/4986
* @Freaky made their first contribution in https://github.com/uutils/coreutils/pull/4447
* @yt2b made their first contribution in https://github.com/uutils/coreutils/pull/4990
* @TheDcoder made their first contribution in https://github.com/uutils/coreutils/pull/4983
* @indygreg made their first contribution in https://github.com/uutils/coreutils/pull/5020
* @sargas made their first contribution in https://github.com/uutils/coreutils/pull/5019
* @crapStone made their first contribution in https://github.com/uutils/coreutils/pull/5022
* @NikolaiSch made their first contribution in https://github.com/uutils/coreutils/pull/4750

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.19...0.0.20
