/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _CONTROLLER_H
#define _CONTROLLER_H

#include <gtkmm.h>
#include <iostream>
#include <map>
#include <libintl.h>
#include "DialogMain.h"
#include "DialogBook.h"
#include "DialogBookEditor.h"
#include "DialogBookDelete.h"
#include "DialogError.h"
#include "Book.h"
#include "DiskStorage.h"
#include "NetStorage.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

#define DEFAULT_BOOK_DIRECTORY string(getenv("HOME")) + "/.bibshelf/"

class Controller {
public:
  Controller();
  ~Controller();
  
  DialogMain  mainwindow;
protected:
  // Mainwindow callbacks.
  void on_dialog_main_button_add_clicked(void);
  void on_dialog_main_button_delete_clicked(void);
  void on_dialog_main_button_details_clicked(void);
  void on_dialog_main_gtkbooklist_signal_book_selected(Book* book);
  void on_dialog_main_gtkbooklist_signal_book_activated(Book* book);
  
  // Book dialog callbacks.
  void on_dialog_book_signal_button_edit_clicked(
                                          DialogBook* editor, Book* book);
  void on_dialog_book_signal_button_close_clicked(
                                          DialogBook* editor, Book* book);
  
  // Book editor callbacks.
  void on_dialog_bookeditor_signal_button_cancel_clicked(
                                          DialogBookEditor* editor, Book* book);
  void on_dialog_bookeditor_signal_button_save_clicked(
                                          DialogBookEditor* editor, Book* book);
  
  // Popup window callbacks.
  void on_dialog_book_delete_button_delete_clicked(Gtk::Dialog* dialog,
                                                   Book* book);
  void on_dialog_any_cancel_clicked(Gtk::Dialog* dialog);
  
  // Other callbacks.
  void on_diskstorage_signal_book_loaded(Book* book);
  
  DiskStorage diskstorage;
  NetStorage  netstorage;
  std::map<Book*, DialogBook*>       bookdialoglist;
  std::map<Book*, DialogBookEditor*> bookeditorlist;
};

#endif /* _CONTROLLER_H */
