/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.DFBinaryExpression;
import com.kreative.binpack.DFConstantExpression;
import com.kreative.binpack.DFExpression;
import com.kreative.binpack.DFExpressionLexer;
import com.kreative.binpack.DFFieldExpression;
import com.kreative.binpack.DFLengthExpression;
import com.kreative.binpack.DFPositionExpression;
import com.kreative.binpack.DFRemainingExpression;
import com.kreative.binpack.DFTernaryExpression;
import com.kreative.binpack.DFUnaryExpression;
import java.io.IOException;
import java.io.StringReader;

public class DFExpressionParser {
    private DFExpressionLexer lexer;

    public DFExpressionParser(DFExpressionLexer lexer) {
        this.lexer = lexer;
    }

    public DFExpression parse() throws IOException {
        DFExpression expr = this.parseExpression();
        String s = this.lexer.getToken();
        if (s != null) {
            throw new RuntimeException("Parse error: expected end of expression but found " + s);
        }
        return expr;
    }

    private int parseInt(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            int r = 0;
            char[] cArray = s.substring(1, s.length() - 1).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                r <<= 8;
                r |= ch & 0xFF;
                ++n2;
            }
            return r;
        }
        if (s.startsWith("0x") || s.startsWith("0X")) {
            return (int)Long.parseLong(s.substring(2).trim(), 16);
        }
        if (s.startsWith("0o") || s.startsWith("0O")) {
            return (int)Long.parseLong(s.substring(2).trim(), 8);
        }
        if (s.startsWith("0b") || s.startsWith("0B")) {
            return (int)Long.parseLong(s.substring(2).trim(), 2);
        }
        if (s.startsWith("0") && s.length() > 1) {
            return (int)Long.parseLong(s.substring(1).trim(), 8);
        }
        return (int)Long.parseLong(s);
    }

    private DFExpression parseFactor() throws IOException {
        String s = this.lexer.getToken();
        if (s == null) {
            throw new RuntimeException("Parse error: expected factor but found end of expression");
        }
        if (s.equals("!!")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.BOOLEAN_IDENTITY, this.parseFactor());
        }
        if (s.equals("!")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.BOOLEAN_NOT, this.parseFactor());
        }
        if (s.equals("~")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.BITWISE_NOT, this.parseFactor());
        }
        if (s.equals("+")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.IDENTITY, this.parseFactor());
        }
        if (s.equals("-")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.NEGATE, this.parseFactor());
        }
        if (s.equals("(")) {
            DFExpression expr = this.parseExpression();
            s = this.lexer.getToken();
            if (s == null || !s.equals(")")) {
                throw new RuntimeException("Parse error: expected ) but found " + (s == null ? "end of expression" : s));
            }
            return expr;
        }
        if (s.equals("#") || s.equalsIgnoreCase("length")) {
            return new DFLengthExpression();
        }
        if (s.equals("@") || s.equalsIgnoreCase("position")) {
            return new DFPositionExpression();
        }
        if (s.equals("*") || s.equalsIgnoreCase("remaining")) {
            return new DFRemainingExpression();
        }
        if (s.startsWith("'") || s.startsWith("\"") || Character.isDigit(s.charAt(0))) {
            return new DFConstantExpression(this.parseInt(s));
        }
        if (s.startsWith("`") || s.startsWith("_") || Character.isLetter(s.charAt(0))) {
            if (s.startsWith("`") && s.endsWith("`")) {
                s = s.substring(1, s.length() - 1);
            }
            DFFieldExpression expr = new DFFieldExpression(s);
            while (".".equals(this.lexer.lookToken(1))) {
                this.lexer.getToken();
                s = this.lexer.getToken();
                if (s == null || !s.startsWith("`") && !s.startsWith("_") && !Character.isLetter(s.charAt(0))) {
                    throw new RuntimeException("Parse error: expected field name but found " + (s == null ? "end of expression" : s));
                }
                if (s.startsWith("`") && s.endsWith("`")) {
                    s = s.substring(1, s.length() - 1);
                }
                expr = new DFFieldExpression(expr, s);
            }
            return expr;
        }
        throw new RuntimeException("Parse error: expected factor but found " + s);
    }

    private DFExpression parseMultiplicationExpression() throws IOException {
        String s;
        DFExpression expr = this.parseFactor();
        while ((s = this.lexer.lookToken(1)) != null) {
            if (s.equals("*")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.MULTIPLY, expr, this.parseFactor());
                continue;
            }
            if (s.equals("/")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.DIVIDE, expr, this.parseFactor());
                continue;
            }
            if (!s.equals("%")) break;
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.MOD, expr, this.parseFactor());
        }
        return expr;
    }

    private DFExpression parseAdditionExpression() throws IOException {
        String s;
        DFExpression expr = this.parseMultiplicationExpression();
        while ((s = this.lexer.lookToken(1)) != null) {
            if (s.equals("+")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.ADD, expr, this.parseMultiplicationExpression());
                continue;
            }
            if (!s.equals("-")) break;
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.SUBTRACT, expr, this.parseMultiplicationExpression());
        }
        return expr;
    }

    private DFExpression parseShiftExpression() throws IOException {
        String s;
        DFExpression expr = this.parseAdditionExpression();
        while ((s = this.lexer.lookToken(1)) != null) {
            if (s.equals("<<")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.SHIFT_LEFT, expr, this.parseAdditionExpression());
                continue;
            }
            if (s.equals(">>")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.SHIFT_RIGHT, expr, this.parseAdditionExpression());
                continue;
            }
            if (!s.equals(">>>")) break;
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.UNSIGNED_SHIFT_RIGHT, expr, this.parseAdditionExpression());
        }
        return expr;
    }

    private DFExpression parseBitAndExpression() throws IOException {
        DFExpression expr = this.parseShiftExpression();
        while ("&".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.BITWISE_AND, expr, this.parseShiftExpression());
        }
        return expr;
    }

    private DFExpression parseBitXorExpression() throws IOException {
        DFExpression expr = this.parseBitAndExpression();
        while ("^".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.BITWISE_XOR, expr, this.parseBitAndExpression());
        }
        return expr;
    }

    private DFExpression parseBitOrExpression() throws IOException {
        DFExpression expr = this.parseBitXorExpression();
        while ("|".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.BITWISE_OR, expr, this.parseBitXorExpression());
        }
        return expr;
    }

    private DFExpression parseComparisonExpression() throws IOException {
        String s;
        DFExpression expr = this.parseBitOrExpression();
        while ((s = this.lexer.lookToken(1)) != null) {
            if (s.equals("<=")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.LESS_OR_EQUAL, expr, this.parseBitOrExpression());
                continue;
            }
            if (s.equals(">=")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.GREATER_OR_EQUAL, expr, this.parseBitOrExpression());
                continue;
            }
            if (s.equals("<")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.LESS_THAN, expr, this.parseBitOrExpression());
                continue;
            }
            if (!s.equals(">")) break;
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.GREATER_THAN, expr, this.parseBitOrExpression());
        }
        return expr;
    }

    private DFExpression parseEqualityExpression() throws IOException {
        String s;
        DFExpression expr = this.parseComparisonExpression();
        while ((s = this.lexer.lookToken(1)) != null) {
            if (s.equals("==") || s.equals("=")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.EQUAL, expr, this.parseComparisonExpression());
                continue;
            }
            if (s.equals("!=") || s.equals("<>")) {
                this.lexer.getToken();
                expr = new DFBinaryExpression(DFBinaryExpression.Operation.NOT_EQUAL, expr, this.parseComparisonExpression());
                continue;
            }
            if (!s.equals("<=>")) break;
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.COMPARE, expr, this.parseComparisonExpression());
        }
        return expr;
    }

    private DFExpression parseAndExpression() throws IOException {
        DFExpression expr = this.parseEqualityExpression();
        while ("&&".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.BOOLEAN_AND, expr, this.parseEqualityExpression());
        }
        return expr;
    }

    private DFExpression parseXorExpression() throws IOException {
        DFExpression expr = this.parseAndExpression();
        while ("^^".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.BOOLEAN_XOR, expr, this.parseAndExpression());
        }
        return expr;
    }

    private DFExpression parseOrExpression() throws IOException {
        DFExpression expr = this.parseXorExpression();
        while ("||".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            expr = new DFBinaryExpression(DFBinaryExpression.Operation.BOOLEAN_OR, expr, this.parseXorExpression());
        }
        return expr;
    }

    private DFExpression parseExpression() throws IOException {
        DFExpression expr = this.parseOrExpression();
        if ("?".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            DFExpression trueCase = this.parseExpression();
            String s = this.lexer.getToken();
            if (s == null || !s.equals(":")) {
                throw new RuntimeException("Parse error: expected : but found " + (s == null ? "end of expression" : s));
            }
            DFExpression falseCase = this.parseExpression();
            expr = new DFTernaryExpression(DFTernaryExpression.Operation.CONDITIONAL, expr, trueCase, falseCase);
        }
        return expr;
    }

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            try {
                System.out.println(new DFExpressionParser(new DFExpressionLexer(new StringReader(arg))).parse().evaluate());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            ++n2;
        }
    }
}

