# Copyright 2017 OpenStack Foundation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add aggregate_id field into the computehost_reservations table

Revision ID: 7f1a7bbb2cd2
Revises: 1fd6c2eded89
Create Date: 2017-05-18 09:23:29.730233

"""

# revision identifiers, used by Alembic.
revision = '7f1a7bbb2cd2'
down_revision = '1fd6c2eded89'

from alembic import op
import sqlalchemy as sa


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('computehost_reservations',
                  sa.Column('aggregate_id',
                            sa.Integer,
                            nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('computehost_reservations', 'aggregate_id')
    # ### end Alembic commands ###
