import aQute.bnd.build.*;
import aQute.bnd.build.model.*;
import aQute.bnd.build.model.clauses.*;
import aQute.bnd.osgi.*;
import aQute.bnd.properties.*;
import aQute.lib.io.*;
import java.io.*;
import java.util.jar.*;

println "basedir ${basedir}"

// Check the bndrun file exist!
File bndrunFile = new File(new File(basedir, 'test-with-resolve'), "test.bndrun")
assert bndrunFile.isFile()

// Load the BndEditModel of the bndrun file so we can inspect the result
Processor processor = new Processor()
processor.setProperties(bndrunFile)
BndEditModel bem = new BndEditModel(Workspace.createStandaloneWorkspace(processor, bndrunFile.toURI()))
Document doc = new Document(IO.collect(bndrunFile))
bem.loadFrom(doc)

// Get the -runbundles.
def bemRunBundles = bem.getRunBundles()
assert null == bemRunBundles

File build_log_file = new File("${basedir}/build.log")
assert build_log_file.exists();
def build_log = build_log_file.text

// Simple test
assert build_log =~ /Tests run\s*:\s*1\s*Passed\s*:\s*1\s*Errors\s*:\s*0\s*Failures\s*:\s*0/

// Resolving test
assert build_log =~ /Tests run\s*:\s*2\s*Passed\s*:\s*2\s*Errors\s*:\s*0\s*Failures\s*:\s*0/

// Resolve-from-dependencies test
assert build_log =~ /Tests run\s*:\s*3\s*Passed\s*:\s*3\s*Errors\s*:\s*0\s*Failures\s*:\s*0/
