#include "summary.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace db {
namespace summary {

namespace {
inline int get_station_id(const Station& station) { return MISSING_INT; }
inline int get_station_id(const DBStation& station) { return station.id; }
}

/*
 * Summary
 */

template<typename Station>
void Cursor<Station>::enq(impl::Enq& enq) const
{
    const auto key = enq.key;
    const auto len = enq.len;
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(cur->var_entry.var.level.l1);
                            break;
                        case '2':
                            enq.set_dballe_int(cur->var_entry.var.level.l2);
                            break;
                        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(cur->var_entry.var.trange.p1);
                            break;
                        case '2':
                            enq.set_dballe_int(cur->var_entry.var.trange.p2);
                            break;
                        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(cur->station_entry.station.coords.lat);
                            } else {
                                wreport::error_notfound::throwf("key %s not found on this query result", key);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(cur->station_entry.station.coords.lon);
                            } else {
                                wreport::error_notfound::throwf("key %s not found on this query result", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        enq.set_varcode(cur->var_entry.var.varcode);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(cur->station_entry.station.ident);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        enq.set_level(cur->var_entry.var.level);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ount", 4) == 0) {
                        enq.set_int(cur->var_entry.count);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(cur->station_entry.station.report);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(get_station_id(cur->station_entry.station));
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!cur->station_entry.station.ident.is_missing());
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(cur->station_entry.station.coords);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.max.day);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.min.day);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.max.second);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.min.second);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        enq.set_trange(cur->var_entry.var.trange);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 7:
            switch (key[0]) {
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        enq.set_station(cur->station_entry.station);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.max.year);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.min.year);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.max.hour);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.min.hour);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.max.minute);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.min.minute);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        return;
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(cur->station_entry.station.report);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.max.month);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    if (cur->var_entry.dtrange.is_missing()) return; else enq.set_int(cur->var_entry.dtrange.min.month);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                enq.set_dballe_int(cur->var_entry.var.level.ltype1);
                                break;
                            case '2':
                                enq.set_dballe_int(cur->var_entry.var.level.ltype2);
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        enq.set_dballe_int(cur->var_entry.var.trange.pind);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        enq.set_int(cur->var_entry.count);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 11:
            if (memcmp(key + 0, "datetimem", 9) == 0) {
                switch (key[9]) {
                    case 'a':
                        if (key[10] == 'x') {
                            if (cur->var_entry.dtrange.is_missing()) return; else enq.set_datetime(cur->var_entry.dtrange.max.year);
                        } else {
                            wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                        break;
                    case 'i':
                        if (key[10] == 'n') {
                            if (cur->var_entry.dtrange.is_missing()) return; else enq.set_datetime(cur->var_entry.dtrange.min.year);
                        } else {
                            wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                        break;
                    default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                }
            } else {
                wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
    }
}

template void Cursor<dballe::Station>::enq(impl::Enq& enq) const;
template void Cursor<dballe::DBStation>::enq(impl::Enq& enq) const;

}
}
}
