/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/namespace.hpp
 *
 * @brief [LEVEL: beta] unittest namespace
 *
 * $Id: namespace.hpp,v 1.5 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#ifndef DIAGNOSTICS__UNITTEST__NAMESPACE_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__NAMESPACE_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

#define UNITTEST_NAMESPACE unittest
#define UNITTEST_NAMESPACE_BEGIN namespace UNITTEST_NAMESPACE { void dummy_for_semicolon_do_not_use()
#define UNITTEST_NAMESPACE_END } void dummy_for_semicolon_do_not_use()

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

INTERNAL_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
// vim:ts=4:sw=4
