#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("sends the following keypress to the terminal or application")

    def run(self):
        self.env["input"]["keyForeward"] = 3
        self.env["runtime"]["OutputManager"].present_text(
            _("Forward next keypress"), interrupt=True
        )

    def set_callback(self, callback):
        pass
