/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2008 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.ui.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.utils.ui.StringArrayCustomEditor;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author sg155630
 */
/*package-local*/ final class CndOtherOptionsPanel extends javax.swing.JPanel implements ActionListener {

    public CndOtherOptionsPanel() {
        setName("TAB_CndOtherOptionsTab"); // NOI18N (used as a pattern...)
        initComponents();
        initGeneratedComponents();
        if( "Windows".equals(UIManager.getLookAndFeel().getID()) ) { //NOI18N
            setOpaque( false );
        }
    }

    void applyChanges() {
        for (ExtensionsElements ee : eeList) {
            ee.apply();
        }

        isChanged = false;
    }

    void update() {
        for (ExtensionsElements ee : eeList) {
            ee.update();
        }
    }

    // for OptionsPanelSupport
    private boolean isChanged = false;

    void cancel() {
        isChanged = false;
    }

    boolean isChanged() {
        return isChanged;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        isChanged = true;
    }
    
    private void editExtensionsButtonActionPerformed(ExtensionsElements ee) {
        StringArrayCustomEditor editor = new StringArrayCustomEditor(
                ee.getValues().toArray(new String[]{}), ee.defaultValue,
                getMessage("EE_ItemLabel"), getMessage("EE_ItemLabel_Mnemonic").charAt(0),  // NOI18N
                getMessage("EE_ItemListLabel"), getMessage("EE_ItemListLabel_Mnemonic").charAt(0),  // NOI18N
                false);
        
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        outerPanel.add(editor, gridBagConstraints);
        
        Object[] options = new Object[] {NotifyDescriptor.OK_OPTION};
        DialogDescriptor dd = new DialogDescriptor(outerPanel, getMessage("ExtensionsListEditorTitle"), true, options, NotifyDescriptor.OK_OPTION, 0, null, null);
        
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        java.awt.Dialog dl = dialogDisplayer.createDialog(dd);
        dl.getAccessibleContext().setAccessibleDescription(getMessage("ExtensionsListEditorTitle_AD"));
        dl.pack();
        dl.setSize(new java.awt.Dimension(300, (int)dl.getPreferredSize().getHeight()));
        
        try {
            dl.setVisible(true);
        } catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
        } finally {
            dl.dispose();
        }

        ee.defaultValue = editor.getDefaultValue();
        ee.setValues( editor.getItemList() );
    }

    private final List<ExtensionsElements> eeList = new ArrayList<ExtensionsElements>();

    private void initGeneratedComponents() {
        Collection<MIMEExtensions> orderedExtensions = MIMEExtensions.getCustomizable();
        for (MIMEExtensions ext : orderedExtensions) {
            final ExtensionsElements ee = new ExtensionsElements(ext);

            ee.label.setText(NbBundle.getMessage(CndOtherOptionsPanel.class, "EE_ExtensionListTitle", ext.getLocalizedDescription()));// NOI18N
            ee.button.addActionListener(new java.awt.event.ActionListener() {
                @Override
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    editExtensionsButtonActionPerformed(ee);
                }
            });

            eeList.add(ee);
        }
        GroupLayout layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(layout);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        horizontalGroup.addGap(6, 6, 6);

        GroupLayout.ParallelGroup labelsGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i = 0; i < eeList.size(); i++) {
            labelsGroup.addComponent(eeList.get(i).label);
        }

        horizontalGroup.addGroup(labelsGroup);
        horizontalGroup.addGap(4, 4, 4);

        GroupLayout.ParallelGroup textfieldsGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, false);
        for (int i = 0; i <  eeList.size(); i++) {
            textfieldsGroup.addComponent(eeList.get(i).textfield, GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE);
        }
        horizontalGroup.addGroup(textfieldsGroup);
        horizontalGroup.addGap(6, 6, 6);
        
        GroupLayout.ParallelGroup buttonsGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i = 0; i < eeList.size(); i++) {
            buttonsGroup.addComponent(eeList.get(i).button);
        }
        horizontalGroup.addGroup(buttonsGroup);

        layout.setHorizontalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                    .addGroup(horizontalGroup)
                .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup()
                .addContainerGap();
        
        for (int i = 0; i < eeList.size(); i++) {
            ExtensionsElements ee = eeList.get(i);
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                        .addComponent(ee.label)
                        .addComponent(ee.textfield, GroupLayout.PREFERRED_SIZE, 23, GroupLayout.PREFERRED_SIZE)
                        .addComponent(ee.button, GroupLayout.PREFERRED_SIZE, 23, GroupLayout.PREFERRED_SIZE));
            if (i !=  eeList.size() - 1) {
                verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            } else {
                verticalGroup.addContainerGap(20, Short.MAX_VALUE);
            }
                
        }

        layout.setVerticalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(verticalGroup)
        );
        
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();

        jPanel1.setOpaque(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 423, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 306, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    private static String getMessage(String resourceName) {
        return NbBundle.getMessage(CndOtherOptionsPanel.class, resourceName);
    }
    
    private static final class ExtensionsElements {

        public ExtensionsElements(MIMEExtensions es) {
            this.es = es;
            update();
            textfield.setContentType("text/html");  // NOI18N
            textfield.setEditable(false);
            updateTextField();
            button.setText(getMessage("CndOtherOptionsPanel.Extensions.EditButton"));
        }

        private static final String DELIMITER = ", "; // NOI18N
    
        public void updateTextField() {
            StringBuilder text = new StringBuilder();
            for (String elem : list) {
                if (text.length() > 0) {
                    text.append(DELIMITER);
                }
                if (elem.equals(defaultValue)) {
                    elem = "<b>" + elem + "</b>"; // NOI18N
                }
                text.append(elem);
            }

            textfield.setText(text.toString());
        }

        List<String> getValues() {
            return Collections.unmodifiableList(list);
        }
        
        void setValues(String[] values) {
            list = Arrays.asList(values);
            Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
            updateTextField();
        }

        public void apply() {
            es.setExtensions(getValues(), defaultValue);
        }

        public void update() {
            list = new ArrayList<String>(es.getValues());
            this.defaultValue = es.getDefaultExtension();
            updateTextField();
        }
        
        private final MIMEExtensions es;
        public final JLabel label = new JLabel();
        public final JEditorPane textfield = new JEditorPane();
        public final JButton button = new JButton();
        private List<String> list;
        private String defaultValue;
        
    }
}
