/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.discovery.wizard;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants.WizardConstant;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;


/**
 *
 * @author Alexander Simon
 */
@SuppressWarnings("unchecked") // NOI18N
public class DiscoveryWizardDescriptor extends WizardDescriptor implements DiscoveryDescriptor {
    // Common properties
    public static final WizardConstant<String> ROOT_FOLDER =  WizardConstants.DISCOVERY_ROOT_FOLDER;
    public static final WizardConstant<String> BUILD_RESULT = WizardConstants.DISCOVERY_BUILD_RESULT;
    public static final WizardConstant<FileSystem> FILE_SYSTEM = WizardConstants.DISCOVERY_BINARY_FILESYSTEM;
    public static final WizardConstant<String> ADDITIONAL_LIBRARIES = WizardConstants.DISCOVERY_LIBRARIES;
    public static final WizardConstant<String> COMPILER_NAME = WizardConstants.DISCOVERY_COMPILER;
    public static final WizardConstant<List<String>> DEPENDENCIES = WizardConstants.DISCOVERY_BINARY_DEPENDENCIES;
    public static final WizardConstant<List<String>> SEARCH_PATHS = WizardConstants.DISCOVERY_BINARY_SEARCH_PATH;
    public static final WizardConstant<List<String>> ERRORS = WizardConstants.DISCOVERY_ERRORS;
    public static final WizardConstant<Boolean> RESOLVE_SYMBOLIC_LINKS = WizardConstants.DISCOVERY_RESOLVE_LINKS;

    public static final WizardConstant<Project> PROJECT = new WizardConstant<>("DW:project"); // NOI18N
    public static final WizardConstant<DiscoveryProvider> PROVIDER = new WizardConstant<>("DW:provider"); // NOI18N
    public static final WizardConstant<String> BUILD_FOLDER = new WizardConstant<>("DW:buildFolder"); // NOI18N
    public static final WizardConstant<String> LOG_FILE = new WizardConstant<>("DW:logFile"); // NOI18N
    public static final WizardConstant<String> EXEC_LOG_FILE = new WizardConstant<>("DW:execLogFile"); // NOI18N
    public static final WizardConstant<List<ProjectConfiguration>> CONFIGURATIONS = new WizardConstant<>("DW:configurations"); // NOI18N
    public static final WizardConstant<List<String>> INCLUDED = new WizardConstant<>("DW:included"); // NOI18N
    public static final WizardConstant<Boolean> INVOKE_PROVIDER = new WizardConstant<>("DW:invokeProvider"); // NOI18N
    public static final WizardConstant<List<String>>  BUILD_ARTIFACTS = new WizardConstant<>("DW:buildArtifacts"); // NOI18N
    public static final WizardConstant<Boolean> INCREMENTAL = new WizardConstant<>("DW:incremental"); // NOI18N
    
    private boolean stateChanged = true;
    private boolean cutResult = false;
    
    public DiscoveryWizardDescriptor(WizardDescriptor.Iterator panels){
        super(panels);
    }
    
    public static DiscoveryDescriptor adaptee(Object wizard){
        if (wizard instanceof DiscoveryDescriptor) {
            return (DiscoveryDescriptor) wizard;
        } else if (wizard instanceof WizardDescriptor) {
            return new DiscoveryWizardDescriptorAdapter((WizardDescriptor)wizard);
        } else if (wizard instanceof Map){
            return new DiscoveryWizardClone((Map)wizard);
        }
        return null;
    }
    
    @Override
    public Project getProject(){
        return (Project) getProperty(PROJECT.key());
    }
    @Override
    public void setProject(Project project){
        putProperty(PROJECT.key(), project);
    }
    
    @Override
    public String getRootFolder(){
        return (String) getProperty(ROOT_FOLDER.key());
    }
    
    @Override
    public void setRootFolder(String root){
        stateChanged = true;
        if (root != null && Utilities.isWindows()) {
            root = root.replace('\\','/');
        }
        putProperty(ROOT_FOLDER.key(), root);
    }
    
    @Override
    public List<String> getErrors(){
        return (List<String>) getProperty(ERRORS.key());
    }

    @Override
    public void setErrors(List<String> errors){
        stateChanged = true;
        putProperty(ERRORS.key(), errors);
    }

    @Override
    public String getBuildResult() {
        return (String) getProperty(BUILD_RESULT.key());
    }
    
    @Override
    public void setBuildResult(String binaryPath) {
        putProperty(BUILD_RESULT.key(), binaryPath);
    }

    @Override
    public String getBuildFolder() {
        return (String) getProperty(BUILD_FOLDER.key());
    }

    @Override
    public void setBuildFolder(String buildPath) {
        putProperty(BUILD_FOLDER.key(), buildPath);
    }
   
    @Override
    public FileSystem getFileSystem() {
        return (FileSystem) getProperty(FILE_SYSTEM.key());
    }
    
    @Override
    public void setFileSystem(FileSystem fs) {
        putProperty(FILE_SYSTEM.key(), fs);
    }
    
    @Override
    public String getAditionalLibraries() {
        return (String) getProperty(ADDITIONAL_LIBRARIES.key());
    }
    
    @Override
    public void setAditionalLibraries(String binaryPath) {
        putProperty(ADDITIONAL_LIBRARIES.key(), binaryPath);
    }

    @Override
    public String getBuildLog() {
        return (String) getProperty(LOG_FILE.key());
    }

    @Override
    public void setBuildLog(String logFile) {
        putProperty(LOG_FILE.key(), logFile);
    }
    
    @Override
    public String getExecLog() {
        return (String) getProperty(EXEC_LOG_FILE.key());
    }

    @Override
    public void setExecLog(String logFile) {
        putProperty(EXEC_LOG_FILE.key(), logFile);
    }
    
    @Override
    public DiscoveryProvider getProvider(){
        return (DiscoveryProvider) getProperty(PROVIDER.key());
    }
    @Override
    public String getProviderID(){
        DiscoveryProvider provider =(DiscoveryProvider) getProperty(PROVIDER.key());
        if (provider != null){
            return provider.getID();
        }
        return null;
    }
    @Override
    public void setProvider(DiscoveryProvider provider){
        stateChanged = true;
        putProperty(PROVIDER.key(), provider);
    }
    
    @Override
    public List<ProjectConfiguration> getConfigurations(){
        return (List<ProjectConfiguration>) getProperty(CONFIGURATIONS.key());
    }
    @Override
    public void setConfigurations(List<ProjectConfiguration> configuration){
        putProperty(CONFIGURATIONS.key(), configuration);
    }
    
    @Override
    public List<String> getIncludedFiles(){
        return (List<String>) getProperty(INCLUDED.key());
    }
    @Override
    public void setIncludedFiles(List<String> includedFiles){
        putProperty(INCLUDED.key(), includedFiles);
    }
    
    @Override
    public boolean isInvokeProvider(){
        return stateChanged;
    }
    
    @Override
    public void setInvokeProvider(boolean invoke){
        stateChanged = invoke;
    }
    
    @Override
    public void setMessage(String message) {
        putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, message); // NOI18N
    }

    @Override
    public void clean() {
        setProject(null);
        setProvider(null);
        setRootFolder(null);
        setBuildResult(null);
        setAditionalLibraries(null);
        setConfigurations(null);
        setIncludedFiles(null);
    }
    
    public boolean isCutResult() {
        return cutResult;
    }

    public void setCutResult(boolean cutResult) {
        this.cutResult = cutResult;
    }

    @Override
    public String getCompilerName() {
        return (String) getProperty(COMPILER_NAME.key());
    }

    @Override
    public void setCompilerName(String compiler) {
        putProperty(COMPILER_NAME.key(), compiler);
    }

    @Override
    public List<String> getDependencies() {
        return (List<String>) getProperty(DEPENDENCIES.key());
    }

    @Override
    public void setDependencies(List<String> dependencies) {
        putProperty(DEPENDENCIES.key(), dependencies);
    }

    @Override
    public List<String> getBuildArtifacts() {
        return (List<String>) getProperty(BUILD_ARTIFACTS.key());
    }

    @Override
    public void setBuildArtifacts(List<String> buildArtifacts) {
        putProperty(BUILD_ARTIFACTS.key(), buildArtifacts);
    }

    @Override
    public List<String> getSearchPaths() {
        return (List<String>) getProperty(SEARCH_PATHS.key());
    }

    @Override
    public void setSearchPaths(List<String> searchPaths) {
        putProperty(SEARCH_PATHS.key(), searchPaths);
    }

    @Override
    public boolean isIncrementalMode() {
        return Boolean.TRUE.equals(getProperty(INCREMENTAL.key()));
    }

    @Override
    public void setIncrementalMode(boolean incremental) {
        putProperty(INCREMENTAL.key(), incremental);
    }

    @Override
    public boolean isResolveSymbolicLinks() {
        return Boolean.TRUE.equals(getProperty(RESOLVE_SYMBOLIC_LINKS.key()));
    }

    @Override
    public void setResolveSymbolicLinks(boolean resolveSymbolicLinks) {
        putProperty(RESOLVE_SYMBOLIC_LINKS.key(), resolveSymbolicLinks);
    }

    private static class DiscoveryWizardDescriptorAdapter implements DiscoveryDescriptor{
        private final WizardDescriptor wizard;
        public DiscoveryWizardDescriptorAdapter(WizardDescriptor wizard){
            this.wizard = wizard;
        }
        
        @Override
        public Project getProject(){
            return PROJECT.get(wizard);
        }
        @Override
        public void setProject(Project project){
            PROJECT.put(wizard, project);
        }
        
        @Override
        public String getRootFolder(){
            String root = ROOT_FOLDER.get(wizard);
            if (root == null) {
                // field in project wizard
                root = WizardConstants.PROPERTY_WORKING_DIR.get(wizard); // NOI18N
                if (root != null && Utilities.isWindows()) {
                    root = root.replace('\\','/');
                }
            }
            return root;
        }
        @Override
        public void setRootFolder(String root){
            wizard.putProperty(INVOKE_PROVIDER.key(), Boolean.TRUE);
            if (root != null && Utilities.isWindows()) {
                root = root.replace('\\','/');
            }
            ROOT_FOLDER.put(wizard, root);
        }

        @Override
        @SuppressWarnings("unchecked")
        public List<String> getErrors(){
            return ERRORS.get(wizard);
        }

        @Override
        public void setErrors(List<String> errors){
            ERRORS.put(wizard, errors);
        }
        
        @Override
        public String getBuildResult() {
            return BUILD_RESULT.get(wizard);
        }
        
        @Override
        public void setBuildResult(String binaryPath) {
            BUILD_RESULT.put(wizard, binaryPath);
        }

        @Override
        public String getBuildFolder() {
            return BUILD_FOLDER.get(wizard);
        }

        @Override
        public void setBuildFolder(String buildPath) {
            BUILD_FOLDER.put(wizard, buildPath);
        }

        @Override
        public FileSystem getFileSystem() {
            return FILE_SYSTEM.get(wizard);
        }
        
        @Override
        public void setFileSystem(FileSystem fs) {
            FILE_SYSTEM.put(wizard, fs);
        }
        
        @Override
        public String getAditionalLibraries() {
            return ADDITIONAL_LIBRARIES.get(wizard);
        }
        
        @Override
        public void setAditionalLibraries(String binaryPath) {
            ADDITIONAL_LIBRARIES.put(wizard, binaryPath);
        }

        @Override
        public String getBuildLog() {
            return LOG_FILE.get(wizard);
        }

        @Override
        public void setBuildLog(String logFile) {
            LOG_FILE.put(wizard, logFile);
        }
        
        @Override
        public String getExecLog() {
            return EXEC_LOG_FILE.get(wizard);
        }

        @Override
        public void setExecLog(String logFile) {
            EXEC_LOG_FILE.put(wizard, logFile);
        }
        
        @Override
        public DiscoveryProvider getProvider(){
            return PROVIDER.get(wizard);
        }
        @Override
        public String getProviderID(){
            DiscoveryProvider provider =PROVIDER.get(wizard);
            if (provider != null){
                return provider.getID();
            }
            return null;
        }
        @Override
        public void setProvider(DiscoveryProvider provider){
            INVOKE_PROVIDER.put(wizard, Boolean.TRUE);
            PROVIDER.put(wizard, provider);
        }
        
        @Override
        public List<ProjectConfiguration> getConfigurations(){
            return CONFIGURATIONS.get(wizard);
        }
        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration){
            CONFIGURATIONS.put(wizard, configuration);
        }
        
        @Override
        public List<String> getIncludedFiles(){
            return INCLUDED.get(wizard);
        }
        @Override
        public void setIncludedFiles(List<String> includedFiles){
            INCLUDED.put(wizard, includedFiles);
        }
        
        @Override
        public boolean isInvokeProvider(){
            Boolean res = INVOKE_PROVIDER.get(wizard);
            if (res == null) {
                return true;
            }
            return res;
        }
        
        @Override
        public void setInvokeProvider(boolean invoke){
            INVOKE_PROVIDER.put(wizard, invoke);
        }
        
        public boolean isCutResult() {
            return false;
        }

        public void setCutResult(boolean cutResult) {
        }
        
        @Override
        public void setMessage(String message) {
            wizard.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, message); // NOI18N
        }
        
        @Override
        public void clean() {
            setProject(null);
            setProvider(null);
            setRootFolder(null);
            setBuildResult(null);
            setAditionalLibraries(null);
            setBuildLog(null);
            setConfigurations(null);
            setIncludedFiles(null);
        }

        @Override
        public String getCompilerName() {
            return COMPILER_NAME.get(wizard);
        }

        @Override
        public void setCompilerName(String compiler) {
            COMPILER_NAME.put(wizard, compiler);
        }

        @Override
        public List<String> getDependencies() {
            return DEPENDENCIES.get(wizard);
        }

        @Override
        public void setDependencies(List<String> dependencies) {
            DEPENDENCIES.put(wizard, dependencies);
        }

        @Override
        public List<String> getBuildArtifacts() {
            return BUILD_ARTIFACTS.get(wizard);
        }

        @Override
        public void setBuildArtifacts(List<String> buildArtifacts) {
            BUILD_ARTIFACTS.put(wizard, buildArtifacts);
        }

        @Override
        public List<String> getSearchPaths() {
            return SEARCH_PATHS.get(wizard);
        }

        @Override
        public void setSearchPaths(List<String> searchPaths) {
            SEARCH_PATHS.put(wizard, searchPaths);
        }

        @Override
        public boolean isIncrementalMode() {
            return Boolean.TRUE.equals(INCREMENTAL.get(wizard));
        }

        @Override
        public void setIncrementalMode(boolean incremental) {
            INCREMENTAL.put(wizard, incremental);
        }

        @Override
        public boolean isResolveSymbolicLinks() {
            return Boolean.TRUE.equals(RESOLVE_SYMBOLIC_LINKS.get(wizard));
        }

        @Override
        public void setResolveSymbolicLinks(boolean resolveSymbolicLinks) {
            RESOLVE_SYMBOLIC_LINKS.put(wizard, resolveSymbolicLinks);
        }
    }

    private static class DiscoveryWizardClone implements DiscoveryDescriptor{
        private final Map<String, Object> map;
        
        public DiscoveryWizardClone(Map<String, Object> map){
            this.map = map;
        }
        
        @Override
        public Project getProject(){
            return PROJECT.fromMap(map);
        }
        @Override
        public void setProject(Project project){
            PROJECT.toMap(map, project);
        }
        
        @Override
        public String getRootFolder(){
            String root = ROOT_FOLDER.fromMap(map);
            if (root == null) {
                // field in project wizard
                root = WizardConstants.PROPERTY_WORKING_DIR.fromMap(map); // NOI18N
                if (root != null && Utilities.isWindows()) {
                    root = root.replace('\\','/');
                }
            }
            return root;
        }
        @Override
        public void setRootFolder(String root){
            INVOKE_PROVIDER.toMap(map, Boolean.TRUE);
            if (root != null && Utilities.isWindows()) {
                root = root.replace('\\','/');
            }
            ROOT_FOLDER.toMap(map, root);
        }

        @Override
        @SuppressWarnings("unchecked")
        public List<String> getErrors(){
            return ERRORS.fromMap(map);
        }

        @Override
        public void setErrors(List<String> errors){
            ERRORS.toMap(map, errors);
        }
        
        @Override
        public String getBuildResult() {
            return BUILD_RESULT.fromMap(map);
        }
        
        @Override
        public void setBuildResult(String binaryPath) {
            BUILD_RESULT.toMap(map, binaryPath);
        }

        @Override
        public String getBuildFolder() {
            return BUILD_FOLDER.fromMap(map);
        }

        @Override
        public void setBuildFolder(String buildPath) {
            BUILD_FOLDER.toMap(map, buildPath);
        }

        @Override
        public FileSystem getFileSystem() {
            return FILE_SYSTEM.fromMap(map);
        }
        
        @Override
        public void setFileSystem(FileSystem fs) {
            FILE_SYSTEM.toMap(map, fs);
        }
        
        @Override
        public String getAditionalLibraries() {
            return ADDITIONAL_LIBRARIES.fromMap(map);
        }
        
        @Override
        public void setAditionalLibraries(String binaryPath) {
            ADDITIONAL_LIBRARIES.toMap(map, binaryPath);
        }

        @Override
        public String getBuildLog() {
            return LOG_FILE.fromMap(map);
        }

        @Override
        public void setBuildLog(String logFile) {
            LOG_FILE.toMap(map, logFile);
        }
        
        @Override
        public String getExecLog() {
            return EXEC_LOG_FILE.fromMap(map);
        }

        @Override
        public void setExecLog(String logFile) {
            EXEC_LOG_FILE.toMap(map, logFile);
        }
        
        @Override
        public DiscoveryProvider getProvider(){
            return PROVIDER.fromMap(map);
        }
        @Override
        public String getProviderID(){
            DiscoveryProvider provider = PROVIDER.fromMap(map);
            if (provider != null){
                return provider.getID();
            }
            return null;
        }
        @Override
        public void setProvider(DiscoveryProvider provider){
            INVOKE_PROVIDER.toMap(map, Boolean.TRUE);
            PROVIDER.toMap(map, provider);
        }
        
        @Override
        public List<ProjectConfiguration> getConfigurations(){
            return CONFIGURATIONS.fromMap(map);
        }
        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration){
            CONFIGURATIONS.toMap(map, configuration);
        }
        
        @Override
        public List<String> getIncludedFiles(){
            return INCLUDED.fromMap(map);
        }
        @Override
        public void setIncludedFiles(List<String> includedFiles){
            INCLUDED.toMap(map, includedFiles);
        }
        
        @Override
        public boolean isInvokeProvider(){
            Boolean res = INVOKE_PROVIDER.fromMap(map);
            if (res == null) {
                return true;
            }
            return res;
        }
        
        @Override
        public void setInvokeProvider(boolean invoke){
            INVOKE_PROVIDER.toMap(map, invoke);
        }
        
        public boolean isCutResult() {
            return false;
        }

        public void setCutResult(boolean cutResult) {
        }
        
        @Override
        public void setMessage(String message) {
            map.put(WizardDescriptor.PROP_ERROR_MESSAGE, message); // NOI18N
        }
        
        @Override
        public void clean() {
            setProject(null);
            setProvider(null);
            setRootFolder(null);
            setBuildResult(null);
            setAditionalLibraries(null);
            setBuildLog(null);
            setConfigurations(null);
            setIncludedFiles(null);
        }

        @Override
        public String getCompilerName() {
            return COMPILER_NAME.fromMap(map);
        }

        @Override
        public void setCompilerName(String compiler) {
            COMPILER_NAME.toMap(map, compiler);
        }

        @Override
        public List<String> getDependencies() {
            return DEPENDENCIES.fromMap(map);
        }

        @Override
        public void setDependencies(List<String> dependencies) {
            DEPENDENCIES.toMap(map, dependencies);
        }

        @Override
        public List<String> getBuildArtifacts() {
            return BUILD_ARTIFACTS.fromMap(map);
        }

        @Override
        public void setBuildArtifacts(List<String> buildArtifacts) {
            BUILD_ARTIFACTS.toMap(map, buildArtifacts);
        }

        @Override
        public List<String> getSearchPaths() {
            return SEARCH_PATHS.fromMap(map);
        }

        @Override
        public void setSearchPaths(List<String> searchPaths) {
            SEARCH_PATHS.toMap(map, searchPaths);
        }

        @Override
        public boolean isIncrementalMode() {
            return Boolean.TRUE.equals(INCREMENTAL.fromMap(map));
        }

        @Override
        public void setIncrementalMode(boolean incremental) {
            INCREMENTAL.toMap(map, incremental);
        }
        
        @Override
        public boolean isResolveSymbolicLinks() {
            return Boolean.TRUE.equals(RESOLVE_SYMBOLIC_LINKS.fromMap(map));
        }

        @Override
        public void setResolveSymbolicLinks(boolean resolveSymbolicLinks) {
            RESOLVE_SYMBOLIC_LINKS.toMap(map, resolveSymbolicLinks);
        }
    }
}
