/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2013 Sun Microsystems, Inc.
 */

package org.netbeans.core.windows.documentgroup;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author S. Aubrecht
 */
class ManageGroupsPanel extends javax.swing.JPanel {
    
    private DialogDescriptor descriptor;
    private Dialog dialog;
    private final JButton btnSelect = new JButton(NbBundle.getMessage(ManageGroupsPanel.class, "Btn_SELECT"));
    /**
     * Creates new form ManageGroupsPanel
     */
    public ManageGroupsPanel() {
        initComponents();
        fillGroups();
        btnSelect.setEnabled(false);
        listGroups.getSelectionModel().addListSelectionListener( new ListSelectionListener() {

            @Override
            public void valueChanged( ListSelectionEvent e ) {
                enableButtons();
            }
        } );
        btnSelect.addActionListener( new ActionListener() {

            @Override
            public void actionPerformed( ActionEvent e ) {
                DocumentGroupImpl group = (DocumentGroupImpl) listGroups.getSelectedValue();
                if( null != group ) {
                    GroupsManager.getDefault().openGroup( group );
                }
            }
        });
    }
    
    private void enableButtons() {
        btnRemoveAll.setEnabled( listGroups.getModel().getSize() > 0 );
        int selIndex = listGroups.getSelectedIndex();
        if( null != descriptor ) {
            descriptor.setValid( selIndex >= 0 );
        }
        btnSelect.setEnabled(selIndex>=0);
    }

    public void showDialog() {
        descriptor = new DialogDescriptor(this, NbBundle.getMessage(ManageGroupsPanel.class, "Dlg_DOCUMENT_GROUPS"), true, 
                new Object[] { btnSelect, DialogDescriptor.CANCEL_OPTION }, btnSelect, DialogDescriptor.DEFAULT_ALIGN, null, null);
        descriptor.setHelpCtx( new HelpCtx("org.netbeans.core.windows.documentgroup.ManageGroupsPanel") ); //NOI18N
        descriptor.setValid( false );
        dialog = DialogDisplayer.getDefault().createDialog( descriptor );
        dialog.setVisible( true );
        GroupsMenuAction.refreshMenu();
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollGroups = new javax.swing.JScrollPane();
        listGroups = new javax.swing.JList();
        btnRemove = new javax.swing.JButton();
        btnRemoveAll = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));

        listGroups.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        scrollGroups.setViewportView(listGroups);

        org.openide.awt.Mnemonics.setLocalizedText(btnRemove, org.openide.util.NbBundle.getMessage(ManageGroupsPanel.class, "ManageGroupsPanel.btnRemove.text")); // NOI18N
        btnRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRemoveActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(btnRemoveAll, org.openide.util.NbBundle.getMessage(ManageGroupsPanel.class, "ManageGroupsPanel.btnRemoveAll.text")); // NOI18N
        btnRemoveAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRemoveAllActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(scrollGroups, javax.swing.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(btnRemoveAll, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btnRemove, javax.swing.GroupLayout.PREFERRED_SIZE, 114, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(scrollGroups, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGroup(layout.createSequentialGroup()
                .addComponent(btnRemove)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnRemoveAll))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnRemoveAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRemoveAllActionPerformed
        GroupsManager.getDefault().removeAllGroups();
        fillGroups();
        enableButtons();
    }//GEN-LAST:event_btnRemoveAllActionPerformed

    private void btnRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRemoveActionPerformed
        DocumentGroupImpl group = (DocumentGroupImpl) listGroups.getSelectedValue();
        if( null != group ) {
            GroupsManager.getDefault().removeGroup( group );
            fillGroups();
            enableButtons();
        }
    }//GEN-LAST:event_btnRemoveActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnRemove;
    private javax.swing.JButton btnRemoveAll;
    private javax.swing.JList listGroups;
    private javax.swing.JScrollPane scrollGroups;
    // End of variables declaration//GEN-END:variables


    private void fillGroups() {
        List<DocumentGroupImpl> groups = GroupsManager.getDefault().getGroups();
        DefaultListModel model = new DefaultListModel();
        for( DocumentGroupImpl group : groups ) {
            model.addElement( group );
        }
        listGroups.setModel( model );
    }
}
