## Usage

```js
var cloneDeep = require('{%= name %}');

var obj = {a: 'b'};
var arr = [obj];

var copy = cloneDeep(arr);
obj.c = 'd';

console.log(copy);
//=> [{a: 'b'}]

console.log(arr);
//=> [{a: 'b', c: 'd'}]
```

## Heads up!

The `instanceClone` function is invoked to clone objects that are not "plain" objects (as defined by [`isPlainObject`](#isPlainObject)) if it is provided. If `instanceClone` is not specified, it will not attempt to clone non-plain objects, and will copy the object reference.

## Attribution

Based on [mout's](https://github.com/mout/mout) implementation of deepClone.
