/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Test if a value is an infinite number.
*
* @module @stdlib/assert/is-infinite
*
* @example
* var isInfinite = require( '@stdlib/assert/is-infinite' );
*
* var bool = isInfinite( 1.0/0.0 );
* // returns true
*
* bool = isInfinite( new Number( 1.0/0.0 ) );
* // returns true
*
* bool = isInfinite( 5.0 );
* // returns false
*
* bool = isInfinite( null );
* // returns false
*
* @example
* var isInfinite = require( '@stdlib/assert/is-infinite' ).isPrimitive;
*
* var bool = isInfinite( -1.0/0.0 );
* // returns true
*
* bool = isInfinite( new Number( -1.0/0.0 ) );
* // returns false
*
* @example
* var isInfinite = require( '@stdlib/assert/is-infinite' ).isObject;
*
* var bool = isInfinite( 1.0/0.0 );
* // returns false
*
* bool = isInfinite( new Number( 1.0/0.0 ) );
* // returns true
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var isInfinite = require( './main.js' );
var isPrimitive = require( './primitive.js' );
var isObject = require( './object.js' );


// MAIN //

setReadOnly( isInfinite, 'isPrimitive', isPrimitive );
setReadOnly( isInfinite, 'isObject', isObject );


// EXPORTS //

module.exports = isInfinite;
