// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSolid_Ellipsoid_HeaderFile
#define _IGESSolid_Ellipsoid_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IGESSolid_Ellipsoid_HeaderFile
#include <Handle_IGESSolid_Ellipsoid.hxx>
#endif

#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_XYZ;
class gp_Pnt;
class gp_Dir;


//! defines Ellipsoid, Type <168> Form Number <0> <br>
//!          in package IGESSolid <br>
//!          The ellipsoid is a solid bounded by the surface defined <br>
//!          by: <br>
//!                    X^2       Y^2       Z^2 <br>
//!                   -----  +  -----  +  -----  =  1 <br>
//!                    LX^2      LY^2      LZ^2 <br>
class IGESSolid_Ellipsoid : public IGESData_IGESEntity {

public:

  
  Standard_EXPORT   IGESSolid_Ellipsoid();
  //! This method is used to set the fields of the class <br>
//!           Ellipsoid <br>
//!       - aSize      : Lengths in the local X,Y,Z directions <br>
//!       - aCenter    : Center point of ellipsoid (default (0,0,0)) <br>
//!       - anXAxis    : Unit vector defining local X-axis <br>
//!                      default (1,0,0) <br>
//!       - anZAxis    : Unit vector defining local Z-axis <br>
//!                      default (0,0,1) <br>
  Standard_EXPORT     void Init(const gp_XYZ& aSize,const gp_XYZ& aCenter,const gp_XYZ& anXAxis,const gp_XYZ& anZAxis) ;
  //! returns the size <br>
  Standard_EXPORT     gp_XYZ Size() const;
  //! returns the length in the local X-direction <br>
  Standard_EXPORT     Standard_Real XLength() const;
  //! returns the length in the local Y-direction <br>
  Standard_EXPORT     Standard_Real YLength() const;
  //! returns the length in the local Z-direction <br>
  Standard_EXPORT     Standard_Real ZLength() const;
  //! returns the center of the ellipsoid <br>
  Standard_EXPORT     gp_Pnt Center() const;
  //! returns the center of the ellipsoid after applying <br>
//! TransformationMatrix <br>
  Standard_EXPORT     gp_Pnt TransformedCenter() const;
  //! returns the vector corresponding to the local X-direction <br>
  Standard_EXPORT     gp_Dir XAxis() const;
  //! returns the vector corresponding to the local X-direction <br>
//! after applying TransformationMatrix <br>
  Standard_EXPORT     gp_Dir TransformedXAxis() const;
  //! returns the vector corresponding to the local Y-direction <br>
//! which is got by taking cross product of ZAxis and XAxis <br>
  Standard_EXPORT     gp_Dir YAxis() const;
  //! returns the vector corresponding to the local Y-direction <br>
//! (which is got by taking cross product of ZAxis and XAxis) <br>
//! after applying TransformationMatrix <br>
  Standard_EXPORT     gp_Dir TransformedYAxis() const;
  //! returns the vector corresponding to the local Z-direction <br>
  Standard_EXPORT     gp_Dir ZAxis() const;
  //! returns the vector corresponding to the local Z-direction <br>
//! after applying TransformationMatrix <br>
  Standard_EXPORT     gp_Dir TransformedZAxis() const;




  DEFINE_STANDARD_RTTI(IGESSolid_Ellipsoid)

protected:




private: 


gp_XYZ theSize;
gp_XYZ theCenter;
gp_XYZ theXAxis;
gp_XYZ theZAxis;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
