/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_OperatingSystem.h"

CMPIObjectPath* OS_OpenDRIM_OperatingSystem_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_OperatingSystem& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_OperatingSystem_classnames[0], OpenDRIM_OperatingSystem_NAMESPACE);

	if (!instance.CSCreationClassName_isNULL)
		op.addKey("CSCreationClassName", instance.CSCreationClassName);

	if (!instance.CSName_isNULL)
		op.addKey("CSName", instance.CSName);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	_L_;
	return op.getHdl();
}

CMPIInstance* OS_OpenDRIM_OperatingSystem_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_OperatingSystem& instance) {
	_E_;
	Objectpath op(broker, OS_OpenDRIM_OperatingSystem_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.InstanceID_isNULL)
		ci.setProperty("InstanceID", instance.InstanceID);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.OSType_isNULL)
		ci.setProperty("OSType", instance.OSType);

	if (!instance.OtherTypeDescription_isNULL)
		ci.setProperty("OtherTypeDescription", instance.OtherTypeDescription);

	if (!instance.Version_isNULL)
		ci.setProperty("Version", instance.Version);

	if (!instance.LastBootUpTime_isNULL)
		ci.setPropertyDatetime("LastBootUpTime", instance.LastBootUpTime);

	if (!instance.LocalDateTime_isNULL)
		ci.setPropertyDatetime("LocalDateTime", instance.LocalDateTime);

	if (!instance.CurrentTimeZone_isNULL)
		ci.setProperty("CurrentTimeZone", instance.CurrentTimeZone);

	if (!instance.NumberOfLicensedUsers_isNULL)
		ci.setProperty("NumberOfLicensedUsers", instance.NumberOfLicensedUsers);

	if (!instance.NumberOfUsers_isNULL)
		ci.setProperty("NumberOfUsers", instance.NumberOfUsers);

	if (!instance.NumberOfProcesses_isNULL)
		ci.setProperty("NumberOfProcesses", instance.NumberOfProcesses);

	if (!instance.MaxNumberOfProcesses_isNULL)
		ci.setProperty("MaxNumberOfProcesses", instance.MaxNumberOfProcesses);

	if (!instance.TotalSwapSpaceSize_isNULL)
		ci.setProperty("TotalSwapSpaceSize", instance.TotalSwapSpaceSize);

	if (!instance.TotalVirtualMemorySize_isNULL)
		ci.setProperty("TotalVirtualMemorySize", instance.TotalVirtualMemorySize);

	if (!instance.FreeVirtualMemory_isNULL)
		ci.setProperty("FreeVirtualMemory", instance.FreeVirtualMemory);

	if (!instance.FreePhysicalMemory_isNULL)
		ci.setProperty("FreePhysicalMemory", instance.FreePhysicalMemory);

	if (!instance.TotalVisibleMemorySize_isNULL)
		ci.setProperty("TotalVisibleMemorySize", instance.TotalVisibleMemorySize);

	if (!instance.SizeStoredInPagingFiles_isNULL)
		ci.setProperty("SizeStoredInPagingFiles", instance.SizeStoredInPagingFiles);

	if (!instance.FreeSpaceInPagingFiles_isNULL)
		ci.setProperty("FreeSpaceInPagingFiles", instance.FreeSpaceInPagingFiles);

	if (!instance.MaxProcessMemorySize_isNULL)
		ci.setProperty("MaxProcessMemorySize", instance.MaxProcessMemorySize);

	if (!instance.Distributed_isNULL)
		ci.setProperty("Distributed", instance.Distributed);

	if (!instance.MaxProcessesPerUser_isNULL)
		ci.setProperty("MaxProcessesPerUser", instance.MaxProcessesPerUser);

	_L_;
	return ci.getHdl();
}

void OS_OpenDRIM_OperatingSystem_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_OperatingSystem& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (op.getKey("CSCreationClassName", instance.CSCreationClassName) == OK)
		instance.CSCreationClassName_isNULL = false;

	if (op.getKey("CSName", instance.CSName) == OK)
		instance.CSName_isNULL = false;

	_L_;
}

void OS_OpenDRIM_OperatingSystem_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_OperatingSystem& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("CSCreationClassName", instance.CSCreationClassName) == OK)
		instance.CSCreationClassName_isNULL = false;

	if (inst.getProperty("CSName", instance.CSName) == OK)
		instance.CSName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OSType", instance.OSType) == OK)
		instance.OSType_isNULL = false;

	if (inst.getProperty("OtherTypeDescription", instance.OtherTypeDescription) == OK)
		instance.OtherTypeDescription_isNULL = false;

	if (inst.getProperty("Version", instance.Version) == OK)
		instance.Version_isNULL = false;

	if (inst.getPropertyDatetime("LastBootUpTime", instance.LastBootUpTime) == OK)
		instance.LastBootUpTime_isNULL = false;

	if (inst.getPropertyDatetime("LocalDateTime", instance.LocalDateTime) == OK)
		instance.LocalDateTime_isNULL = false;

	if (inst.getProperty("CurrentTimeZone", instance.CurrentTimeZone) == OK)
		instance.CurrentTimeZone_isNULL = false;

	if (inst.getProperty("NumberOfLicensedUsers", instance.NumberOfLicensedUsers) == OK)
		instance.NumberOfLicensedUsers_isNULL = false;

	if (inst.getProperty("NumberOfUsers", instance.NumberOfUsers) == OK)
		instance.NumberOfUsers_isNULL = false;

	if (inst.getProperty("NumberOfProcesses", instance.NumberOfProcesses) == OK)
		instance.NumberOfProcesses_isNULL = false;

	if (inst.getProperty("MaxNumberOfProcesses", instance.MaxNumberOfProcesses) == OK)
		instance.MaxNumberOfProcesses_isNULL = false;

	if (inst.getProperty("TotalSwapSpaceSize", instance.TotalSwapSpaceSize) == OK)
		instance.TotalSwapSpaceSize_isNULL = false;

	if (inst.getProperty("TotalVirtualMemorySize", instance.TotalVirtualMemorySize) == OK)
		instance.TotalVirtualMemorySize_isNULL = false;

	if (inst.getProperty("FreeVirtualMemory", instance.FreeVirtualMemory) == OK)
		instance.FreeVirtualMemory_isNULL = false;

	if (inst.getProperty("FreePhysicalMemory", instance.FreePhysicalMemory) == OK)
		instance.FreePhysicalMemory_isNULL = false;

	if (inst.getProperty("TotalVisibleMemorySize", instance.TotalVisibleMemorySize) == OK)
		instance.TotalVisibleMemorySize_isNULL = false;

	if (inst.getProperty("SizeStoredInPagingFiles", instance.SizeStoredInPagingFiles) == OK)
		instance.SizeStoredInPagingFiles_isNULL = false;

	if (inst.getProperty("FreeSpaceInPagingFiles", instance.FreeSpaceInPagingFiles) == OK)
		instance.FreeSpaceInPagingFiles_isNULL = false;

	if (inst.getProperty("MaxProcessMemorySize", instance.MaxProcessMemorySize) == OK)
		instance.MaxProcessMemorySize_isNULL = false;

	if (inst.getProperty("Distributed", instance.Distributed) == OK)
		instance.Distributed_isNULL = false;

	if (inst.getProperty("MaxProcessesPerUser", instance.MaxProcessesPerUser) == OK)
		instance.MaxProcessesPerUser_isNULL = false;

	_L_;
}

void OS_OpenDRIM_OperatingSystem_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_OperatingSystem_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void OS_OpenDRIM_OperatingSystem_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_OperatingSystem_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
