/*  This file is part of the KDE project
    Copyright (C) 2009 Cyrille Berger <cberger@cberger.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef GTLTEST_EXPORT_H
#define GTLTEST_EXPORT_H

/* needed for GTL_EXPORT and GTL_IMPORT macros */
#include <GTLCore/Macros.h>

#ifndef GTLTEST_EXPORT
# if defined(GTLTest_EXPORTS)
   /* We are building this library */ 
#  define GTLTEST_EXPORT GTL_EXPORT
# else
   /* We are using this library */ 
#  define GTLTEST_EXPORT GTL_IMPORT
# endif
#endif

# ifndef GTLTEST_EXPORT_DEPRECATED
#  define GTLTEST_EXPORT_DEPRECATED GTL_DEPRECATED GTLTEST_EXPORT
# endif

# ifdef OPENGTL_ENABLE_TESTS
#  define GTLTEST_TESTS_EXPORT GTLTEST_EXPORT
# else
#  define GTLTEST_TESTS_EXPORT
# endif

#ifdef OPENGTL_ENABLE_DEBUG_OUTPUT
#  define GTLTEST_DEBUG_EXPORT GTLTEST_EXPORT
# else
#  define GTLTEST_DEBUG_EXPORT
# endif

#endif
