/* $Id: prefs_options.c,v 1.7 2005-10-11 15:09:55 bh Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Jan-Oliver Wagner <jan@intevation.de> (2004)
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

/**
 * @file
 * Triggers building of most of the right part of the GUI (a listnotebook with
 * many pages with options in it).
 * GUI Management via an arglist with following entries:
 *  - SCAN_OPTIONS
 *  - PLUGINS
 *  - PLUGINS_PREFS
 * -  TARGET
 * -  MAIN
 * -  USER
 * -  SAVE_KB
 */

#include <includes.h>

#include <gtk/gtk.h>

#include "prefs_dialog_scan_opt.h"
#include "prefs_plugins.h"
#include "prefs_dialog_plugins_prefs.h"
#include "prefs_target.h"
#include "prefs_dialog_user.h"
#ifdef ENABLE_SAVE_KB
# include "prefs_kb.h"
#endif

#include "listnotebook.h"
#include "nessus_i18n.h"


/**
 * Build a vbox element with a notebook for the configuration
 * options subgroups (Currently General, Plugins, Credentials, Target Selection,
 * Access Rules, Prefs., KB).
 * @param context
 * @param ctrls
 * @return
 */
struct arglist *
prefs_dialog_options(struct context * context, struct arglist * ctrls)
{
  struct arglist * prefs_scan;
  struct arglist * prefs_plugins;
  struct arglist * prefs_plugins_prefs;
  struct arglist * prefs_target;
  struct arglist * prefs_user;
#ifdef ENABLE_SAVE_KB
  struct arglist * prefs_kb;
#endif
  GtkWidget * box;
  GtkWidget * listnotebook;
  GtkTooltips * tooltips;

  tooltips = gtk_tooltips_new();

  /* Set up a box */
  box = gtk_hbox_new(FALSE, FALSE);
  arg_add_value(ctrls, "VBOX", ARG_PTR, -1, box);
  gtk_widget_show(box);

  /* Create the notebook */
  listnotebook = listnotebook_new(TRUE, FALSE);
  gtk_widget_show(listnotebook);
  arg_add_value(ctrls, "NOTEBOOK", ARG_PTR, -1,
      g_object_get_data(G_OBJECT(listnotebook), "notebook"));
  gtk_box_pack_start(GTK_BOX(box), listnotebook, TRUE, TRUE, 0);

  /*
   * Set up the pages of the notebook
   */
  prefs_scan = prefs_dialog_scan_opt(context);
  prefs_plugins = prefs_dialog_plugins(context);
  prefs_plugins_prefs = prefs_dialog_plugins_prefs();
  prefs_target = prefs_dialog_target();
  prefs_user = prefs_dialog_user();
  prefs_kb = prefs_dialog_kb(); 
  arg_add_value(ctrls, "SCAN_OPTIONS", ARG_ARGLIST, -1, prefs_scan);
  arg_add_value(ctrls, "PLUGINS", ARG_ARGLIST, -1, prefs_plugins);
  arg_add_value(ctrls, "PLUGINS_PREFS", ARG_ARGLIST, -1, prefs_plugins_prefs);
  arg_add_value(ctrls, "TARGET", ARG_ARGLIST, -1, prefs_target);
  arg_add_value(prefs_target, "MAIN", ARG_ARGLIST, -1, ctrls);
  arg_add_value(ctrls, "USER", ARG_ARGLIST, -1, prefs_user);
  arg_add_value(ctrls, "SAVE_KB", ARG_ARGLIST, -1, prefs_kb);

  /* The Scan options page */
  listnotebook_add_page(listnotebook, arg_get_value(prefs_scan, "FRAME"),
      _("General"), "nessus-general-prefs");

  /* The Plugins selection page */
  listnotebook_add_page(listnotebook, arg_get_value(prefs_plugins, "FRAME"),
      _("Plugins"), "nessus-plugins");

  /* The Credentials selection page */
  listnotebook_add_page(listnotebook, arg_get_value(prefs_plugins_prefs,
	  "FRAME_CREDENTIALS"), _("Credentials"), "nessus-credentials");

  /* The target selection page */
  listnotebook_add_page(listnotebook, arg_get_value(prefs_target, "FRAME"),
      _("Target selection"), "nessus-target-selection");

  /* The User-defined Access Rules page */
  listnotebook_add_page(listnotebook, arg_get_value(prefs_user, "FRAME"),
      _("Access Rules"), "nessus-access-rules");

  /* The Plugin preferences page */
  listnotebook_add_page(listnotebook, arg_get_value(prefs_plugins_prefs,
	  "FRAME"), _("Prefs."), "nessus-prefs");
  
  /* The Knowledge Base page */
#ifdef ENABLE_SAVE_KB
  listnotebook_add_page(listnotebook, arg_get_value(prefs_kb, "FRAME"), _("KB"),
      "nessus-knowledge-base");
#endif

  listnotebook_select_page(listnotebook, 0);

  gtk_tooltips_enable(tooltips);

  return ctrls;
}
